/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms;

import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.apache.beam.sdk.coders.CannotProvideCoderException;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderRegistry;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.SimpleFunction;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.vendor.guava.v20_0.com.google.common.base.Preconditions;

public class WithKeys<K, V>
extends PTransform<PCollection<V>, PCollection<KV<K, V>>> {
    private SerializableFunction<V, K> fn;
    @CheckForNull
    private transient Class<K> keyClass;

    public static <K, V> WithKeys<K, V> of(SerializableFunction<V, K> fn) {
        Preconditions.checkNotNull(fn, "WithKeys constructed with null function. Did you mean WithKeys.of((Void) null)?");
        return new WithKeys<K, V>(fn, null);
    }

    public static <K, V> WithKeys<K, V> of(@Nullable K key) {
        return new WithKeys<Void, Object>(value -> key, key == null ? Void.class : key.getClass());
    }

    private WithKeys(SerializableFunction<V, K> fn, Class<K> keyClass) {
        this.fn = fn;
        this.keyClass = keyClass;
    }

    public WithKeys<K, V> withKeyType(TypeDescriptor<K> keyType) {
        Class<K> rawType = keyType.getRawType();
        return new WithKeys<K, V>(this.fn, rawType);
    }

    @Override
    public PCollection<KV<K, V>> expand(PCollection<V> in) {
        PCollection result = (PCollection)in.apply("AddKeys", MapElements.via(new SimpleFunction<V, KV<K, V>>(){

            @Override
            public KV<K, V> apply(V element) {
                return KV.of(WithKeys.this.fn.apply(element), element);
            }
        }));
        try {
            CoderRegistry coderRegistry = in.getPipeline().getCoderRegistry();
            Coder<K> keyCoder = this.keyClass == null ? coderRegistry.getOutputCoder(this.fn, in.getCoder()) : coderRegistry.getCoder(TypeDescriptor.of(this.keyClass));
            result.setCoder(KvCoder.of(keyCoder, in.getCoder()));
        }
        catch (CannotProvideCoderException cannotProvideCoderException) {
            // empty catch block
        }
        return result;
    }
}

