/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms.display;

import javax.annotation.Nullable;
import org.apache.beam.sdk.transforms.display.DisplayData;

final class AutoValue_DisplayData_ItemSpec<T>
extends DisplayData.ItemSpec<T> {
    private final Class<?> namespace;
    private final String key;
    private final DisplayData.Type type;
    private final Object value;
    private final Object shortValue;
    private final String label;
    private final String linkUrl;

    private AutoValue_DisplayData_ItemSpec(@Nullable Class<?> namespace, String key, DisplayData.Type type, @Nullable Object value, @Nullable Object shortValue, @Nullable String label, @Nullable String linkUrl) {
        this.namespace = namespace;
        this.key = key;
        this.type = type;
        this.value = value;
        this.shortValue = shortValue;
        this.label = label;
        this.linkUrl = linkUrl;
    }

    @Override
    @Nullable
    public Class<?> getNamespace() {
        return this.namespace;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public DisplayData.Type getType() {
        return this.type;
    }

    @Override
    @Nullable
    public Object getValue() {
        return this.value;
    }

    @Override
    @Nullable
    public Object getShortValue() {
        return this.shortValue;
    }

    @Override
    @Nullable
    public String getLabel() {
        return this.label;
    }

    @Override
    @Nullable
    public String getLinkUrl() {
        return this.linkUrl;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof DisplayData.ItemSpec) {
            DisplayData.ItemSpec that = (DisplayData.ItemSpec)o;
            return (this.namespace == null ? that.getNamespace() == null : this.namespace.equals(that.getNamespace())) && this.key.equals(that.getKey()) && this.type.equals((Object)that.getType()) && (this.value == null ? that.getValue() == null : this.value.equals(that.getValue())) && (this.shortValue == null ? that.getShortValue() == null : this.shortValue.equals(that.getShortValue())) && (this.label == null ? that.getLabel() == null : this.label.equals(that.getLabel())) && (this.linkUrl == null ? that.getLinkUrl() == null : this.linkUrl.equals(that.getLinkUrl()));
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.namespace == null ? 0 : this.namespace.hashCode();
        h$ *= 1000003;
        h$ ^= this.key.hashCode();
        h$ *= 1000003;
        h$ ^= this.type.hashCode();
        h$ *= 1000003;
        h$ ^= this.value == null ? 0 : this.value.hashCode();
        h$ *= 1000003;
        h$ ^= this.shortValue == null ? 0 : this.shortValue.hashCode();
        h$ *= 1000003;
        h$ ^= this.label == null ? 0 : this.label.hashCode();
        h$ *= 1000003;
        return h$ ^= this.linkUrl == null ? 0 : this.linkUrl.hashCode();
    }

    @Override
    DisplayData.ItemSpec.Builder<T> toBuilder() {
        return new Builder(this);
    }

    static final class Builder<T>
    extends DisplayData.ItemSpec.Builder<T> {
        private Class<?> namespace;
        private String key;
        private DisplayData.Type type;
        private Object value;
        private Object shortValue;
        private String label;
        private String linkUrl;

        Builder() {
        }

        private Builder(DisplayData.ItemSpec<T> source) {
            this.namespace = source.getNamespace();
            this.key = source.getKey();
            this.type = source.getType();
            this.value = source.getValue();
            this.shortValue = source.getShortValue();
            this.label = source.getLabel();
            this.linkUrl = source.getLinkUrl();
        }

        @Override
        public DisplayData.ItemSpec.Builder<T> setNamespace(@Nullable Class<?> namespace) {
            this.namespace = namespace;
            return this;
        }

        @Override
        public DisplayData.ItemSpec.Builder<T> setKey(String key) {
            if (key == null) {
                throw new NullPointerException("Null key");
            }
            this.key = key;
            return this;
        }

        @Override
        public DisplayData.ItemSpec.Builder<T> setType(DisplayData.Type type) {
            if (type == null) {
                throw new NullPointerException("Null type");
            }
            this.type = type;
            return this;
        }

        @Override
        DisplayData.Type getType() {
            if (this.type == null) {
                throw new IllegalStateException("Property \"type\" has not been set");
            }
            return this.type;
        }

        @Override
        public DisplayData.ItemSpec.Builder<T> setValue(@Nullable Object value) {
            this.value = value;
            return this;
        }

        @Override
        public DisplayData.ItemSpec.Builder<T> setShortValue(@Nullable Object shortValue) {
            this.shortValue = shortValue;
            return this;
        }

        @Override
        public DisplayData.ItemSpec.Builder<T> setLabel(@Nullable String label) {
            this.label = label;
            return this;
        }

        @Override
        public DisplayData.ItemSpec.Builder<T> setLinkUrl(@Nullable String linkUrl) {
            this.linkUrl = linkUrl;
            return this;
        }

        @Override
        public DisplayData.ItemSpec<T> build() {
            String missing = "";
            if (this.key == null) {
                missing = missing + " key";
            }
            if (this.type == null) {
                missing = missing + " type";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_DisplayData_ItemSpec(this.namespace, this.key, this.type, this.value, this.shortValue, this.label, this.linkUrl);
        }
    }
}

