/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms.join;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.List;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.coders.StructuredCoder;
import org.apache.beam.sdk.transforms.join.RawUnionValue;
import org.apache.beam.sdk.util.VarInt;
import org.apache.beam.sdk.util.common.ElementByteSizeObserver;

public class UnionCoder
extends StructuredCoder<RawUnionValue> {
    private final List<Coder<?>> elementCoders;

    public static UnionCoder of(List<Coder<?>> elementCoders) {
        return new UnionCoder(elementCoders);
    }

    private int getIndexForEncoding(RawUnionValue union) {
        if (union == null) {
            throw new IllegalArgumentException("cannot encode a null tagged union");
        }
        int index = union.getUnionTag();
        if (index < 0 || index >= this.elementCoders.size()) {
            throw new IllegalArgumentException("union value index " + index + " not in range [0.." + (this.elementCoders.size() - 1) + "]");
        }
        return index;
    }

    @Override
    public void encode(RawUnionValue union, OutputStream outStream) throws IOException, CoderException {
        this.encode(union, outStream, Coder.Context.NESTED);
    }

    @Override
    public void encode(RawUnionValue union, OutputStream outStream, Coder.Context context) throws IOException, CoderException {
        int index = this.getIndexForEncoding(union);
        VarInt.encode(index, outStream);
        Coder<?> coder = this.elementCoders.get(index);
        coder.encode(union.getValue(), outStream, context);
    }

    @Override
    public RawUnionValue decode(InputStream inStream) throws IOException, CoderException {
        return this.decode(inStream, Coder.Context.NESTED);
    }

    @Override
    public RawUnionValue decode(InputStream inStream, Coder.Context context) throws IOException, CoderException {
        int index = VarInt.decodeInt(inStream);
        Object value = this.elementCoders.get(index).decode(inStream, context);
        return new RawUnionValue(index, value);
    }

    @Override
    public List<? extends Coder<?>> getCoderArguments() {
        return Collections.emptyList();
    }

    @Override
    public List<? extends Coder<?>> getComponents() {
        return this.elementCoders;
    }

    public List<? extends Coder<?>> getElementCoders() {
        return this.elementCoders;
    }

    @Override
    public boolean isRegisterByteSizeObserverCheap(RawUnionValue union) {
        int index = this.getIndexForEncoding(union);
        Coder<?> coder = this.elementCoders.get(index);
        return coder.isRegisterByteSizeObserverCheap(union.getValue());
    }

    @Override
    public void registerByteSizeObserver(RawUnionValue union, ElementByteSizeObserver observer) throws Exception {
        int index = this.getIndexForEncoding(union);
        observer.update(VarInt.getLength(index));
        Coder<?> coder = this.elementCoders.get(index);
        coder.registerByteSizeObserver(union.getValue(), observer);
    }

    private UnionCoder(List<Coder<?>> elementCoders) {
        this.elementCoders = elementCoders;
    }

    @Override
    public void verifyDeterministic() throws Coder.NonDeterministicException {
        UnionCoder.verifyDeterministic(this, "UnionCoder is only deterministic if all element coders are", this.elementCoders);
    }
}

