/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms.reflect;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.ExecutionException;
import org.apache.beam.repackaged.core.net.bytebuddy.ByteBuddy;
import org.apache.beam.repackaged.core.net.bytebuddy.description.field.FieldDescription;
import org.apache.beam.repackaged.core.net.bytebuddy.description.field.FieldList;
import org.apache.beam.repackaged.core.net.bytebuddy.description.method.MethodDescription;
import org.apache.beam.repackaged.core.net.bytebuddy.description.method.MethodList;
import org.apache.beam.repackaged.core.net.bytebuddy.description.modifier.FieldManifestation;
import org.apache.beam.repackaged.core.net.bytebuddy.description.modifier.Visibility;
import org.apache.beam.repackaged.core.net.bytebuddy.description.type.TypeDescription;
import org.apache.beam.repackaged.core.net.bytebuddy.dynamic.DynamicType;
import org.apache.beam.repackaged.core.net.bytebuddy.dynamic.loading.ClassLoadingStrategy;
import org.apache.beam.repackaged.core.net.bytebuddy.dynamic.scaffold.InstrumentedType;
import org.apache.beam.repackaged.core.net.bytebuddy.dynamic.scaffold.subclass.ConstructorStrategy;
import org.apache.beam.repackaged.core.net.bytebuddy.implementation.Implementation;
import org.apache.beam.repackaged.core.net.bytebuddy.implementation.bytecode.ByteCodeAppender;
import org.apache.beam.repackaged.core.net.bytebuddy.implementation.bytecode.StackManipulation;
import org.apache.beam.repackaged.core.net.bytebuddy.implementation.bytecode.member.FieldAccess;
import org.apache.beam.repackaged.core.net.bytebuddy.implementation.bytecode.member.MethodInvocation;
import org.apache.beam.repackaged.core.net.bytebuddy.implementation.bytecode.member.MethodReturn;
import org.apache.beam.repackaged.core.net.bytebuddy.implementation.bytecode.member.MethodVariableAccess;
import org.apache.beam.repackaged.core.net.bytebuddy.matcher.ElementMatchers;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.reflect.ByteBuddyDoFnInvokerFactory;
import org.apache.beam.sdk.transforms.reflect.DoFnSignature;
import org.apache.beam.sdk.transforms.reflect.DoFnSignatures;
import org.apache.beam.sdk.transforms.reflect.OnTimerInvoker;
import org.apache.beam.sdk.transforms.reflect.OnTimerInvokerFactory;
import org.apache.beam.sdk.transforms.reflect.OnTimerMethodSpecifier;
import org.apache.beam.sdk.transforms.reflect.StableInvokerNamingStrategy;
import org.apache.beam.sdk.util.common.ReflectHelpers;
import org.apache.beam.vendor.guava.v20_0.com.google.common.base.CharMatcher;
import org.apache.beam.vendor.guava.v20_0.com.google.common.base.Charsets;
import org.apache.beam.vendor.guava.v20_0.com.google.common.cache.CacheBuilder;
import org.apache.beam.vendor.guava.v20_0.com.google.common.cache.CacheLoader;
import org.apache.beam.vendor.guava.v20_0.com.google.common.cache.LoadingCache;
import org.apache.beam.vendor.guava.v20_0.com.google.common.io.BaseEncoding;

class ByteBuddyOnTimerInvokerFactory
implements OnTimerInvokerFactory {
    private static final ByteBuddyOnTimerInvokerFactory INSTANCE = new ByteBuddyOnTimerInvokerFactory();
    private static final String FN_DELEGATE_FIELD_NAME = "delegate";
    private final LoadingCache<OnTimerMethodSpecifier, Constructor<?>> constructorCache = CacheBuilder.newBuilder().build(new CacheLoader<OnTimerMethodSpecifier, Constructor<?>>(){

        @Override
        public Constructor<?> load(OnTimerMethodSpecifier onTimerMethodSpecifier) throws Exception {
            DoFnSignature signature = DoFnSignatures.getSignature(onTimerMethodSpecifier.fnClass());
            Class invokerClass = ByteBuddyOnTimerInvokerFactory.generateOnTimerInvokerClass(signature, onTimerMethodSpecifier.timerId());
            try {
                return invokerClass.getConstructor(signature.fnClass());
            }
            catch (IllegalArgumentException | NoSuchMethodException | SecurityException e) {
                throw new RuntimeException(e);
            }
        }
    });

    @Override
    public <InputT, OutputT> OnTimerInvoker<InputT, OutputT> forTimer(DoFn<InputT, OutputT> fn, String timerId) {
        Class<?> fnClass = fn.getClass();
        try {
            OnTimerMethodSpecifier onTimerMethodSpecifier = OnTimerMethodSpecifier.forClassAndTimerId(fnClass, timerId);
            Constructor<?> constructor = this.constructorCache.get(onTimerMethodSpecifier);
            return (OnTimerInvoker)constructor.newInstance(fn);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | SecurityException | InvocationTargetException | ExecutionException e) {
            throw new RuntimeException(String.format("Unable to construct @%s invoker for %s", DoFn.OnTimer.class.getSimpleName(), fn.getClass().getName()), e);
        }
    }

    public static ByteBuddyOnTimerInvokerFactory only() {
        return INSTANCE;
    }

    private ByteBuddyOnTimerInvokerFactory() {
    }

    private static Class<? extends OnTimerInvoker<?, ?>> generateOnTimerInvokerClass(DoFnSignature signature, String timerId) {
        Class<DoFn<?, ?>> fnClass = signature.fnClass();
        TypeDescription.ForLoadedType clazzDescription = new TypeDescription.ForLoadedType(fnClass);
        String suffix = String.format("%s$%s$%s", OnTimerInvoker.class.getSimpleName(), CharMatcher.javaLetterOrDigit().retainFrom(timerId), BaseEncoding.base64().omitPadding().encode(timerId.getBytes(Charsets.UTF_8)));
        DynamicType.Builder.MethodDefinition.ReceiverTypeDefinition builder = new ByteBuddy().with(StableInvokerNamingStrategy.forDoFnClass(fnClass).withSuffix(suffix)).subclass(OnTimerInvoker.class, (ConstructorStrategy)ConstructorStrategy.Default.NO_CONSTRUCTORS).defineField(FN_DELEGATE_FIELD_NAME, fnClass, Visibility.PRIVATE, FieldManifestation.FINAL).defineConstructor(Visibility.PUBLIC).withParameter(fnClass).intercept(new InvokerConstructor()).method(ElementMatchers.named("invokeOnTimer")).intercept(new InvokeOnTimerDelegation((TypeDescription)clazzDescription, signature.onTimerMethods().get(timerId)));
        DynamicType.Unloaded unloaded = builder.make();
        Class res = unloaded.load(ReflectHelpers.findClassLoader(fnClass.getClassLoader()), ClassLoadingStrategy.Default.INJECTION).getLoaded();
        return res;
    }

    private static final class InvokerConstructor
    implements Implementation {
        private InvokerConstructor() {
        }

        @Override
        public InstrumentedType prepare(InstrumentedType instrumentedType) {
            return instrumentedType;
        }

        @Override
        public ByteCodeAppender appender(Implementation.Target implementationTarget) {
            return (methodVisitor, implementationContext, instrumentedMethod) -> {
                StackManipulation.Size size = new StackManipulation.Compound(MethodVariableAccess.REFERENCE.loadFrom(0), MethodInvocation.invoke((MethodDescription.InDefinedShape)((MethodList)new TypeDescription.ForLoadedType(Object.class).getDeclaredMethods().filter(ElementMatchers.isConstructor().and(ElementMatchers.takesArguments(0)))).getOnly()), MethodVariableAccess.REFERENCE.loadFrom(0), MethodVariableAccess.REFERENCE.loadFrom(1), FieldAccess.forField((FieldDescription.InDefinedShape)((FieldList)implementationTarget.getInstrumentedType().getDeclaredFields().filter(ElementMatchers.named(ByteBuddyOnTimerInvokerFactory.FN_DELEGATE_FIELD_NAME))).getOnly()).write(), MethodReturn.VOID).apply(methodVisitor, implementationContext);
                return new ByteCodeAppender.Size(size.getMaximalSize(), instrumentedMethod.getStackSize());
            };
        }
    }

    private static class InvokeOnTimerDelegation
    extends ByteBuddyDoFnInvokerFactory.DoFnMethodWithExtraParametersDelegation {
        private final DoFnSignature.OnTimerMethod signature;

        public InvokeOnTimerDelegation(TypeDescription clazzDescription, DoFnSignature.OnTimerMethod signature) {
            super(clazzDescription, signature);
            this.signature = signature;
        }

        @Override
        public InstrumentedType prepare(InstrumentedType instrumentedType) {
            this.delegateField = (FieldDescription)((FieldList)instrumentedType.getDeclaredFields().filter(ElementMatchers.named(ByteBuddyOnTimerInvokerFactory.FN_DELEGATE_FIELD_NAME))).getOnly();
            return instrumentedType;
        }
    }
}

