/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms.splittabledofn;

import java.math.BigDecimal;
import javax.annotation.Nullable;
import org.apache.beam.sdk.io.range.ByteKey;
import org.apache.beam.sdk.io.range.ByteKeyRange;
import org.apache.beam.sdk.transforms.splittabledofn.Backlog;
import org.apache.beam.sdk.transforms.splittabledofn.Backlogs;
import org.apache.beam.sdk.transforms.splittabledofn.RestrictionTracker;
import org.apache.beam.vendor.guava.v20_0.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v20_0.com.google.common.base.MoreObjects;
import org.apache.beam.vendor.guava.v20_0.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v20_0.com.google.common.primitives.Bytes;

public class ByteKeyRangeTracker
extends RestrictionTracker<ByteKeyRange, ByteKey>
implements Backlogs.HasBacklog {
    @VisibleForTesting
    static final ByteKeyRange NO_KEYS = ByteKeyRange.of(ByteKey.EMPTY, ByteKey.of(0));
    private ByteKeyRange range;
    @Nullable
    private ByteKey lastClaimedKey = null;
    @Nullable
    private ByteKey lastAttemptedKey = null;
    private static final byte[] ZERO_BYTE_ARRAY = new byte[]{0};

    private ByteKeyRangeTracker(ByteKeyRange range) {
        this.range = Preconditions.checkNotNull(range);
    }

    public static ByteKeyRangeTracker of(ByteKeyRange range) {
        return new ByteKeyRangeTracker(ByteKeyRange.of(range.getStartKey(), range.getEndKey()));
    }

    @Override
    public ByteKeyRange currentRestriction() {
        return this.range;
    }

    @Override
    public ByteKeyRange checkpoint() {
        if (this.lastAttemptedKey == null) {
            ByteKeyRange rval = this.range;
            this.range = NO_KEYS;
            return rval;
        }
        if (this.lastAttemptedKey.isEmpty() || !this.range.getEndKey().isEmpty() && this.range.getEndKey().compareTo(this.lastAttemptedKey) <= 0) {
            return NO_KEYS;
        }
        assert (this.lastAttemptedKey.equals(this.lastClaimedKey)) : "Expect both keys to be equal since the last key attempted was a valid key in the range.";
        ByteKey nextKey = ByteKeyRangeTracker.next(this.lastAttemptedKey);
        ByteKeyRange res = ByteKeyRange.of(nextKey, this.range.getEndKey());
        this.range = ByteKeyRange.of(this.range.getStartKey(), nextKey);
        return res;
    }

    @Override
    public boolean tryClaim(ByteKey key) {
        if (key.isEmpty()) {
            Preconditions.checkArgument(this.lastAttemptedKey == null || !this.lastAttemptedKey.isEmpty(), "Trying to claim key %s while last attempted key was %s", (Object)key, (Object)this.lastAttemptedKey);
            this.lastAttemptedKey = key;
            return false;
        }
        Preconditions.checkArgument(this.lastAttemptedKey == null || key.compareTo(this.lastAttemptedKey) > 0, "Trying to claim key %s while last attempted key was %s", (Object)key, (Object)this.lastAttemptedKey);
        Preconditions.checkArgument(key.compareTo(this.range.getStartKey()) > -1, "Trying to claim key %s before start of the range %s", (Object)key, (Object)this.range);
        this.lastAttemptedKey = key;
        if (!this.range.getEndKey().isEmpty() && key.compareTo(this.range.getEndKey()) > -1) {
            return false;
        }
        this.lastClaimedKey = key;
        return true;
    }

    @Override
    public void checkDone() throws IllegalStateException {
        if (NO_KEYS.equals(this.range)) {
            return;
        }
        Preconditions.checkState(this.lastAttemptedKey != null, "Key range is non-empty %s and no keys have been attempted.", (Object)this.range);
        if (this.lastAttemptedKey.isEmpty()) {
            return;
        }
        if (this.range.getEndKey().isEmpty() || this.range.getEndKey().compareTo(this.lastAttemptedKey) > 0) {
            ByteKey nextKey = ByteKeyRangeTracker.next(this.lastAttemptedKey);
            throw new IllegalStateException(String.format("Last attempted key was %s in range %s, claiming work in [%s, %s) was not attempted", this.lastAttemptedKey, this.range, nextKey, this.range.getEndKey()));
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("range", this.range).add("lastClaimedKey", this.lastClaimedKey).add("lastAttemptedKey", this.lastAttemptedKey).toString();
    }

    @VisibleForTesting
    static ByteKey next(ByteKey key) {
        return ByteKey.copyFrom(Bytes.concat(key.getBytes(), ZERO_BYTE_ARRAY));
    }

    @Override
    public Backlog getBacklog() {
        if (NO_KEYS.equals(this.range)) {
            return Backlog.of(BigDecimal.ZERO);
        }
        if (this.lastAttemptedKey == null) {
            return Backlog.of(BigDecimal.ONE);
        }
        if (this.lastAttemptedKey.isEmpty() || !this.range.getEndKey().isEmpty() && this.range.getEndKey().compareTo(this.lastAttemptedKey) <= 0) {
            return Backlog.of(BigDecimal.ZERO);
        }
        return Backlog.of(BigDecimal.valueOf(this.range.estimateFractionForKey(this.lastAttemptedKey)));
    }
}

