/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms.windowing;

import com.google.auto.value.AutoValue;
import java.util.Collection;
import java.util.Collections;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.transforms.windowing.AutoValue_GlobalWindows_GlobalWindowMappingFn;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.GlobalWindow;
import org.apache.beam.sdk.transforms.windowing.IncompatibleWindowException;
import org.apache.beam.sdk.transforms.windowing.NonMergingWindowFn;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.transforms.windowing.WindowMappingFn;
import org.joda.time.Instant;

public class GlobalWindows
extends NonMergingWindowFn<Object, GlobalWindow> {
    private static final Collection<GlobalWindow> GLOBAL_WINDOWS = Collections.singletonList(GlobalWindow.INSTANCE);

    @Override
    public Collection<GlobalWindow> assignWindows(WindowFn.AssignContext c) {
        return GLOBAL_WINDOWS;
    }

    @Override
    public boolean isCompatible(WindowFn<?, ?> o) {
        return o instanceof GlobalWindows;
    }

    @Override
    public void verifyCompatibility(WindowFn<?, ?> other) throws IncompatibleWindowException {
        if (!this.isCompatible(other)) {
            throw new IncompatibleWindowException(other, String.format("%s is only compatible with %s.", GlobalWindows.class.getSimpleName(), GlobalWindows.class.getSimpleName()));
        }
    }

    @Override
    public Coder<GlobalWindow> windowCoder() {
        return GlobalWindow.Coder.INSTANCE;
    }

    @Override
    public WindowMappingFn<GlobalWindow> getDefaultWindowMappingFn() {
        return new AutoValue_GlobalWindows_GlobalWindowMappingFn();
    }

    @Override
    public Instant getOutputTime(Instant inputTimestamp, GlobalWindow window) {
        return inputTimestamp;
    }

    @Override
    public boolean assignsToOneWindow() {
        return true;
    }

    public boolean equals(Object other) {
        return other instanceof GlobalWindows;
    }

    public int hashCode() {
        return GlobalWindows.class.hashCode();
    }

    public String toString() {
        return this.getClass().getCanonicalName();
    }

    @AutoValue
    static abstract class GlobalWindowMappingFn
    extends WindowMappingFn<GlobalWindow> {
        GlobalWindowMappingFn() {
        }

        @Override
        public GlobalWindow getSideInputWindow(BoundedWindow mainWindow) {
            return GlobalWindow.INSTANCE;
        }
    }
}

