/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms.windowing;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Objects;
import org.apache.beam.sdk.coders.AtomicCoder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.util.VarInt;
import org.apache.beam.vendor.guava.v20_0.com.google.common.base.MoreObjects;
import org.apache.beam.vendor.guava.v20_0.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.ImmutableMap;

public final class PaneInfo {
    private static final ImmutableMap<Byte, PaneInfo> BYTE_TO_PANE_INFO;
    private final byte encodedByte;
    private final boolean isFirst;
    private final boolean isLast;
    private final Timing timing;
    private final long index;
    private final long nonSpeculativeIndex;
    public static final PaneInfo NO_FIRING;
    public static final PaneInfo ON_TIME_AND_ONLY_FIRING;

    private static byte encodedByte(boolean isFirst, boolean isLast, Timing timing) {
        byte result = 0;
        if (isFirst) {
            result = (byte)(result | 1);
        }
        if (isLast) {
            result = (byte)(result | 2);
        }
        result = (byte)(result | (byte)(timing.ordinal() << 2));
        return result;
    }

    private static void register(ImmutableMap.Builder<Byte, PaneInfo> builder, PaneInfo info) {
        builder.put(info.encodedByte, info);
    }

    private PaneInfo(boolean isFirst, boolean isLast, Timing timing, long index, long onTimeIndex) {
        this.encodedByte = PaneInfo.encodedByte(isFirst, isLast, timing);
        this.isFirst = isFirst;
        this.isLast = isLast;
        this.timing = timing;
        this.index = index;
        this.nonSpeculativeIndex = onTimeIndex;
    }

    public static PaneInfo createPane(boolean isFirst, boolean isLast, Timing timing) {
        Preconditions.checkArgument(isFirst, "Indices must be provided for non-first pane info.");
        return PaneInfo.createPane(isFirst, isLast, timing, 0L, timing == Timing.EARLY ? -1L : 0L);
    }

    public static PaneInfo createPane(boolean isFirst, boolean isLast, Timing timing, long index, long onTimeIndex) {
        if (isFirst || timing == Timing.UNKNOWN) {
            return Preconditions.checkNotNull(BYTE_TO_PANE_INFO.get(PaneInfo.encodedByte(isFirst, isLast, timing)));
        }
        return new PaneInfo(isFirst, isLast, timing, index, onTimeIndex);
    }

    public static PaneInfo decodePane(byte encodedPane) {
        return Preconditions.checkNotNull(BYTE_TO_PANE_INFO.get(encodedPane));
    }

    public boolean isUnknown() {
        return Timing.UNKNOWN.equals((Object)this.timing);
    }

    public boolean isFirst() {
        return this.isFirst;
    }

    public boolean isLast() {
        return this.isLast;
    }

    public Timing getTiming() {
        return this.timing;
    }

    public long getIndex() {
        return this.index;
    }

    public long getNonSpeculativeIndex() {
        return this.nonSpeculativeIndex;
    }

    int getEncodedByte() {
        return this.encodedByte;
    }

    public int hashCode() {
        return Objects.hash(this.encodedByte, this.index, this.nonSpeculativeIndex);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof PaneInfo) {
            PaneInfo that = (PaneInfo)obj;
            return this.encodedByte == that.encodedByte && this.index == that.index && this.nonSpeculativeIndex == that.nonSpeculativeIndex;
        }
        return false;
    }

    public String toString() {
        if (this.equals(NO_FIRING)) {
            return "PaneInfo.NO_FIRING";
        }
        return MoreObjects.toStringHelper(this.getClass()).omitNullValues().add("isFirst", this.isFirst ? Boolean.valueOf(true) : null).add("isLast", this.isLast ? Boolean.valueOf(true) : null).add("timing", (Object)this.timing).add("index", this.index).add("onTimeIndex", this.nonSpeculativeIndex != -1L ? Long.valueOf(this.nonSpeculativeIndex) : null).toString();
    }

    static {
        ImmutableMap.Builder<Byte, PaneInfo> decodingBuilder = ImmutableMap.builder();
        for (Timing timing : Timing.values()) {
            long onTimeIndex = timing == Timing.EARLY ? -1L : 0L;
            PaneInfo.register(decodingBuilder, new PaneInfo(true, true, timing, 0L, onTimeIndex));
            PaneInfo.register(decodingBuilder, new PaneInfo(true, false, timing, 0L, onTimeIndex));
            PaneInfo.register(decodingBuilder, new PaneInfo(false, true, timing, -1L, onTimeIndex));
            PaneInfo.register(decodingBuilder, new PaneInfo(false, false, timing, -1L, onTimeIndex));
        }
        BYTE_TO_PANE_INFO = decodingBuilder.build();
        NO_FIRING = PaneInfo.createPane(true, true, Timing.UNKNOWN, 0L, 0L);
        ON_TIME_AND_ONLY_FIRING = PaneInfo.createPane(true, true, Timing.ON_TIME, 0L, 0L);
    }

    public static class PaneInfoCoder
    extends AtomicCoder<PaneInfo> {
        public static final PaneInfoCoder INSTANCE = new PaneInfoCoder();

        private Encoding chooseEncoding(PaneInfo value) {
            if (value.index == 0L && value.nonSpeculativeIndex == 0L || value.timing == Timing.UNKNOWN) {
                return Encoding.FIRST;
            }
            if (value.index == value.nonSpeculativeIndex || value.timing == Timing.EARLY) {
                return Encoding.ONE_INDEX;
            }
            return Encoding.TWO_INDICES;
        }

        public static PaneInfoCoder of() {
            return INSTANCE;
        }

        private PaneInfoCoder() {
        }

        @Override
        public void encode(PaneInfo value, OutputStream outStream) throws CoderException, IOException {
            Encoding encoding = this.chooseEncoding(value);
            switch (this.chooseEncoding(value)) {
                case FIRST: {
                    outStream.write(value.encodedByte);
                    break;
                }
                case ONE_INDEX: {
                    outStream.write(value.encodedByte | encoding.tag);
                    VarInt.encode(value.index, outStream);
                    break;
                }
                case TWO_INDICES: {
                    outStream.write(value.encodedByte | encoding.tag);
                    VarInt.encode(value.index, outStream);
                    VarInt.encode(value.nonSpeculativeIndex, outStream);
                    break;
                }
                default: {
                    throw new CoderException("Unknown encoding " + (Object)((Object)encoding));
                }
            }
        }

        @Override
        public PaneInfo decode(InputStream inStream) throws CoderException, IOException {
            long onTimeIndex;
            long index;
            byte keyAndTag = (byte)inStream.read();
            PaneInfo base = (PaneInfo)BYTE_TO_PANE_INFO.get((byte)(keyAndTag & 0xF));
            switch (Encoding.fromTag(keyAndTag)) {
                case FIRST: {
                    return base;
                }
                case ONE_INDEX: {
                    index = VarInt.decodeLong(inStream);
                    onTimeIndex = base.timing == Timing.EARLY ? -1L : index;
                    break;
                }
                case TWO_INDICES: {
                    index = VarInt.decodeLong(inStream);
                    onTimeIndex = VarInt.decodeLong(inStream);
                    break;
                }
                default: {
                    throw new CoderException("Unknown encoding " + (keyAndTag & 0xF0));
                }
            }
            return new PaneInfo(base.isFirst, base.isLast, base.timing, index, onTimeIndex);
        }

        @Override
        public void verifyDeterministic() {
        }

        private static final class Encoding
        extends Enum<Encoding> {
            public static final /* enum */ Encoding FIRST = new Encoding();
            public static final /* enum */ Encoding ONE_INDEX = new Encoding();
            public static final /* enum */ Encoding TWO_INDICES = new Encoding();
            public final byte tag;
            private static final /* synthetic */ Encoding[] $VALUES;

            public static Encoding[] values() {
                return (Encoding[])$VALUES.clone();
            }

            public static Encoding valueOf(String name) {
                return Enum.valueOf(Encoding.class, name);
            }

            private Encoding() {
                assert (this.ordinal() < 16);
                this.tag = (byte)(this.ordinal() << 4);
            }

            public static Encoding fromTag(byte b) {
                return Encoding.values()[b >> 4];
            }

            static {
                $VALUES = new Encoding[]{FIRST, ONE_INDEX, TWO_INDICES};
            }
        }
    }

    public static enum Timing {
        EARLY,
        ON_TIME,
        LATE,
        UNKNOWN;

    }
}

