/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.util;

import java.util.Collection;
import java.util.Collections;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.IncompatibleWindowException;
import org.apache.beam.sdk.transforms.windowing.NonMergingWindowFn;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.transforms.windowing.WindowMappingFn;
import org.joda.time.Instant;

public class IdentityWindowFn<T>
extends NonMergingWindowFn<T, BoundedWindow> {
    private final Coder<BoundedWindow> coder;

    public IdentityWindowFn(Coder<? extends BoundedWindow> coder) {
        Coder<? extends BoundedWindow> windowCoder = coder;
        this.coder = windowCoder;
    }

    @Override
    public Collection<BoundedWindow> assignWindows(WindowFn.AssignContext c) throws Exception {
        return Collections.singleton(c.window());
    }

    @Override
    public boolean isCompatible(WindowFn<?, ?> other) {
        throw new UnsupportedOperationException(String.format("%s.isCompatible() should never be called. It is a private implementation detail of sdk utilities. This message indicates a bug in the Beam SDK.", this.getClass().getCanonicalName()));
    }

    @Override
    public void verifyCompatibility(WindowFn<?, ?> other) throws IncompatibleWindowException {
        throw new UnsupportedOperationException(String.format("%s.verifyCompatibility() should never be called. It is a private implementation detail of sdk utilities. This message indicates a bug in the Beam SDK.", this.getClass().getCanonicalName()));
    }

    @Override
    public Coder<BoundedWindow> windowCoder() {
        return this.coder;
    }

    @Override
    public WindowMappingFn<BoundedWindow> getDefaultWindowMappingFn() {
        throw new UnsupportedOperationException(String.format("%s.getSideInputWindow() should never be called. It is a private implementation detail of sdk utilities. This message indicates a bug in the Beam SDK.", this.getClass().getCanonicalName()));
    }

    @Override
    public Instant getOutputTime(Instant inputTimestamp, BoundedWindow window) {
        return inputTimestamp;
    }

    @Override
    public boolean assignsToOneWindow() {
        return true;
    }
}

