/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.util;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.util.RowJsonDeserializer;
import org.apache.beam.sdk.values.Row;

@Internal
public class JsonToRowUtils {
    public static ObjectMapper newObjectMapperWith(RowJsonDeserializer deserializer) {
        SimpleModule module = new SimpleModule("rowDeserializationModule");
        module.addDeserializer(Row.class, deserializer);
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule(module);
        return objectMapper;
    }

    public static Row jsonToRow(ObjectMapper objectMapper, String jsonString) {
        try {
            return objectMapper.readValue(jsonString, Row.class);
        }
        catch (JsonParseException | JsonMappingException jsonException) {
            throw new RowJsonDeserializer.UnsupportedRowJsonException("Unable to parse Row", jsonException);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Unable to parse json object: " + jsonString, e);
        }
    }
}

