/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.util;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.google.auto.value.AutoValue;
import java.io.IOException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.util.AutoValue_RowJsonDeserializer_FieldValue;
import org.apache.beam.sdk.util.RowJsonValidation;
import org.apache.beam.sdk.util.RowJsonValueExtractors;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.ImmutableMap;

public class RowJsonDeserializer
extends StdDeserializer<Row> {
    private static final boolean SEQUENTIAL = false;
    private static final ImmutableMap<Schema.TypeName, RowJsonValueExtractors.ValueExtractor<?>> JSON_VALUE_GETTERS = ImmutableMap.builder().put(Schema.TypeName.BYTE, RowJsonValueExtractors.byteValueExtractor()).put(Schema.TypeName.INT16, RowJsonValueExtractors.shortValueExtractor()).put(Schema.TypeName.INT32, RowJsonValueExtractors.intValueExtractor()).put(Schema.TypeName.INT64, RowJsonValueExtractors.longValueExtractor()).put(Schema.TypeName.FLOAT, RowJsonValueExtractors.floatValueExtractor()).put(Schema.TypeName.DOUBLE, RowJsonValueExtractors.doubleValueExtractor()).put(Schema.TypeName.BOOLEAN, RowJsonValueExtractors.booleanValueExtractor()).put(Schema.TypeName.STRING, RowJsonValueExtractors.stringValueExtractor()).put(Schema.TypeName.DECIMAL, RowJsonValueExtractors.decimalValueExtractor()).build();
    private Schema schema;

    public static RowJsonDeserializer forSchema(Schema schema) {
        schema.getFields().forEach(RowJsonValidation::verifyFieldTypeSupported);
        return new RowJsonDeserializer(schema);
    }

    private RowJsonDeserializer(Schema schema) {
        super(Row.class);
        this.schema = schema;
    }

    @Override
    public Row deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        return (Row)RowJsonDeserializer.extractJsonNodeValue(FieldValue.of("root", Schema.FieldType.row(this.schema), (JsonNode)jsonParser.readValueAsTree()));
    }

    private static Object extractJsonNodeValue(FieldValue fieldValue) {
        if (!fieldValue.isJsonValuePresent()) {
            throw new UnsupportedRowJsonException("Field '" + fieldValue.name() + "' is not present in the JSON object");
        }
        if (fieldValue.isJsonNull()) {
            return null;
        }
        if (fieldValue.isRowType()) {
            return RowJsonDeserializer.jsonObjectToRow(fieldValue);
        }
        if (fieldValue.isArrayType()) {
            return RowJsonDeserializer.jsonArrayToList(fieldValue);
        }
        return RowJsonDeserializer.extractJsonPrimitiveValue(fieldValue);
    }

    private static Row jsonObjectToRow(FieldValue rowFieldValue) {
        if (!rowFieldValue.isJsonObject()) {
            throw new UnsupportedRowJsonException("Expected JSON object for field '" + rowFieldValue.name() + "'. Unable to convert '" + rowFieldValue.jsonValue().asText() + "' to Beam Row, it is not a JSON object. Currently only JSON objects can be parsed to Beam Rows");
        }
        return rowFieldValue.rowSchema().getFields().stream().map(schemaField -> RowJsonDeserializer.extractJsonNodeValue(FieldValue.of(schemaField.getName(), schemaField.getType(), rowFieldValue.jsonFieldValue(schemaField.getName())))).collect(Row.toRow(rowFieldValue.rowSchema()));
    }

    private static Object jsonArrayToList(FieldValue arrayFieldValue) {
        if (!arrayFieldValue.isJsonArray()) {
            throw new UnsupportedRowJsonException("Expected JSON array for field '" + arrayFieldValue.name() + "'. Instead got " + arrayFieldValue.jsonNodeType().name());
        }
        return arrayFieldValue.jsonArrayElements().map(jsonArrayElement -> RowJsonDeserializer.extractJsonNodeValue(FieldValue.of(arrayFieldValue.name() + "[]", arrayFieldValue.arrayElementType(), jsonArrayElement))).collect(Collectors.toList());
    }

    private static Object extractJsonPrimitiveValue(FieldValue fieldValue) {
        try {
            return JSON_VALUE_GETTERS.get((Object)fieldValue.typeName()).extractValue(fieldValue.jsonValue());
        }
        catch (RuntimeException e) {
            throw new UnsupportedRowJsonException("Unable to get value from field '" + fieldValue.name() + "'. Schema type '" + (Object)((Object)fieldValue.typeName()) + "'. JSON node type " + fieldValue.jsonNodeType().name(), e);
        }
    }

    public static class UnsupportedRowJsonException
    extends RuntimeException {
        UnsupportedRowJsonException(String message, Throwable reason) {
            super(message, reason);
        }

        UnsupportedRowJsonException(String message) {
            super(message);
        }
    }

    @AutoValue
    static abstract class FieldValue {
        FieldValue() {
        }

        abstract String name();

        abstract Schema.FieldType type();

        @Nullable
        abstract JsonNode jsonValue();

        Schema.TypeName typeName() {
            return this.type().getTypeName();
        }

        boolean isJsonValuePresent() {
            return this.jsonValue() != null;
        }

        boolean isJsonNull() {
            return this.jsonValue().isNull();
        }

        JsonNodeType jsonNodeType() {
            return this.jsonValue().getNodeType();
        }

        boolean isJsonArray() {
            return this.jsonValue().isArray();
        }

        Stream<JsonNode> jsonArrayElements() {
            return StreamSupport.stream(this.jsonValue().spliterator(), false);
        }

        boolean isArrayType() {
            return Schema.TypeName.ARRAY.equals((Object)this.type().getTypeName());
        }

        Schema.FieldType arrayElementType() {
            return this.type().getCollectionElementType();
        }

        boolean isJsonObject() {
            return this.jsonValue().isObject();
        }

        JsonNode jsonFieldValue(String fieldName) {
            return this.jsonValue().get(fieldName);
        }

        boolean isRowType() {
            return Schema.TypeName.ROW.equals((Object)this.type().getTypeName());
        }

        Schema rowSchema() {
            return this.type().getRowSchema();
        }

        static FieldValue of(String name, Schema.FieldType type, JsonNode jsonValue) {
            return new AutoValue_RowJsonDeserializer_FieldValue(name, type, jsonValue);
        }
    }
}

