/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.util;

import java.util.ArrayList;
import org.apache.beam.vendor.guava.v20_0.com.google.common.base.Preconditions;

public class StringUtils {
    public static String byteArrayToJsonString(byte[] bytes) {
        StringBuilder sb = new StringBuilder(bytes.length * 2);
        for (byte b : bytes) {
            char c;
            if (b >= 32 && b < 127 && (c = (char)b) != '%' && c != '\\' && c != '\"') {
                sb.append(c);
                continue;
            }
            sb.append(String.format("%%%02x", b));
        }
        return sb.toString();
    }

    public static byte[] jsonStringToByteArray(String string) {
        ArrayList<Byte> bytes = new ArrayList<Byte>();
        int i = 0;
        while (i < string.length()) {
            Byte b;
            char c = string.charAt(i);
            if (c == '%') {
                try {
                    b = (byte)Integer.parseInt(string.substring(i + 1, i + 3), 16);
                }
                catch (IndexOutOfBoundsException | NumberFormatException exn) {
                    throw new IllegalArgumentException("not in legal encoded format; substring [" + i + ".." + (i + 2) + "] not in format \"%xx\"", exn);
                }
                i += 3;
            } else {
                b = (byte)c;
                ++i;
            }
            bytes.add(b);
        }
        byte[] byteArray = new byte[bytes.size()];
        int i2 = 0;
        for (Byte b : bytes) {
            byteArray[i2++] = b;
        }
        return byteArray;
    }

    public static int getLevenshteinDistance(String s, String t) {
        int i;
        Preconditions.checkNotNull(s);
        Preconditions.checkNotNull(t);
        if (s.equals(t)) {
            return 0;
        }
        if (s.length() == 0) {
            return t.length();
        }
        if (t.length() == 0) {
            return s.length();
        }
        int[] v0 = new int[t.length() + 1];
        int[] v1 = new int[t.length() + 1];
        for (i = 0; i < v0.length; ++i) {
            v0[i] = i;
        }
        for (i = 0; i < s.length(); ++i) {
            v1[0] = i + 1;
            for (int j = 0; j < t.length(); ++j) {
                int cost = s.charAt(i) == t.charAt(j) ? 0 : 1;
                v1[j + 1] = Math.min(Math.min(v1[j] + 1, v0[j + 1] + 1), v0[j] + cost);
            }
            System.arraycopy(v1, 0, v0, 0, v0.length);
        }
        return v1[t.length()];
    }
}

