/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.util;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Iterator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.apache.beam.vendor.guava.v20_0.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.FluentIterable;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.Iterators;
import org.apache.beam.vendor.guava.v20_0.com.google.common.io.ByteSource;
import org.apache.beam.vendor.guava.v20_0.com.google.common.io.CharSource;
import org.apache.beam.vendor.guava.v20_0.com.google.common.io.Closer;
import org.apache.beam.vendor.guava.v20_0.com.google.common.io.FileWriteMode;
import org.apache.beam.vendor.guava.v20_0.com.google.common.io.Files;

public final class ZipFiles {
    private ZipFiles() {
    }

    static ByteSource asByteSource(ZipFile file, ZipEntry entry) {
        return new ZipEntryByteSource(file, entry);
    }

    static CharSource asCharSource(ZipFile file, ZipEntry entry, Charset charset) {
        return ZipFiles.asByteSource(file, entry).asCharSource(charset);
    }

    static FluentIterable<ZipEntry> entries(final ZipFile file) {
        Preconditions.checkNotNull(file);
        return new FluentIterable<ZipEntry>(){

            @Override
            public Iterator<ZipEntry> iterator() {
                return Iterators.forEnumeration(file.entries());
            }
        };
    }

    static void unzipFile(File zipFile, File targetDirectory) throws IOException {
        Preconditions.checkNotNull(zipFile);
        Preconditions.checkNotNull(targetDirectory);
        Preconditions.checkArgument(targetDirectory.isDirectory(), "%s is not a valid directory", (Object)targetDirectory.getAbsolutePath());
        try (ZipFile zipFileObj = new ZipFile(zipFile);){
            for (ZipEntry entry : ZipFiles.entries(zipFileObj)) {
                ZipFiles.checkName(entry.getName());
                File targetFile = new File(targetDirectory, entry.getName());
                if (entry.isDirectory()) {
                    if (targetFile.isDirectory() || targetFile.mkdirs()) continue;
                    throw new IOException("Failed to create directory: " + targetFile.getAbsolutePath());
                }
                File parentFile = targetFile.getParentFile();
                if (!parentFile.isDirectory() && !parentFile.mkdirs()) {
                    throw new IOException("Failed to create directory: " + parentFile.getAbsolutePath());
                }
                ZipFiles.asByteSource(zipFileObj, entry).copyTo(Files.asByteSink(targetFile, new FileWriteMode[0]));
            }
        }
    }

    private static void checkName(String name) throws IOException {
        if (name.contains("..")) {
            for (File file = new File(name); file != null; file = file.getParentFile()) {
                if (!"..".equals(file.getName())) continue;
                throw new IOException("Cannot unzip file containing an entry with \"..\" in the name: " + name);
            }
        }
    }

    static void zipDirectory(File sourceDirectory, File zipFile) throws IOException {
        Preconditions.checkNotNull(sourceDirectory);
        Preconditions.checkNotNull(zipFile);
        Preconditions.checkArgument(sourceDirectory.isDirectory(), "%s is not a valid directory", (Object)sourceDirectory.getAbsolutePath());
        Preconditions.checkArgument(!zipFile.exists(), "%s does already exist, files are not being overwritten", (Object)zipFile.getAbsolutePath());
        try (Closer closer = Closer.create();){
            OutputStream outputStream = closer.register(new BufferedOutputStream(new FileOutputStream(zipFile)));
            ZipFiles.zipDirectory(sourceDirectory, outputStream);
        }
    }

    public static void zipDirectory(File sourceDirectory, OutputStream outputStream) throws IOException {
        Preconditions.checkNotNull(sourceDirectory);
        Preconditions.checkNotNull(outputStream);
        Preconditions.checkArgument(sourceDirectory.isDirectory(), "%s is not a valid directory", (Object)sourceDirectory.getAbsolutePath());
        ZipOutputStream zos = new ZipOutputStream(outputStream);
        for (File file : sourceDirectory.listFiles()) {
            ZipFiles.zipDirectoryInternal(file, "", zos);
        }
        zos.finish();
    }

    private static void zipDirectoryInternal(File inputFile, String directoryName, ZipOutputStream zos) throws IOException {
        String entryName = directoryName + inputFile.getName();
        if (inputFile.isDirectory()) {
            entryName = entryName + "/";
            Object[] childFiles = inputFile.listFiles();
            if (childFiles.length > 0) {
                Arrays.sort(childFiles);
                for (Object file : childFiles) {
                    ZipFiles.zipDirectoryInternal((File)file, entryName, zos);
                }
                return;
            }
        }
        ZipEntry entry = new ZipEntry(entryName);
        entry.setTime(inputFile.lastModified());
        zos.putNextEntry(entry);
        if (inputFile.isFile()) {
            Files.asByteSource(inputFile).copyTo(zos);
        }
    }

    private static final class ZipEntryByteSource
    extends ByteSource {
        private final ZipFile file;
        private final ZipEntry entry;

        ZipEntryByteSource(ZipFile file, ZipEntry entry) {
            this.file = Preconditions.checkNotNull(file);
            this.entry = Preconditions.checkNotNull(entry);
        }

        @Override
        public InputStream openStream() throws IOException {
            return this.file.getInputStream(this.entry);
        }

        public String toString() {
            return "ZipFiles.asByteSource(" + this.file + ", " + this.entry + ")";
        }
    }
}

