/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.values;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.transforms.Materialization;
import org.apache.beam.sdk.transforms.Materializations;
import org.apache.beam.sdk.transforms.ViewFn;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.InvalidWindows;
import org.apache.beam.sdk.transforms.windowing.WindowMappingFn;
import org.apache.beam.sdk.util.CoderUtils;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.PValue;
import org.apache.beam.sdk.values.PValueBase;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.apache.beam.vendor.guava.v20_0.com.google.common.base.MoreObjects;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.ArrayListMultimap;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.ImmutableMap;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.Iterables;

@Internal
public class PCollectionViews {
    public static <T, W extends BoundedWindow> PCollectionView<T> singletonView(PCollection<KV<Void, T>> pCollection, WindowingStrategy<?, W> windowingStrategy, boolean hasDefault, @Nullable T defaultValue, Coder<T> defaultValueCoder) {
        return new SimplePCollectionView(pCollection, new SingletonViewFn(hasDefault, defaultValue, defaultValueCoder), windowingStrategy.getWindowFn().getDefaultWindowMappingFn(), windowingStrategy);
    }

    public static <T, W extends BoundedWindow> PCollectionView<Iterable<T>> iterableView(PCollection<KV<Void, T>> pCollection, WindowingStrategy<?, W> windowingStrategy) {
        return new SimplePCollectionView(pCollection, new IterableViewFn(), windowingStrategy.getWindowFn().getDefaultWindowMappingFn(), windowingStrategy);
    }

    public static <T, W extends BoundedWindow> PCollectionView<List<T>> listView(PCollection<KV<Void, T>> pCollection, WindowingStrategy<?, W> windowingStrategy) {
        return new SimplePCollectionView(pCollection, new ListViewFn(), windowingStrategy.getWindowFn().getDefaultWindowMappingFn(), windowingStrategy);
    }

    public static <K, V, W extends BoundedWindow> PCollectionView<Map<K, V>> mapView(PCollection<KV<Void, KV<K, V>>> pCollection, WindowingStrategy<?, W> windowingStrategy) {
        return new SimplePCollectionView(pCollection, new MapViewFn(), windowingStrategy.getWindowFn().getDefaultWindowMappingFn(), windowingStrategy);
    }

    public static <K, V, W extends BoundedWindow> PCollectionView<Map<K, Iterable<V>>> multimapView(PCollection<KV<Void, KV<K, V>>> pCollection, WindowingStrategy<?, W> windowingStrategy) {
        return new SimplePCollectionView(pCollection, new MultimapViewFn(), windowingStrategy.getWindowFn().getDefaultWindowMappingFn(), windowingStrategy);
    }

    public static Map<TupleTag<?>, PValue> toAdditionalInputs(Iterable<PCollectionView<?>> views) {
        ImmutableMap.Builder<TupleTag<?>, PCollection<?>> additionalInputs = ImmutableMap.builder();
        for (PCollectionView<?> view : views) {
            additionalInputs.put(view.getTagInternal(), view.getPCollection());
        }
        return additionalInputs.build();
    }

    public static class SimplePCollectionView<ElemT, PrimitiveViewT, ViewT, W extends BoundedWindow>
    extends PValueBase
    implements PCollectionView<ViewT> {
        private transient PCollection<ElemT> pCollection;
        private TupleTag<PrimitiveViewT> tag;
        private WindowMappingFn<W> windowMappingFn;
        private WindowingStrategy<?, W> windowingStrategy;
        @Nullable
        private Coder<ElemT> coder;
        private ViewFn<PrimitiveViewT, ViewT> viewFn;

        private SimplePCollectionView(PCollection<ElemT> pCollection, TupleTag<PrimitiveViewT> tag, ViewFn<PrimitiveViewT, ViewT> viewFn, WindowMappingFn<W> windowMappingFn, WindowingStrategy<?, W> windowingStrategy) {
            super(pCollection.getPipeline());
            this.pCollection = pCollection;
            if (windowingStrategy.getWindowFn() instanceof InvalidWindows) {
                throw new IllegalArgumentException("WindowFn of PCollectionView cannot be InvalidWindows");
            }
            this.windowMappingFn = windowMappingFn;
            this.tag = tag;
            this.windowingStrategy = windowingStrategy;
            this.viewFn = viewFn;
            this.coder = pCollection.getCoder();
        }

        private SimplePCollectionView(PCollection<ElemT> pCollection, ViewFn<PrimitiveViewT, ViewT> viewFn, WindowMappingFn<W> windowMappingFn, WindowingStrategy<?, W> windowingStrategy) {
            this(pCollection, new TupleTag(), viewFn, windowMappingFn, windowingStrategy);
        }

        @Override
        public ViewFn<PrimitiveViewT, ViewT> getViewFn() {
            return this.viewFn;
        }

        @Override
        public WindowMappingFn<?> getWindowMappingFn() {
            return this.windowMappingFn;
        }

        @Override
        public PCollection<?> getPCollection() {
            return this.pCollection;
        }

        @Override
        public TupleTag<?> getTagInternal() {
            return this.tag;
        }

        @Override
        public WindowingStrategy<?, ?> getWindowingStrategyInternal() {
            return this.windowingStrategy;
        }

        @Override
        public Coder<?> getCoderInternal() {
            return this.coder;
        }

        public int hashCode() {
            return Objects.hash(this.tag);
        }

        public boolean equals(Object other) {
            if (!(other instanceof PCollectionView)) {
                return false;
            }
            PCollectionView otherView = (PCollectionView)other;
            return this.tag.equals(otherView.getTagInternal());
        }

        @Override
        public String toString() {
            return MoreObjects.toStringHelper(this).add("tag", this.tag).toString();
        }

        @Override
        public Map<TupleTag<?>, PValue> expand() {
            return Collections.singletonMap(this.tag, this.pCollection);
        }
    }

    @Experimental(value=Experimental.Kind.CORE_RUNNERS_ONLY)
    public static class MapViewFn<K, V>
    extends ViewFn<Materializations.MultimapView<Void, KV<K, V>>, Map<K, V>> {
        @Override
        public Materialization<Materializations.MultimapView<Void, KV<K, V>>> getMaterialization() {
            return Materializations.multimap();
        }

        @Override
        public Map<K, V> apply(Materializations.MultimapView<Void, KV<K, V>> primitiveViewT) {
            HashMap<K, V> map = new HashMap<K, V>();
            for (KV<K, V> elem : primitiveViewT.get(null)) {
                if (map.containsKey(elem.getKey())) {
                    throw new IllegalArgumentException("Duplicate values for " + elem.getKey());
                }
                map.put(elem.getKey(), elem.getValue());
            }
            return Collections.unmodifiableMap(map);
        }
    }

    @Experimental(value=Experimental.Kind.CORE_RUNNERS_ONLY)
    public static class MultimapViewFn<K, V>
    extends ViewFn<Materializations.MultimapView<Void, KV<K, V>>, Map<K, Iterable<V>>> {
        @Override
        public Materialization<Materializations.MultimapView<Void, KV<K, V>>> getMaterialization() {
            return Materializations.multimap();
        }

        @Override
        public Map<K, Iterable<V>> apply(Materializations.MultimapView<Void, KV<K, V>> primitiveViewT) {
            ArrayListMultimap<K, V> multimap = ArrayListMultimap.create();
            for (KV<K, V> elem : primitiveViewT.get(null)) {
                multimap.put(elem.getKey(), elem.getValue());
            }
            Map resultMap = multimap.asMap();
            return Collections.unmodifiableMap(resultMap);
        }
    }

    @Experimental(value=Experimental.Kind.CORE_RUNNERS_ONLY)
    public static class ListViewFn<T>
    extends ViewFn<Materializations.MultimapView<Void, T>, List<T>> {
        @Override
        public Materialization<Materializations.MultimapView<Void, T>> getMaterialization() {
            return Materializations.multimap();
        }

        @Override
        public List<T> apply(Materializations.MultimapView<Void, T> primitiveViewT) {
            ArrayList<T> list = new ArrayList<T>();
            for (T t : primitiveViewT.get(null)) {
                list.add(t);
            }
            return Collections.unmodifiableList(list);
        }

        public boolean equals(Object other) {
            return other instanceof ListViewFn;
        }

        public int hashCode() {
            return ListViewFn.class.hashCode();
        }
    }

    @Experimental(value=Experimental.Kind.CORE_RUNNERS_ONLY)
    public static class IterableViewFn<T>
    extends ViewFn<Materializations.MultimapView<Void, T>, Iterable<T>> {
        @Override
        public Materialization<Materializations.MultimapView<Void, T>> getMaterialization() {
            return Materializations.multimap();
        }

        @Override
        public Iterable<T> apply(Materializations.MultimapView<Void, T> primitiveViewT) {
            return Iterables.unmodifiableIterable(primitiveViewT.get(null));
        }
    }

    @Experimental(value=Experimental.Kind.CORE_RUNNERS_ONLY)
    public static class SingletonViewFn<T>
    extends ViewFn<Materializations.MultimapView<Void, T>, T> {
        @Nullable
        private byte[] encodedDefaultValue;
        @Nullable
        private transient T defaultValue;
        @Nullable
        private Coder<T> valueCoder;
        private boolean hasDefault;

        private SingletonViewFn(boolean hasDefault, T defaultValue, Coder<T> valueCoder) {
            this.hasDefault = hasDefault;
            this.defaultValue = defaultValue;
            this.valueCoder = valueCoder;
            if (hasDefault) {
                try {
                    this.encodedDefaultValue = CoderUtils.encodeToByteArray(valueCoder, defaultValue);
                }
                catch (IOException e) {
                    throw new RuntimeException("Unexpected IOException: ", e);
                }
            }
        }

        @Internal
        public boolean hasDefault() {
            return this.hasDefault;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public T getDefaultValue() {
            if (!this.hasDefault) {
                throw new NoSuchElementException("Empty PCollection accessed as a singleton view.");
            }
            SingletonViewFn singletonViewFn = this;
            synchronized (singletonViewFn) {
                if (this.encodedDefaultValue != null) {
                    try {
                        this.defaultValue = CoderUtils.decodeFromByteArray(this.valueCoder, this.encodedDefaultValue);
                        this.encodedDefaultValue = null;
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Unexpected IOException: ", e);
                    }
                }
                return this.defaultValue;
            }
        }

        @Override
        public Materialization<Materializations.MultimapView<Void, T>> getMaterialization() {
            return Materializations.multimap();
        }

        @Override
        public T apply(Materializations.MultimapView<Void, T> primitiveViewT) {
            try {
                return Iterables.getOnlyElement(primitiveViewT.get(null));
            }
            catch (NoSuchElementException exc) {
                return this.getDefaultValue();
            }
            catch (IllegalArgumentException exc) {
                throw new IllegalArgumentException("PCollection with more than one element accessed as a singleton view.");
            }
        }
    }
}

