/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.values;

import java.io.Serializable;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collector;
import javax.annotation.Nullable;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.schemas.Factory;
import org.apache.beam.sdk.schemas.FieldValueGetter;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.values.RowWithGetters;
import org.apache.beam.sdk.values.RowWithStorage;
import org.apache.beam.vendor.guava.v20_0.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.Iterables;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.Lists;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.Maps;
import org.joda.time.DateTime;
import org.joda.time.Instant;
import org.joda.time.ReadableDateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.base.AbstractInstant;

@Experimental
public abstract class Row
implements Serializable {
    private final Schema schema;

    Row(Schema schema) {
        this.schema = schema;
    }

    @Nullable
    public abstract <T> T getValue(int var1);

    public abstract int getFieldCount();

    public abstract List<Object> getValues();

    @Nullable
    public <T> T getValue(String fieldName) {
        return this.getValue(this.getSchema().indexOf(fieldName));
    }

    @Nullable
    public Byte getByte(String fieldName) {
        return this.getByte(this.getSchema().indexOf(fieldName));
    }

    @Nullable
    public byte[] getBytes(String fieldName) {
        return this.getBytes(this.getSchema().indexOf(fieldName));
    }

    @Nullable
    public Short getInt16(String fieldName) {
        return this.getInt16(this.getSchema().indexOf(fieldName));
    }

    @Nullable
    public Integer getInt32(String fieldName) {
        return this.getInt32(this.getSchema().indexOf(fieldName));
    }

    @Nullable
    public Long getInt64(String fieldName) {
        return this.getInt64(this.getSchema().indexOf(fieldName));
    }

    @Nullable
    public BigDecimal getDecimal(String fieldName) {
        return this.getDecimal(this.getSchema().indexOf(fieldName));
    }

    @Nullable
    public Float getFloat(String fieldName) {
        return this.getFloat(this.getSchema().indexOf(fieldName));
    }

    @Nullable
    public Double getDouble(String fieldName) {
        return this.getDouble(this.getSchema().indexOf(fieldName));
    }

    @Nullable
    public String getString(String fieldName) {
        return this.getString(this.getSchema().indexOf(fieldName));
    }

    @Nullable
    public ReadableDateTime getDateTime(String fieldName) {
        return this.getDateTime(this.getSchema().indexOf(fieldName));
    }

    @Nullable
    public Boolean getBoolean(String fieldName) {
        return this.getBoolean(this.getSchema().indexOf(fieldName));
    }

    @Nullable
    public <T> List<T> getArray(String fieldName) {
        return this.getArray(this.getSchema().indexOf(fieldName));
    }

    @Nullable
    public <T1, T2> Map<T1, T2> getMap(String fieldName) {
        return this.getMap(this.getSchema().indexOf(fieldName));
    }

    @Nullable
    public Row getRow(String fieldName) {
        return this.getRow(this.getSchema().indexOf(fieldName));
    }

    @Nullable
    public Byte getByte(int idx) {
        return (Byte)this.getValue(idx);
    }

    @Nullable
    public byte[] getBytes(int idx) {
        return (byte[])this.getValue(idx);
    }

    @Nullable
    public Short getInt16(int idx) {
        return (Short)this.getValue(idx);
    }

    @Nullable
    public Integer getInt32(int idx) {
        return (Integer)this.getValue(idx);
    }

    @Nullable
    public Float getFloat(int idx) {
        return (Float)this.getValue(idx);
    }

    @Nullable
    public Double getDouble(int idx) {
        return (Double)this.getValue(idx);
    }

    @Nullable
    public Long getInt64(int idx) {
        return (Long)this.getValue(idx);
    }

    @Nullable
    public String getString(int idx) {
        return (String)this.getValue(idx);
    }

    @Nullable
    public ReadableDateTime getDateTime(int idx) {
        ReadableInstant instant = (ReadableInstant)this.getValue(idx);
        return instant == null ? null : new DateTime(instant).withZone(instant.getZone());
    }

    @Nullable
    public BigDecimal getDecimal(int idx) {
        return (BigDecimal)this.getValue(idx);
    }

    @Nullable
    public Boolean getBoolean(int idx) {
        return (Boolean)this.getValue(idx);
    }

    @Nullable
    public <T> List<T> getArray(int idx) {
        return (List)this.getValue(idx);
    }

    @Nullable
    public <T1, T2> Map<T1, T2> getMap(int idx) {
        return (Map)this.getValue(idx);
    }

    @Nullable
    public Row getRow(int idx) {
        return (Row)this.getValue(idx);
    }

    public Schema getSchema() {
        return this.schema;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Row)) {
            return false;
        }
        Row other = (Row)o;
        if (!Objects.equals(this.getSchema(), other.getSchema())) {
            return false;
        }
        for (int i = 0; i < this.getFieldCount(); ++i) {
            if (Equals.deepEquals(this.getValue(i), other.getValue(i), this.getSchema().getField(i).getType())) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int h = 1;
        for (int i = 0; i < this.getFieldCount(); ++i) {
            h = 31 * h + Equals.deepHashCode(this.getValue(i), this.getSchema().getField(i).getType());
        }
        return h;
    }

    public String toString() {
        return "Row:" + Arrays.deepToString(Iterables.toArray(this.getValues(), Object.class));
    }

    public static Builder withSchema(Schema schema) {
        return new Builder(schema);
    }

    public static <T> Collector<T, List<Object>, Row> toRow(Schema schema) {
        return Collector.of(() -> new ArrayList(schema.getFieldCount()), List::add, (left, right) -> {
            left.addAll(right);
            return left;
        }, values -> Row.withSchema(schema).addValues((List<Object>)values).build(), new Collector.Characteristics[0]);
    }

    public static Row nullRow(Schema schema) {
        return Row.withSchema(schema).addValues(Collections.nCopies(schema.getFieldCount(), null)).build();
    }

    public static class Builder {
        private List<Object> values = Lists.newArrayList();
        private boolean attached = false;
        @Nullable
        private Factory<List<FieldValueGetter>> fieldValueGetterFactory;
        @Nullable
        private Object getterTarget;
        private Schema schema;

        Builder(Schema schema) {
            this.schema = schema;
        }

        public int nextFieldId() {
            if (this.fieldValueGetterFactory != null) {
                throw new RuntimeException("Not supported");
            }
            return this.values.size();
        }

        public Schema getSchema() {
            return this.schema;
        }

        public Builder addValue(@Nullable Object values) {
            this.values.add(values);
            return this;
        }

        public Builder addValues(List<Object> values) {
            this.values.addAll(values);
            return this;
        }

        public Builder addValues(Object ... values) {
            return this.addValues(Arrays.asList(values));
        }

        public <T> Builder addArray(List<T> values) {
            this.values.add(values);
            return this;
        }

        public Builder addArray(Object ... values) {
            this.addArray(Arrays.asList(values));
            return this;
        }

        public Builder attachValues(List<Object> values) {
            this.attached = true;
            this.values = values;
            return this;
        }

        public Builder withFieldValueGetters(Factory<List<FieldValueGetter>> fieldValueGetterFactory, Object getterTarget) {
            this.fieldValueGetterFactory = fieldValueGetterFactory;
            this.getterTarget = getterTarget;
            return this;
        }

        private List<Object> verify(Schema schema, List<Object> values) {
            ArrayList<Object> verifiedValues = Lists.newArrayListWithCapacity(values.size());
            if (schema.getFieldCount() != values.size()) {
                throw new IllegalArgumentException(String.format("Field count in Schema (%s) (%d) and values (%s) (%d)  must match", schema.getFieldNames(), schema.getFieldCount(), values, values.size()));
            }
            for (int i = 0; i < values.size(); ++i) {
                Object value = values.get(i);
                Schema.Field field = schema.getField(i);
                if (value == null) {
                    if (!field.getType().getNullable().booleanValue()) {
                        throw new IllegalArgumentException(String.format("Field %s is not nullable", field.getName()));
                    }
                    verifiedValues.add(null);
                    continue;
                }
                verifiedValues.add(this.verify(value, field.getType(), field.getName()));
            }
            return verifiedValues;
        }

        private Object verify(Object value, Schema.FieldType type, String fieldName) {
            if (Schema.TypeName.ARRAY.equals((Object)type.getTypeName())) {
                return this.verifyArray(value, type.getCollectionElementType(), fieldName);
            }
            if (Schema.TypeName.MAP.equals((Object)type.getTypeName())) {
                return this.verifyMap(value, type.getMapKeyType(), type.getMapValueType(), fieldName);
            }
            if (Schema.TypeName.ROW.equals((Object)type.getTypeName())) {
                return this.verifyRow(value, fieldName);
            }
            if (Schema.TypeName.LOGICAL_TYPE.equals((Object)type.getTypeName())) {
                return this.verifyLogicalType(value, type.getLogicalType(), fieldName);
            }
            return this.verifyPrimitiveType(value, type.getTypeName(), fieldName);
        }

        private Object verifyLogicalType(Object value, Schema.LogicalType logicalType, String fieldName) {
            return this.verify(logicalType.toBaseType(value), logicalType.getBaseType(), fieldName);
        }

        private List<Object> verifyArray(Object value, Schema.FieldType collectionElementType, String fieldName) {
            boolean collectionElementTypeNullable = collectionElementType.getNullable();
            if (!(value instanceof List)) {
                throw new IllegalArgumentException(String.format("For field name %s and array type expected List class. Instead class type was %s.", fieldName, value.getClass()));
            }
            List valueList = (List)value;
            ArrayList<Object> verifiedList = Lists.newArrayListWithCapacity(valueList.size());
            for (Object listValue : valueList) {
                if (listValue == null) {
                    if (!collectionElementTypeNullable) {
                        throw new IllegalArgumentException(String.format("%s is not nullable in Array field %s", collectionElementType, fieldName));
                    }
                    verifiedList.add(null);
                    continue;
                }
                verifiedList.add(this.verify(listValue, collectionElementType, fieldName));
            }
            return verifiedList;
        }

        private Map<Object, Object> verifyMap(Object value, Schema.FieldType keyType, Schema.FieldType valueType, String fieldName) {
            boolean valueTypeNullable = valueType.getNullable();
            if (!(value instanceof Map)) {
                throw new IllegalArgumentException(String.format("For field name %s and map type expected Map class. Instead class type was %s.", fieldName, value.getClass()));
            }
            Map valueMap = (Map)value;
            HashMap<Object, Object> verifiedMap = Maps.newHashMapWithExpectedSize(valueMap.size());
            for (Map.Entry kv : valueMap.entrySet()) {
                if (kv.getValue() == null) {
                    if (!valueTypeNullable) {
                        throw new IllegalArgumentException(String.format("%s is not nullable in Map field %s", valueType, fieldName));
                    }
                    verifiedMap.put(this.verify(kv.getKey(), keyType, fieldName), null);
                    continue;
                }
                verifiedMap.put(this.verify(kv.getKey(), keyType, fieldName), this.verify(kv.getValue(), valueType, fieldName));
            }
            return verifiedMap;
        }

        private Row verifyRow(Object value, String fieldName) {
            if (!(value instanceof Row)) {
                throw new IllegalArgumentException(String.format("For field name %s expected Row type. Instead class type was %s.", fieldName, value.getClass()));
            }
            return (Row)value;
        }

        private Object verifyPrimitiveType(Object value, Schema.TypeName type, String fieldName) {
            if (type.isDateType()) {
                return this.verifyDateTime(value, fieldName);
            }
            switch (type) {
                case BYTE: {
                    if (!(value instanceof Byte)) break;
                    return value;
                }
                case BYTES: {
                    if (value instanceof ByteBuffer) {
                        return ((ByteBuffer)value).array();
                    }
                    if (!(value instanceof byte[])) break;
                    return (byte[])value;
                }
                case INT16: {
                    if (!(value instanceof Short)) break;
                    return value;
                }
                case INT32: {
                    if (!(value instanceof Integer)) break;
                    return value;
                }
                case INT64: {
                    if (!(value instanceof Long)) break;
                    return value;
                }
                case DECIMAL: {
                    if (!(value instanceof BigDecimal)) break;
                    return value;
                }
                case FLOAT: {
                    if (!(value instanceof Float)) break;
                    return value;
                }
                case DOUBLE: {
                    if (!(value instanceof Double)) break;
                    return value;
                }
                case STRING: {
                    if (!(value instanceof String)) break;
                    return value;
                }
                case BOOLEAN: {
                    if (!(value instanceof Boolean)) break;
                    return value;
                }
                default: {
                    throw new IllegalArgumentException(String.format("Not a primitive type for field name %s: %s", new Object[]{fieldName, type}));
                }
            }
            throw new IllegalArgumentException(String.format("For field name %s and type %s found incorrect class type %s", new Object[]{fieldName, type, value.getClass()}));
        }

        private Instant verifyDateTime(Object value, String fieldName) {
            if (value instanceof AbstractInstant) {
                return ((AbstractInstant)value).toInstant();
            }
            throw new IllegalArgumentException(String.format("For field name %s and DATETIME type got unexpected class %s ", fieldName, value.getClass()));
        }

        public Row build() {
            Preconditions.checkNotNull(this.schema);
            if (!this.values.isEmpty() && this.fieldValueGetterFactory != null) {
                throw new IllegalArgumentException("Cannot specify both values and getters.");
            }
            if (!this.values.isEmpty()) {
                List<Object> storageValues = this.attached ? this.values : this.verify(this.schema, this.values);
                Preconditions.checkState(this.getterTarget == null, "withGetterTarget requires getters.");
                return new RowWithStorage(this.schema, storageValues);
            }
            if (this.fieldValueGetterFactory != null) {
                Preconditions.checkState(this.getterTarget != null, "getters require withGetterTarget.");
                return new RowWithGetters(this.schema, this.fieldValueGetterFactory, this.getterTarget);
            }
            return new RowWithStorage(this.schema, Collections.emptyList());
        }
    }

    static class Equals {
        Equals() {
        }

        static boolean deepEquals(Object a, Object b, Schema.FieldType fieldType) {
            if (a == null || b == null) {
                return a == b;
            }
            if (fieldType.getTypeName() == Schema.TypeName.LOGICAL_TYPE) {
                return Equals.deepEquals(a, b, fieldType.getLogicalType().getBaseType());
            }
            if (fieldType.getTypeName() == Schema.TypeName.BYTES) {
                return Arrays.equals((byte[])a, (byte[])b);
            }
            if (fieldType.getTypeName() == Schema.TypeName.ARRAY) {
                return Equals.deepEqualsForList((List)a, (List)b, fieldType.getCollectionElementType());
            }
            if (fieldType.getTypeName() == Schema.TypeName.MAP) {
                return Equals.deepEqualsForMap((Map)a, (Map)b, fieldType.getMapValueType());
            }
            return Objects.equals(a, b);
        }

        static int deepHashCode(Object a, Schema.FieldType fieldType) {
            if (a == null) {
                return 0;
            }
            if (fieldType.getTypeName() == Schema.TypeName.LOGICAL_TYPE) {
                return Equals.deepHashCode(a, fieldType.getLogicalType().getBaseType());
            }
            if (fieldType.getTypeName() == Schema.TypeName.BYTES) {
                return Arrays.hashCode((byte[])a);
            }
            if (fieldType.getTypeName() == Schema.TypeName.ARRAY) {
                return Equals.deepHashCodeForList((List)a, fieldType.getCollectionElementType());
            }
            if (fieldType.getTypeName() == Schema.TypeName.MAP) {
                return Equals.deepHashCodeForMap((Map)a, fieldType.getMapKeyType(), fieldType.getMapValueType());
            }
            return Objects.hashCode(a);
        }

        static <K, V> boolean deepEqualsForMap(Map<K, V> a, Map<K, V> b, Schema.FieldType valueType) {
            if (a == b) {
                return true;
            }
            if (a.size() != b.size()) {
                return false;
            }
            for (Map.Entry<K, V> e : a.entrySet()) {
                K key = e.getKey();
                V value = e.getValue();
                V otherValue = b.get(key);
                if (!(value == null ? otherValue != null || !b.containsKey(key) : !Equals.deepEquals(value, otherValue, valueType))) continue;
                return false;
            }
            return true;
        }

        static int deepHashCodeForMap(Map<Object, Object> a, Schema.FieldType keyType, Schema.FieldType valueType) {
            int h = 0;
            for (Map.Entry<Object, Object> e : a.entrySet()) {
                Object key = e.getKey();
                Object value = e.getValue();
                h += Equals.deepHashCode(key, keyType) ^ Equals.deepHashCode(value, valueType);
            }
            return h;
        }

        static boolean deepEqualsForList(List<Object> a, List<Object> b, Schema.FieldType elementType) {
            if (a == b) {
                return true;
            }
            if (a.size() != b.size()) {
                return false;
            }
            for (int i = 0; i < a.size(); ++i) {
                if (Equals.deepEquals(a.get(i), b.get(i), elementType)) continue;
                return false;
            }
            return true;
        }

        static int deepHashCodeForList(List<Object> a, Schema.FieldType elementType) {
            int h = 1;
            for (int i = 0; i < a.size(); ++i) {
                h = 31 * h + Equals.deepHashCode(a.get(i), elementType);
            }
            return h;
        }
    }
}

