/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.values;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.beam.sdk.schemas.Factory;
import org.apache.beam.sdk.schemas.FieldValueGetter;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.Lists;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.Maps;

public class RowWithGetters
extends Row {
    private final Factory<List<FieldValueGetter>> fieldValueGetterFactory;
    private final Object getterTarget;
    private final List<FieldValueGetter> getters;
    private final Map<Integer, List> cachedLists = Maps.newHashMap();
    private final Map<Integer, Map> cachedMaps = Maps.newHashMap();

    RowWithGetters(Schema schema, Factory<List<FieldValueGetter>> getterFactory, Object getterTarget) {
        super(schema);
        this.fieldValueGetterFactory = getterFactory;
        this.getterTarget = getterTarget;
        this.getters = this.fieldValueGetterFactory.create(getterTarget.getClass(), schema);
    }

    @Override
    @Nullable
    public <T> T getValue(int fieldIdx) {
        Schema.Field field = this.getSchema().getField(fieldIdx);
        Schema.FieldType type = field.getType();
        Object fieldValue = this.getters.get(fieldIdx).get(this.getterTarget);
        if (fieldValue == null && !field.getType().getNullable().booleanValue()) {
            throw new RuntimeException("Null value set on non-nullable field" + field);
        }
        return fieldValue != null ? (T)this.getValue(type, fieldValue, fieldIdx) : null;
    }

    private List getListValue(Schema.FieldType elementType, Object fieldValue) {
        Iterable iterable = (Iterable)fieldValue;
        ArrayList list = Lists.newArrayList();
        for (Object o : iterable) {
            list.add(this.getValue(elementType, o, null));
        }
        return list;
    }

    private Map<?, ?> getMapValue(Schema.FieldType keyType, Schema.FieldType valueType, Map<?, ?> fieldValue) {
        HashMap returnMap = Maps.newHashMap();
        for (Map.Entry<?, ?> entry : fieldValue.entrySet()) {
            returnMap.put(this.getValue(keyType, entry.getKey(), null), this.getValue(valueType, entry.getValue(), null));
        }
        return returnMap;
    }

    private <T> T getValue(Schema.FieldType type, Object fieldValue, @Nullable Integer cacheKey) {
        if (type.getTypeName().equals((Object)Schema.TypeName.ROW)) {
            return (T)new RowWithGetters(type.getRowSchema(), this.fieldValueGetterFactory, fieldValue);
        }
        if (type.getTypeName().equals((Object)Schema.TypeName.ARRAY)) {
            return (T)(cacheKey != null ? this.cachedLists.computeIfAbsent(cacheKey, i -> this.getListValue(type.getCollectionElementType(), fieldValue)) : this.getListValue(type.getCollectionElementType(), fieldValue));
        }
        if (type.getTypeName().equals((Object)Schema.TypeName.MAP)) {
            Map map = (Map)fieldValue;
            return (T)(cacheKey != null ? this.cachedMaps.computeIfAbsent(cacheKey, i -> this.getMapValue(type.getMapKeyType(), type.getMapValueType(), map)) : this.getMapValue(type.getMapKeyType(), type.getMapValueType(), map));
        }
        return (T)fieldValue;
    }

    @Override
    public int getFieldCount() {
        return this.getters.size();
    }

    @Override
    public List<Object> getValues() {
        return this.getters.stream().map(g -> g.get(this.getterTarget)).collect(Collectors.toList());
    }

    public List<FieldValueGetter> getGetters() {
        return this.getters;
    }

    public Object getGetterTarget() {
        return this.getterTarget;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o instanceof RowWithGetters) {
            RowWithGetters other = (RowWithGetters)o;
            return Objects.equals(this.getSchema(), other.getSchema()) && Objects.equals(this.getterTarget, other.getterTarget);
        }
        if (o instanceof Row) {
            return super.equals(o);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getSchema(), this.getterTarget);
    }
}

