/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.values;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.beam.sdk.values.TypeParameter;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.Lists;
import org.apache.beam.vendor.guava.v20_0.com.google.common.reflect.Invokable;
import org.apache.beam.vendor.guava.v20_0.com.google.common.reflect.Parameter;
import org.apache.beam.vendor.guava.v20_0.com.google.common.reflect.TypeResolver;
import org.apache.beam.vendor.guava.v20_0.com.google.common.reflect.TypeToken;

public abstract class TypeDescriptor<T>
implements Serializable {
    private final TypeToken<T> token;

    private TypeDescriptor(TypeToken<T> token) {
        this.token = token;
    }

    protected TypeDescriptor() {
        this.token = new TypeToken<T>(this.getClass()){};
    }

    protected TypeDescriptor(Object instance) {
        TypeToken typedToken;
        TypeToken unresolvedToken = new TypeToken<T>(this.getClass()){};
        unresolvedToken = TypeToken.of(instance.getClass()).resolveType(unresolvedToken.getType());
        if (this.hasUnresolvedParameters(unresolvedToken.getType())) {
            Field field;
            Object fieldInstance;
            Field[] fieldArray = instance.getClass().getDeclaredFields();
            int n = fieldArray.length;
            for (int i = 0; i < n && ((fieldInstance = this.getEnclosingInstance(field = fieldArray[i], instance)) == null || this.hasUnresolvedParameters((unresolvedToken = TypeToken.of(fieldInstance.getClass()).resolveType(unresolvedToken.getType())).getType())); ++i) {
            }
        }
        this.token = typedToken = unresolvedToken;
    }

    private boolean hasUnresolvedParameters(Type type) {
        if (type instanceof TypeVariable) {
            return true;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType param = (ParameterizedType)type;
            for (Type arg : param.getActualTypeArguments()) {
                if (!this.hasUnresolvedParameters(arg)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private Object getEnclosingInstance(Field field, Object instance) {
        if (!field.isSynthetic()) {
            return null;
        }
        boolean accessible = field.isAccessible();
        try {
            field.setAccessible(true);
            Object object = field.get(instance);
            return object;
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            Object var5_6 = null;
            return var5_6;
        }
        finally {
            field.setAccessible(accessible);
        }
    }

    protected TypeDescriptor(Class<?> clazz) {
        TypeToken unresolvedToken = new TypeToken<T>(this.getClass()){};
        this.token = TypeToken.of(clazz).resolveType(unresolvedToken.getType());
    }

    public static <T> TypeDescriptor<T> of(Class<T> type) {
        return new SimpleTypeDescriptor<T>(TypeToken.of(type));
    }

    public static TypeDescriptor<?> of(Type type) {
        return new SimpleTypeDescriptor(TypeToken.of(type));
    }

    public Type getType() {
        return this.token.getType();
    }

    public Class<? super T> getRawType() {
        return this.token.getRawType();
    }

    public TypeDescriptor<?> getComponentType() {
        return new SimpleTypeDescriptor(this.token.getComponentType());
    }

    public final TypeDescriptor<? super T> getSupertype(Class<? super T> superclass) {
        return new SimpleTypeDescriptor<T>(this.token.getSupertype(superclass));
    }

    public final boolean isArray() {
        return this.token.isArray();
    }

    public final TypeVariable<Class<? super T>> getTypeParameter(String paramName) {
        Class<T> rawType = this.getRawType();
        for (TypeVariable<Class<T>> param : rawType.getTypeParameters()) {
            if (!param.getName().equals(paramName)) continue;
            TypeVariable<Class<T>> typedParam = param;
            return typedParam;
        }
        throw new IllegalArgumentException("No type parameter named " + paramName + " found on " + this.getRawType());
    }

    public final boolean isSupertypeOf(TypeDescriptor<?> source) {
        return this.token.isSupertypeOf(source.token);
    }

    public final boolean isSubtypeOf(TypeDescriptor<?> parent) {
        return this.token.isSubtypeOf(parent.token);
    }

    public List<TypeDescriptor<?>> getArgumentTypes(Method method) {
        Invokable<T, Object> typedMethod = this.token.method(method);
        ArrayList<TypeDescriptor<?>> argTypes = Lists.newArrayList();
        for (Parameter parameter : typedMethod.getParameters()) {
            argTypes.add(new SimpleTypeDescriptor(parameter.getType()));
        }
        return argTypes;
    }

    public TypeDescriptor<?> resolveType(Type type) {
        return new SimpleTypeDescriptor(this.token.resolveType(type));
    }

    public Iterable<TypeDescriptor> getTypes() {
        ArrayList<TypeDescriptor> interfaces = Lists.newArrayList();
        for (TypeToken interfaceToken : this.token.getTypes()) {
            interfaces.add(new SimpleTypeDescriptor(interfaceToken));
        }
        return interfaces;
    }

    public Iterable<TypeDescriptor> getInterfaces() {
        ArrayList<TypeDescriptor> interfaces = Lists.newArrayList();
        for (TypeToken interfaceToken : this.token.getTypes().interfaces()) {
            interfaces.add(new SimpleTypeDescriptor(interfaceToken));
        }
        return interfaces;
    }

    public Iterable<TypeDescriptor> getClasses() {
        ArrayList<TypeDescriptor> classes = Lists.newArrayList();
        for (TypeToken classToken : this.token.getTypes().classes()) {
            classes.add(new SimpleTypeDescriptor(classToken));
        }
        return classes;
    }

    public <X> TypeDescriptor<T> where(TypeParameter<X> typeParameter, TypeDescriptor<X> typeDescriptor) {
        return this.where(typeParameter.typeVariable, typeDescriptor.getType());
    }

    public TypeDescriptor<T> where(Type formal, Type actual) {
        TypeResolver resolver = new TypeResolver().where(formal, actual);
        return TypeDescriptor.of(resolver.resolveType(this.token.getType()));
    }

    public boolean hasUnresolvedParameters() {
        return this.hasUnresolvedParameters(this.getType());
    }

    public String toString() {
        return this.token.toString();
    }

    public boolean equals(Object other) {
        if (!(other instanceof TypeDescriptor)) {
            return false;
        }
        TypeDescriptor descriptor = (TypeDescriptor)other;
        return this.token.equals(descriptor.token);
    }

    public int hashCode() {
        return this.token.hashCode();
    }

    private static final class SimpleTypeDescriptor<T>
    extends TypeDescriptor<T> {
        SimpleTypeDescriptor(TypeToken<T> typeToken) {
            super(typeToken);
        }
    }
}

