/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.vendor.grpc.v1p13p1.io.grpc.internal;

import java.util.concurrent.Executor;
import org.apache.beam.vendor.grpc.v1p13p1.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.grpc.v1p13p1.com.google.common.base.Preconditions;
import org.apache.beam.vendor.grpc.v1p13p1.com.google.common.util.concurrent.ListenableFuture;
import org.apache.beam.vendor.grpc.v1p13p1.com.google.common.util.concurrent.SettableFuture;
import org.apache.beam.vendor.grpc.v1p13p1.io.grpc.CallOptions;
import org.apache.beam.vendor.grpc.v1p13p1.io.grpc.Metadata;
import org.apache.beam.vendor.grpc.v1p13p1.io.grpc.MethodDescriptor;
import org.apache.beam.vendor.grpc.v1p13p1.io.grpc.Status;
import org.apache.beam.vendor.grpc.v1p13p1.io.grpc.internal.Channelz;
import org.apache.beam.vendor.grpc.v1p13p1.io.grpc.internal.ClientStream;
import org.apache.beam.vendor.grpc.v1p13p1.io.grpc.internal.ClientStreamListener;
import org.apache.beam.vendor.grpc.v1p13p1.io.grpc.internal.ClientTransport;
import org.apache.beam.vendor.grpc.v1p13p1.io.grpc.internal.FailingClientStream;
import org.apache.beam.vendor.grpc.v1p13p1.io.grpc.internal.LogId;

class FailingClientTransport
implements ClientTransport {
    @VisibleForTesting
    final Status error;
    private final ClientStreamListener.RpcProgress rpcProgress;

    FailingClientTransport(Status error, ClientStreamListener.RpcProgress rpcProgress) {
        Preconditions.checkArgument(!error.isOk(), "error must not be OK");
        this.error = error;
        this.rpcProgress = rpcProgress;
    }

    @Override
    public ClientStream newStream(MethodDescriptor<?, ?> method, Metadata headers, CallOptions callOptions) {
        return new FailingClientStream(this.error, this.rpcProgress);
    }

    @Override
    public void ping(final ClientTransport.PingCallback callback, Executor executor) {
        executor.execute(new Runnable(){

            @Override
            public void run() {
                callback.onFailure(FailingClientTransport.this.error.asException());
            }
        });
    }

    @Override
    public ListenableFuture<Channelz.SocketStats> getStats() {
        SettableFuture<Channelz.SocketStats> ret = SettableFuture.create();
        ret.set(null);
        return ret;
    }

    @Override
    public LogId getLogId() {
        throw new UnsupportedOperationException("Not a real transport");
    }
}

