/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.vendor.grpc.v1p13p1.io.grpc.internal.testing;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;
import javax.security.auth.x500.X500Principal;

public class TestUtils {
    public static final String TEST_SERVER_HOST = "foo.test.google.fr";
    private static boolean conscryptInstallAttempted;

    public static InetSocketAddress testServerAddress(String host, int port) {
        try {
            InetAddress inetAddress = InetAddress.getByName(host);
            inetAddress = InetAddress.getByAddress(TEST_SERVER_HOST, inetAddress.getAddress());
            return new InetSocketAddress(inetAddress, port);
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
    }

    public static InetSocketAddress testServerAddress(int port) {
        try {
            InetAddress inetAddress = InetAddress.getByName("localhost");
            inetAddress = InetAddress.getByAddress(TEST_SERVER_HOST, inetAddress.getAddress());
            return new InetSocketAddress(inetAddress, port);
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
    }

    public static List<String> preferredTestCiphers() {
        String[] ciphers;
        try {
            ciphers = SSLContext.getDefault().getDefaultSSLParameters().getCipherSuites();
        }
        catch (NoSuchAlgorithmException ex) {
            throw new RuntimeException(ex);
        }
        ArrayList<String> ciphersMinusGcm = new ArrayList<String>();
        for (String cipher : ciphers) {
            if (cipher.contains("_GCM_")) continue;
            ciphersMinusGcm.add(cipher);
        }
        return Collections.unmodifiableList(ciphersMinusGcm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File loadCert(String name) throws IOException {
        BufferedInputStream in = new BufferedInputStream(TestUtils.class.getResourceAsStream("/certs/" + name));
        File tmpFile = File.createTempFile(name, "");
        tmpFile.deleteOnExit();
        BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(tmpFile));
        try {
            int b;
            while ((b = ((InputStream)in).read()) != -1) {
                ((OutputStream)os).write(b);
            }
            ((OutputStream)os).flush();
        }
        finally {
            ((InputStream)in).close();
            ((OutputStream)os).close();
        }
        return tmpFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static X509Certificate loadX509Cert(String fileName) throws CertificateException, IOException {
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        InputStream in = TestUtils.class.getResourceAsStream("/certs/" + fileName);
        try {
            X509Certificate x509Certificate = (X509Certificate)cf.generateCertificate(in);
            return x509Certificate;
        }
        finally {
            in.close();
        }
    }

    public static void installConscryptIfAvailable() {
        Provider provider;
        Method newProvider;
        Class<?> conscrypt;
        if (conscryptInstallAttempted) {
            return;
        }
        try {
            conscrypt = Class.forName("org.conscrypt.Conscrypt");
        }
        catch (ClassNotFoundException ex) {
            conscryptInstallAttempted = true;
            return;
        }
        try {
            newProvider = conscrypt.getMethod("newProvider", new Class[0]);
        }
        catch (NoSuchMethodException ex) {
            throw new RuntimeException("Could not find newProvider method on Conscrypt", ex);
        }
        try {
            provider = (Provider)newProvider.invoke(null, new Object[0]);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException("Could not invoke Conscrypt.newProvider", ex);
        }
        catch (InvocationTargetException ex) {
            throw new RuntimeException("Could not invoke Conscrypt.newProvider", ex);
        }
        Security.addProvider(provider);
        conscryptInstallAttempted = true;
    }

    public static SSLSocketFactory newSslSocketFactoryForCa(Provider provider, File certChainFile) throws Exception {
        KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
        ks.load(null, null);
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        X509Certificate cert = (X509Certificate)cf.generateCertificate(new BufferedInputStream(new FileInputStream(certChainFile)));
        X500Principal principal = cert.getSubjectX500Principal();
        ks.setCertificateEntry(principal.getName("RFC2253"), cert);
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init(ks);
        SSLContext context = SSLContext.getInstance("TLS", provider);
        context.init(null, trustManagerFactory.getTrustManagers(), null);
        return context.getSocketFactory();
    }

    public static void sleepAtLeast(long millis) throws InterruptedException {
        long delay = TimeUnit.MILLISECONDS.toNanos(millis);
        long end = System.nanoTime() + delay;
        while (delay > 0L) {
            TimeUnit.NANOSECONDS.sleep(delay);
            delay = end - System.nanoTime();
        }
    }

    private TestUtils() {
    }
}

