/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.vendor.grpc.v1p13p1.io.grpc.protobuf;

import javax.annotation.Nullable;
import org.apache.beam.vendor.grpc.v1p13p1.com.google.common.base.Preconditions;
import org.apache.beam.vendor.grpc.v1p13p1.io.grpc.ExperimentalApi;
import org.apache.beam.vendor.grpc.v1p13p1.io.grpc.Metadata;
import org.apache.beam.vendor.grpc.v1p13p1.io.grpc.Status;
import org.apache.beam.vendor.grpc.v1p13p1.io.grpc.StatusException;
import org.apache.beam.vendor.grpc.v1p13p1.io.grpc.StatusRuntimeException;
import org.apache.beam.vendor.grpc.v1p13p1.io.grpc.protobuf.lite.ProtoLiteUtils;

@ExperimentalApi
public final class StatusProto {
    private static final Metadata.Key<org.apache.beam.vendor.grpc.v1p13p1.com.google.rpc.Status> STATUS_DETAILS_KEY = Metadata.Key.of("grpc-status-details-bin", ProtoLiteUtils.metadataMarshaller(org.apache.beam.vendor.grpc.v1p13p1.com.google.rpc.Status.getDefaultInstance()));

    private StatusProto() {
    }

    public static StatusRuntimeException toStatusRuntimeException(org.apache.beam.vendor.grpc.v1p13p1.com.google.rpc.Status statusProto) {
        return StatusProto.toStatus(statusProto).asRuntimeException(StatusProto.toMetadata(statusProto));
    }

    public static StatusRuntimeException toStatusRuntimeException(org.apache.beam.vendor.grpc.v1p13p1.com.google.rpc.Status statusProto, Metadata metadata) {
        return StatusProto.toStatus(statusProto).asRuntimeException(StatusProto.toMetadata(statusProto, metadata));
    }

    public static StatusException toStatusException(org.apache.beam.vendor.grpc.v1p13p1.com.google.rpc.Status statusProto) {
        return StatusProto.toStatus(statusProto).asException(StatusProto.toMetadata(statusProto));
    }

    public static StatusException toStatusException(org.apache.beam.vendor.grpc.v1p13p1.com.google.rpc.Status statusProto, Metadata metadata) {
        return StatusProto.toStatus(statusProto).asException(StatusProto.toMetadata(statusProto, metadata));
    }

    private static Status toStatus(org.apache.beam.vendor.grpc.v1p13p1.com.google.rpc.Status statusProto) {
        Status status = Status.fromCodeValue(statusProto.getCode());
        Preconditions.checkArgument(status.getCode().value() == statusProto.getCode(), "invalid status code");
        return status.withDescription(statusProto.getMessage());
    }

    private static Metadata toMetadata(org.apache.beam.vendor.grpc.v1p13p1.com.google.rpc.Status statusProto) {
        Metadata metadata = new Metadata();
        metadata.put(STATUS_DETAILS_KEY, statusProto);
        return metadata;
    }

    private static Metadata toMetadata(org.apache.beam.vendor.grpc.v1p13p1.com.google.rpc.Status statusProto, Metadata metadata) {
        Preconditions.checkNotNull(metadata, "metadata must not be null");
        metadata.discardAll(STATUS_DETAILS_KEY);
        metadata.put(STATUS_DETAILS_KEY, statusProto);
        return metadata;
    }

    @Nullable
    public static org.apache.beam.vendor.grpc.v1p13p1.com.google.rpc.Status fromThrowable(Throwable t) {
        for (Throwable cause = Preconditions.checkNotNull(t, "t"); cause != null; cause = cause.getCause()) {
            if (cause instanceof StatusException) {
                StatusException e = (StatusException)cause;
                return StatusProto.fromStatusAndTrailers(e.getStatus(), e.getTrailers());
            }
            if (!(cause instanceof StatusRuntimeException)) continue;
            StatusRuntimeException e = (StatusRuntimeException)cause;
            return StatusProto.fromStatusAndTrailers(e.getStatus(), e.getTrailers());
        }
        return null;
    }

    @Nullable
    public static org.apache.beam.vendor.grpc.v1p13p1.com.google.rpc.Status fromStatusAndTrailers(Status status, Metadata trailers) {
        org.apache.beam.vendor.grpc.v1p13p1.com.google.rpc.Status statusProto;
        if (trailers != null && (statusProto = trailers.get(STATUS_DETAILS_KEY)) != null) {
            Preconditions.checkArgument(status.getCode().value() == statusProto.getCode(), "org.apache.beam.vendor.grpc.v1p13p1.com.google.rpc.Status code must match gRPC status code");
            return statusProto;
        }
        return null;
    }
}

