/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.vendor.grpc.v1p13p1.io.grpc.testing;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.beam.vendor.grpc.v1p13p1.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.grpc.v1p13p1.com.google.common.base.Preconditions;
import org.apache.beam.vendor.grpc.v1p13p1.com.google.common.base.Stopwatch;
import org.apache.beam.vendor.grpc.v1p13p1.com.google.common.base.Ticker;
import org.apache.beam.vendor.grpc.v1p13p1.io.grpc.ExperimentalApi;
import org.apache.beam.vendor.grpc.v1p13p1.io.grpc.ManagedChannel;
import org.apache.beam.vendor.grpc.v1p13p1.io.grpc.Server;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.MultipleFailureException;
import org.junit.runners.model.Statement;

@ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/2488")
@NotThreadSafe
public final class GrpcCleanupRule
implements TestRule {
    private final List<Resource> resources = new ArrayList<Resource>();
    private long timeoutNanos = TimeUnit.SECONDS.toNanos(10L);
    private Stopwatch stopwatch = Stopwatch.createUnstarted();
    private Throwable firstException;

    public GrpcCleanupRule setTimeout(long timeout, TimeUnit timeUnit) {
        Preconditions.checkArgument(timeout > 0L, "timeout should be positive");
        this.timeoutNanos = timeUnit.toNanos(timeout);
        return this;
    }

    @VisibleForTesting
    GrpcCleanupRule setTicker(Ticker ticker) {
        this.stopwatch = Stopwatch.createUnstarted(ticker);
        return this;
    }

    public <T extends ManagedChannel> T register(@Nonnull T channel) {
        Preconditions.checkNotNull(channel, "channel");
        this.register(new ManagedChannelResource(channel));
        return channel;
    }

    public <T extends Server> T register(@Nonnull T server) {
        Preconditions.checkNotNull(server, "server");
        this.register(new ServerResource(server));
        return server;
    }

    @VisibleForTesting
    void register(Resource resource) {
        this.resources.add(resource);
    }

    public Statement apply(final Statement base, Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                try {
                    base.evaluate();
                }
                catch (Throwable t) {
                    GrpcCleanupRule.this.firstException = t;
                    try {
                        GrpcCleanupRule.this.teardown();
                    }
                    catch (Throwable t2) {
                        throw new MultipleFailureException(Arrays.asList(t, t2));
                    }
                    throw t;
                }
                GrpcCleanupRule.this.teardown();
                if (GrpcCleanupRule.this.firstException != null) {
                    throw GrpcCleanupRule.this.firstException;
                }
            }
        };
    }

    private void teardown() {
        int i;
        this.stopwatch.start();
        if (this.firstException == null) {
            for (i = this.resources.size() - 1; i >= 0; --i) {
                this.resources.get(i).cleanUp();
            }
        }
        for (i = this.resources.size() - 1; i >= 0; --i) {
            if (this.firstException != null) {
                this.resources.get(i).forceCleanUp();
                continue;
            }
            try {
                boolean released = this.resources.get(i).awaitReleased(this.timeoutNanos - this.stopwatch.elapsed(TimeUnit.NANOSECONDS), TimeUnit.NANOSECONDS);
                if (!released) {
                    this.firstException = new AssertionError((Object)("Resource " + this.resources.get(i) + " can not be released in time at the end of test"));
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                this.firstException = e;
            }
            if (this.firstException == null) continue;
            this.resources.get(i).forceCleanUp();
        }
        this.resources.clear();
    }

    private static final class ServerResource
    implements Resource {
        final Server server;

        ServerResource(Server server) {
            this.server = server;
        }

        @Override
        public void cleanUp() {
            this.server.shutdown();
        }

        @Override
        public void forceCleanUp() {
            this.server.shutdownNow();
        }

        @Override
        public boolean awaitReleased(long duration, TimeUnit timeUnit) throws InterruptedException {
            return this.server.awaitTermination(duration, timeUnit);
        }

        public String toString() {
            return this.server.toString();
        }
    }

    private static final class ManagedChannelResource
    implements Resource {
        final ManagedChannel channel;

        ManagedChannelResource(ManagedChannel channel) {
            this.channel = channel;
        }

        @Override
        public void cleanUp() {
            this.channel.shutdown();
        }

        @Override
        public void forceCleanUp() {
            this.channel.shutdownNow();
        }

        @Override
        public boolean awaitReleased(long duration, TimeUnit timeUnit) throws InterruptedException {
            return this.channel.awaitTermination(duration, timeUnit);
        }

        public String toString() {
            return this.channel.toString();
        }
    }

    @VisibleForTesting
    static interface Resource {
        public void cleanUp();

        public void forceCleanUp();

        public boolean awaitReleased(long var1, TimeUnit var3) throws InterruptedException;
    }
}

