/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.linq4j.tree;

import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Objects;
import org.apache.calcite.linq4j.tree.BlockStatement;
import org.apache.calcite.linq4j.tree.ExpressionWriter;
import org.apache.calcite.linq4j.tree.MemberDeclaration;
import org.apache.calcite.linq4j.tree.ParameterExpression;
import org.apache.calcite.linq4j.tree.Shuttle;
import org.apache.calcite.linq4j.tree.Types;
import org.apache.calcite.linq4j.tree.Visitor;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ConstructorDeclaration
extends MemberDeclaration {
    public final int modifier;
    public final Type resultType;
    public final List<ParameterExpression> parameters;
    public final BlockStatement body;
    private int hash;

    public ConstructorDeclaration(int modifier, Type declaredAgainst, List<ParameterExpression> parameters, BlockStatement body) {
        this.modifier = modifier;
        this.resultType = Objects.requireNonNull(declaredAgainst, "declaredAgainst");
        this.parameters = Objects.requireNonNull(parameters, "parameters");
        this.body = Objects.requireNonNull(body, "body");
    }

    @Override
    public MemberDeclaration accept(Shuttle shuttle) {
        shuttle = shuttle.preVisit(this);
        BlockStatement body = this.body.accept(shuttle);
        return shuttle.visit(this, body);
    }

    @Override
    public <R> R accept(Visitor<R> visitor) {
        return visitor.visit(this);
    }

    @Override
    public void accept(ExpressionWriter writer) {
        String modifiers = Modifier.toString(this.modifier);
        writer.append(modifiers);
        if (!modifiers.isEmpty()) {
            writer.append(' ');
        }
        writer.append(this.resultType).list("(", ", ", ")", () -> this.parameters.stream().map(parameter -> {
            String modifiers1 = Modifier.toString(parameter.modifier);
            return modifiers1 + (modifiers1.isEmpty() ? "" : " ") + Types.className(parameter.getType()) + " " + parameter.name;
        }).iterator()).append(' ').append(this.body);
        writer.newlineAndIndent();
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConstructorDeclaration that = (ConstructorDeclaration)o;
        return this.modifier == that.modifier && this.body.equals(that.body) && this.parameters.equals(that.parameters) && this.resultType.equals(that.resultType);
    }

    public int hashCode() {
        int result = this.hash;
        if (result == 0) {
            result = Objects.hash(this.modifier, this.resultType, this.parameters, this.body);
            if (result == 0) {
                result = 1;
            }
            this.hash = result;
        }
        return result;
    }
}

