/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.s3;

import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.spi.EndpointUriFactory;
import org.apache.camel.support.component.EndpointUriFactorySupport;

public class S3EndpointUriFactory
extends EndpointUriFactorySupport
implements EndpointUriFactory {
    private static final String BASE = "://bucketNameOrArn";
    private static final Set<String> PROPERTY_NAMES;
    private static final Set<String> SECRET_PROPERTY_NAMES;

    public boolean isEnabled(String scheme) {
        return "aws-s3".equals(scheme);
    }

    public String buildUri(String scheme, Map<String, Object> properties, boolean encode) throws URISyntaxException {
        String syntax;
        String uri = syntax = scheme + BASE;
        HashMap<String, Object> copy = new HashMap<String, Object>(properties);
        uri = this.buildPathParameter(syntax, uri, "bucketNameOrArn", null, true, copy);
        uri = this.buildQueryParameters(uri, copy, encode);
        return uri;
    }

    public Set<String> propertyNames() {
        return PROPERTY_NAMES;
    }

    public Set<String> secretPropertyNames() {
        return SECRET_PROPERTY_NAMES;
    }

    public boolean isLenientProperties() {
        return false;
    }

    static {
        HashSet<String> props = new HashSet<String>(59);
        props.add("useIAMCredentials");
        props.add("fileName");
        props.add("serverSideEncryption");
        props.add("bucketNameOrArn");
        props.add("prefix");
        props.add("useAwsKMS");
        props.add("initialDelay");
        props.add("proxyPort");
        props.add("bridgeErrorHandler");
        props.add("awsKMSKeyId");
        props.add("payloadSigningEnabled");
        props.add("delimiter");
        props.add("amazonS3Client");
        props.add("greedy");
        props.add("maxMessagesPerPoll");
        props.add("scheduledExecutorService");
        props.add("repeatCount");
        props.add("encryptionMaterials");
        props.add("dualstackEnabled");
        props.add("sendEmptyMessageWhenIdle");
        props.add("schedulerProperties");
        props.add("pathStyleAccess");
        props.add("proxyHost");
        props.add("backoffIdleThreshold");
        props.add("lazyStartProducer");
        props.add("delay");
        props.add("includeBody");
        props.add("startScheduler");
        props.add("accessKey");
        props.add("endpointConfiguration");
        props.add("deleteAfterWrite");
        props.add("region");
        props.add("exceptionHandler");
        props.add("backoffMultiplier");
        props.add("partSize");
        props.add("chunkedEncodingDisabled");
        props.add("scheduler");
        props.add("multiPartUpload");
        props.add("storageClass");
        props.add("useFixedDelay");
        props.add("doneFileName");
        props.add("runLoggingLevel");
        props.add("backoffErrorThreshold");
        props.add("policy");
        props.add("maxConnections");
        props.add("forceGlobalBucketAccessEnabled");
        props.add("timeUnit");
        props.add("autoDiscoverClient");
        props.add("accelerateModeEnabled");
        props.add("autoCreateBucket");
        props.add("proxyProtocol");
        props.add("secretKey");
        props.add("exchangePattern");
        props.add("keyName");
        props.add("autocloseBody");
        props.add("pollStrategy");
        props.add("useEncryption");
        props.add("deleteAfterRead");
        props.add("operation");
        PROPERTY_NAMES = Collections.unmodifiableSet(props);
        HashSet<String> secretProps = new HashSet<String>(2);
        secretProps.add("secretKey");
        secretProps.add("accessKey");
        SECRET_PROPERTY_NAMES = Collections.unmodifiableSet(secretProps);
    }
}

