/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.micrometer.eventnotifier;

import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.Timer;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import org.apache.camel.Exchange;
import org.apache.camel.Route;
import org.apache.camel.component.micrometer.eventnotifier.AbstractMicrometerEventNotifier;
import org.apache.camel.component.micrometer.eventnotifier.MicrometerExchangeEventNotifierNamingStrategy;
import org.apache.camel.spi.CamelEvent;
import org.apache.camel.spi.EventNotifier;
import org.apache.camel.spi.InflightRepository;
import org.apache.camel.spi.ManagementStrategy;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.support.SimpleEventNotifierSupport;

public class MicrometerExchangeEventNotifier
extends AbstractMicrometerEventNotifier<CamelEvent.ExchangeEvent> {
    private InflightRepository inflightRepository;
    private final Map<String, Meter> meterMap = new HashMap<String, Meter>();
    private Predicate<Exchange> ignoreExchanges = exchange -> false;
    private MicrometerExchangeEventNotifierNamingStrategy namingStrategy = MicrometerExchangeEventNotifierNamingStrategy.DEFAULT;
    boolean registerKamelets;
    boolean registerTemplates = true;

    public MicrometerExchangeEventNotifier() {
        super(CamelEvent.ExchangeEvent.class);
    }

    public void setIgnoreExchanges(Predicate<Exchange> ignoreExchanges) {
        this.ignoreExchanges = ignoreExchanges;
    }

    public Predicate<Exchange> getIgnoreExchanges() {
        return this.ignoreExchanges;
    }

    public MicrometerExchangeEventNotifierNamingStrategy getNamingStrategy() {
        return this.namingStrategy;
    }

    public void setNamingStrategy(MicrometerExchangeEventNotifierNamingStrategy namingStrategy) {
        this.namingStrategy = namingStrategy;
    }

    protected void doInit() throws Exception {
        ManagementStrategy ms = this.getCamelContext().getManagementStrategy();
        if (ms != null && ms.getManagementAgent() != null) {
            this.registerKamelets = ms.getManagementAgent().getRegisterRoutesCreateByKamelet();
            this.registerTemplates = ms.getManagementAgent().getRegisterRoutesCreateByTemplate();
        }
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        this.inflightRepository = this.getCamelContext().getInflightRepository();
        this.getCamelContext().getManagementStrategy().addEventNotifier((EventNotifier)new SimpleEventNotifierSupport(){

            public void notify(CamelEvent event) throws Exception {
                CamelEvent.RouteRemovedEvent rre;
                String id;
                Meter meter;
                if (event instanceof CamelEvent.RouteRemovedEvent && (meter = MicrometerExchangeEventNotifier.this.meterMap.remove(id = (rre = (CamelEvent.RouteRemovedEvent)event).getRoute().getRouteId())) != null) {
                    MicrometerExchangeEventNotifier.this.getMeterRegistry().remove(meter);
                }
            }
        });
    }

    protected void doStop() throws Exception {
        super.doStop();
        this.meterMap.values().forEach(m -> this.getMeterRegistry().remove(m));
        this.meterMap.clear();
    }

    public void notify(CamelEvent eventObject) {
        if (eventObject instanceof CamelEvent.ExchangeEvent) {
            Route route;
            CamelEvent.ExchangeEvent ee = (CamelEvent.ExchangeEvent)eventObject;
            boolean skip = false;
            String routeId = eventObject instanceof CamelEvent.ExchangeCreatedEvent ? ee.getExchange().getFromRouteId() : ExchangeHelper.getAtRouteId((Exchange)ee.getExchange());
            if (routeId != null && (route = ee.getExchange().getContext().getRoute(routeId)) != null) {
                boolean bl = skip = route.isCreatedByKamelet() && !this.registerKamelets || route.isCreatedByRouteTemplate() && !this.registerTemplates;
            }
            if (skip) {
                return;
            }
            if (!this.getIgnoreExchanges().test(ee.getExchange())) {
                this.handleExchangeEvent(ee);
                if (eventObject instanceof CamelEvent.ExchangeCreatedEvent) {
                    this.handleCreatedEvent((CamelEvent.ExchangeCreatedEvent)eventObject);
                } else if (eventObject instanceof CamelEvent.ExchangeSentEvent) {
                    this.handleSentEvent((CamelEvent.ExchangeSentEvent)eventObject);
                } else if (eventObject instanceof CamelEvent.ExchangeCompletedEvent || eventObject instanceof CamelEvent.ExchangeFailedEvent) {
                    this.handleDoneEvent((CamelEvent.ExchangeEvent)eventObject);
                }
            }
        }
    }

    private void handleExchangeEvent(CamelEvent.ExchangeEvent exchangeEvent) {
        Exchange exchange = exchangeEvent.getExchange();
        if (exchange.getFromRouteId() != null && exchange.getFromEndpoint() != null) {
            String name = this.namingStrategy.getInflightExchangesName(exchange, exchange.getFromEndpoint());
            Tags tags = this.namingStrategy.getInflightExchangesTags(exchangeEvent, exchange.getFromEndpoint());
            Gauge meter = Gauge.builder((String)name, () -> this.getInflightExchangesInRoute(exchangeEvent)).description("Route inflight messages").tags((Iterable)tags).register(this.getMeterRegistry());
            this.meterMap.put(exchange.getFromRouteId(), (Meter)meter);
        }
    }

    protected void handleSentEvent(CamelEvent.ExchangeSentEvent sentEvent) {
        String name = this.namingStrategy.getName(sentEvent.getExchange(), sentEvent.getEndpoint());
        Tags tags = this.namingStrategy.getTags((CamelEvent.ExchangeEvent)sentEvent, sentEvent.getEndpoint());
        Timer timer = Timer.builder((String)name).tags((Iterable)tags).description("Time taken to send message to the endpoint").register(this.getMeterRegistry());
        timer.record(sentEvent.getTimeTaken(), TimeUnit.MILLISECONDS);
    }

    protected void handleCreatedEvent(CamelEvent.ExchangeCreatedEvent createdEvent) {
        String name = this.namingStrategy.getName(createdEvent.getExchange(), createdEvent.getExchange().getFromEndpoint());
        createdEvent.getExchange().setProperty("eventTimer:" + name, (Object)Timer.start((MeterRegistry)this.getMeterRegistry()));
    }

    protected void handleDoneEvent(CamelEvent.ExchangeEvent doneEvent) {
        String name = this.namingStrategy.getName(doneEvent.getExchange(), doneEvent.getExchange().getFromEndpoint());
        Tags tags = this.namingStrategy.getTags(doneEvent, doneEvent.getExchange().getFromEndpoint());
        Timer.Sample sample = (Timer.Sample)doneEvent.getExchange().removeProperty("eventTimer:" + name);
        if (sample != null) {
            sample.stop(this.getMeterRegistry().timer(name, (Iterable)tags));
        }
    }

    private int getInflightExchangesInRoute(CamelEvent.ExchangeEvent exchangeEvent) {
        String routeId = exchangeEvent.getExchange().getFromRouteId();
        return this.inflightRepository.size(routeId);
    }
}

