/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.junit5;

import java.lang.reflect.Method;
import org.apache.camel.test.junit5.util.ExtensionHelper;
import org.apache.camel.util.StopWatch;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.AfterTestExecutionCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.BeforeTestExecutionCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

public class TestLoggerExtension
implements BeforeEachCallback,
AfterEachCallback,
BeforeTestExecutionCallback,
AfterTestExecutionCallback {
    private static final String START_TIME = "start time";
    private String currentTestName;

    public void afterEach(ExtensionContext context) throws Exception {
        Class<?> testClass = context.getTestClass().orElse(this.getClass());
        StopWatch durationTracker = (StopWatch)this.getStore(context, testClass).remove((Object)START_TIME, StopWatch.class);
        Method testMethod = context.getRequiredTestMethod();
        if (durationTracker != null) {
            ExtensionHelper.testEndFooter(testClass, testMethod.getName(), durationTracker.taken());
        } else {
            ExtensionHelper.testEndFooter(testClass, testMethod.getName(), 0L);
        }
    }

    public void beforeEach(ExtensionContext context) throws Exception {
        this.currentTestName = context.getDisplayName();
    }

    public void afterTestExecution(ExtensionContext context) {
    }

    public void beforeTestExecution(ExtensionContext context) {
        this.currentTestName = context.getDisplayName();
        Class<?> testClass = context.getTestClass().orElse(this.getClass());
        ExtensionHelper.testStartHeader(testClass, this.currentTestName);
        ExtensionContext.Store store = this.getStore(context, testClass);
        store.getOrComputeIfAbsent((Object)START_TIME, key -> new StopWatch(), Object.class);
    }

    private ExtensionContext.Store getStore(ExtensionContext context, Class<?> testClass) {
        return context.getStore(ExtensionContext.Namespace.create((Object[])new Object[]{testClass, context.getRequiredTestMethod()}));
    }
}

