/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.spring.junit5;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.StringJoiner;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.apache.camel.CamelContext;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.api.management.ManagedCamelContext;
import org.apache.camel.api.management.mbean.ManagedCamelContextMBean;
import org.apache.camel.component.mock.InterceptSendToMockEndpointStrategy;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.impl.debugger.DefaultDebugger;
import org.apache.camel.spi.Breakpoint;
import org.apache.camel.spi.Debugger;
import org.apache.camel.spi.EndpointStrategy;
import org.apache.camel.spi.EventNotifier;
import org.apache.camel.spi.PropertiesComponent;
import org.apache.camel.spring.SpringCamelContext;
import org.apache.camel.test.junit5.TestSupport;
import org.apache.camel.test.spring.junit5.CamelSpringTestHelper;
import org.apache.camel.test.spring.junit5.DisableJmx;
import org.apache.camel.test.spring.junit5.EnableRouteCoverage;
import org.apache.camel.test.spring.junit5.ExcludeRoutes;
import org.apache.camel.test.spring.junit5.MockEndpoints;
import org.apache.camel.test.spring.junit5.MockEndpointsAndSkip;
import org.apache.camel.test.spring.junit5.ProvidesBreakpoint;
import org.apache.camel.test.spring.junit5.RouteCoverageDumper;
import org.apache.camel.test.spring.junit5.RouteCoverageEventNotifier;
import org.apache.camel.test.spring.junit5.ShutdownTimeout;
import org.apache.camel.test.spring.junit5.UseAdviceWith;
import org.apache.camel.test.spring.junit5.UseOverridePropertiesWithPropertiesComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.annotation.AnnotationUtils;

public final class CamelAnnotationsHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(CamelAnnotationsHandler.class);

    private CamelAnnotationsHandler() {
    }

    public static void cleanup() {
        DefaultCamelContext.clearOptions();
    }

    public static void handleExcludeRoutes(Class<?> testClass) {
        String key = "CamelTestSpringExcludeRoutes";
        String exists = System.getProperty(key);
        if (exists != null) {
            LOGGER.warn("The JVM property {} is set, but not supported anymore.", (Object)key);
        }
        if (testClass.isAnnotationPresent(ExcludeRoutes.class)) {
            Class<? extends RoutesBuilder>[] routes = testClass.getAnnotation(ExcludeRoutes.class).value();
            StringJoiner routesBuilder = new StringJoiner(",");
            for (Class<? extends RoutesBuilder> clazz : routes) {
                routesBuilder.add(clazz.getName());
            }
            String value = routesBuilder.toString();
            LOGGER.info("@ExcludeRoutes annotation found. Setting up JVM property {}={}", (Object)key, (Object)value);
            DefaultCamelContext.setExcludeRoutes((String)value);
        }
    }

    public static void handleDisableJmx(Class<?> testClass) {
        if (TestSupport.isCamelDebugPresent()) {
            LOGGER.info("Enabling Camel JMX as camel-debug has been found in the classpath.");
            DefaultCamelContext.setDisableJmx((boolean)false);
        } else if (testClass.isAnnotationPresent(DisableJmx.class)) {
            if (testClass.getAnnotation(DisableJmx.class).value()) {
                LOGGER.info("Disabling Camel JMX globally as DisableJmx annotation was found and disableJmx is set to true.");
                DefaultCamelContext.setDisableJmx((boolean)true);
            } else {
                LOGGER.info("Enabling Camel JMX as DisableJmx annotation was found and disableJmx is set to false.");
                DefaultCamelContext.setDisableJmx((boolean)false);
            }
        } else if (!testClass.isAnnotationPresent(EnableRouteCoverage.class)) {
            LOGGER.info("Disabling Camel JMX globally for tests by default. Use the DisableJMX annotation to override the default setting.");
            DefaultCamelContext.setDisableJmx((boolean)true);
        } else {
            LOGGER.info("Enabling Camel JMX as EnableRouteCoverage is used.");
            DefaultCamelContext.setDisableJmx((boolean)false);
        }
    }

    public static void handleRouteCoverage(ConfigurableApplicationContext context, final Class<?> testClass, final Function testMethod) throws Exception {
        if (testClass.isAnnotationPresent(EnableRouteCoverage.class)) {
            System.setProperty("CamelTestRouteCoverage", "true");
            CamelSpringTestHelper.doToSpringCamelContexts((ApplicationContext)context, new CamelSpringTestHelper.DoToSpringCamelContextsStrategy(){

                @Override
                public void execute(String contextName, SpringCamelContext camelContext) throws Exception {
                    LOGGER.info("Enabling RouteCoverage");
                    RouteCoverageEventNotifier notifier = new RouteCoverageEventNotifier(testClass.getName(), testMethod);
                    camelContext.addService((Object)notifier, true);
                    camelContext.getManagementStrategy().addEventNotifier((EventNotifier)notifier);
                }
            });
        }
    }

    public static void handleRouteCoverageDump(ConfigurableApplicationContext context, final Class<?> testClass, final Function testMethod) throws Exception {
        if (testClass.isAnnotationPresent(EnableRouteCoverage.class)) {
            CamelSpringTestHelper.doToSpringCamelContexts((ApplicationContext)context, new CamelSpringTestHelper.DoToSpringCamelContextsStrategy(){

                @Override
                public void execute(String contextName, SpringCamelContext camelContext) throws Exception {
                    RouteCoverageEventNotifier eventNotifier;
                    LOGGER.debug("Dumping RouteCoverage");
                    String testMethodName = (String)testMethod.apply(this);
                    RouteCoverageDumper.dumpRouteCoverage((CamelContext)camelContext, testClass.getName(), testMethodName);
                    ManagedCamelContext managedCamelContext = (ManagedCamelContext)camelContext.getExtension(ManagedCamelContext.class);
                    if (managedCamelContext != null) {
                        ManagedCamelContextMBean mBean = managedCamelContext.getManagedCamelContext();
                        LOGGER.debug("Resetting JMX statistics for RouteCoverage");
                        mBean.reset(true);
                    }
                    if ((eventNotifier = (RouteCoverageEventNotifier)((Object)camelContext.hasService(RouteCoverageEventNotifier.class))) != null) {
                        camelContext.getManagementStrategy().removeEventNotifier((EventNotifier)eventNotifier);
                        camelContext.removeService((Object)eventNotifier);
                    }
                }
            });
        }
    }

    public static void handleProvidesBreakpoint(ConfigurableApplicationContext context, Class<?> testClass) throws Exception {
        Collection<Method> methods = CamelSpringTestHelper.getAllMethods(testClass);
        final LinkedList<Breakpoint> breakpoints = new LinkedList<Breakpoint>();
        for (Method method : methods) {
            if (AnnotationUtils.findAnnotation((Method)method, ProvidesBreakpoint.class) == null) continue;
            Class<?>[] argTypes = method.getParameterTypes();
            if (argTypes.length != 0) {
                throw new IllegalArgumentException("Method [" + method.getName() + "] is annotated with ProvidesBreakpoint but is not a no-argument method.");
            }
            if (!Breakpoint.class.isAssignableFrom(method.getReturnType())) {
                throw new IllegalArgumentException("Method [" + method.getName() + "] is annotated with ProvidesBreakpoint but does not return a Breakpoint.");
            }
            if (!Modifier.isStatic(method.getModifiers())) {
                throw new IllegalArgumentException("Method [" + method.getName() + "] is annotated with ProvidesBreakpoint but is not static.");
            }
            if (!Modifier.isPublic(method.getModifiers())) {
                throw new IllegalArgumentException("Method [" + method.getName() + "] is annotated with ProvidesBreakpoint but is not public.");
            }
            try {
                breakpoints.add((Breakpoint)method.invoke(null, new Object[0]));
            }
            catch (Exception e) {
                throw new RuntimeException("Method [" + method.getName() + "] threw exception during evaluation.", e);
            }
        }
        if (!breakpoints.isEmpty()) {
            CamelSpringTestHelper.doToSpringCamelContexts((ApplicationContext)context, new CamelSpringTestHelper.DoToSpringCamelContextsStrategy(){

                @Override
                public void execute(String contextName, SpringCamelContext camelContext) throws Exception {
                    camelContext.setDebugging(Boolean.valueOf(true));
                    Debugger debugger = camelContext.getDebugger();
                    if (debugger == null) {
                        debugger = new DefaultDebugger();
                        camelContext.setDebugger(debugger);
                    }
                    for (Breakpoint breakpoint : breakpoints) {
                        LOGGER.info("Adding Breakpoint [{}] to CamelContext with name [{}].", (Object)breakpoint, (Object)contextName);
                        debugger.addBreakpoint(breakpoint);
                    }
                }
            });
        }
    }

    public static void handleShutdownTimeout(ConfigurableApplicationContext context, Class<?> testClass) throws Exception {
        TimeUnit shutdownTimeUnit;
        int shutdownTimeout;
        if (testClass.isAnnotationPresent(ShutdownTimeout.class)) {
            shutdownTimeout = testClass.getAnnotation(ShutdownTimeout.class).value();
            shutdownTimeUnit = testClass.getAnnotation(ShutdownTimeout.class).timeUnit();
        } else {
            shutdownTimeout = 10;
            shutdownTimeUnit = TimeUnit.SECONDS;
        }
        CamelSpringTestHelper.doToSpringCamelContexts((ApplicationContext)context, new CamelSpringTestHelper.DoToSpringCamelContextsStrategy(){

            @Override
            public void execute(String contextName, SpringCamelContext camelContext) throws Exception {
                LOGGER.info("Setting shutdown timeout to [{} {}] on CamelContext with name [{}].", new Object[]{shutdownTimeout, shutdownTimeUnit, contextName});
                camelContext.getShutdownStrategy().setTimeout((long)shutdownTimeout);
                camelContext.getShutdownStrategy().setTimeUnit(shutdownTimeUnit);
            }
        });
    }

    public static void handleMockEndpoints(ConfigurableApplicationContext context, Class<?> testClass) throws Exception {
        if (testClass.isAnnotationPresent(MockEndpoints.class)) {
            final String mockEndpoints = testClass.getAnnotation(MockEndpoints.class).value();
            CamelSpringTestHelper.doToSpringCamelContexts((ApplicationContext)context, new CamelSpringTestHelper.DoToSpringCamelContextsStrategy(){

                @Override
                public void execute(String contextName, SpringCamelContext camelContext) throws Exception {
                    LOGGER.info("Enabling auto mocking of endpoints matching pattern [{}] on CamelContext with name [{}].", (Object)mockEndpoints, (Object)contextName);
                    ((ExtendedCamelContext)camelContext.adapt(ExtendedCamelContext.class)).registerEndpointCallback((EndpointStrategy)new InterceptSendToMockEndpointStrategy(mockEndpoints));
                }
            });
        }
    }

    public static void handleMockEndpointsAndSkip(ConfigurableApplicationContext context, Class<?> testClass) throws Exception {
        if (testClass.isAnnotationPresent(MockEndpointsAndSkip.class)) {
            final String mockEndpoints = testClass.getAnnotation(MockEndpointsAndSkip.class).value();
            CamelSpringTestHelper.doToSpringCamelContexts((ApplicationContext)context, new CamelSpringTestHelper.DoToSpringCamelContextsStrategy(){

                @Override
                public void execute(String contextName, SpringCamelContext camelContext) throws Exception {
                    String mockEndpointsValue = camelContext.resolvePropertyPlaceholders(mockEndpoints);
                    LOGGER.info("Enabling auto mocking and skipping of endpoints matching pattern [{}] on CamelContext with name [{}].", (Object)mockEndpointsValue, (Object)contextName);
                    ((ExtendedCamelContext)camelContext.adapt(ExtendedCamelContext.class)).registerEndpointCallback((EndpointStrategy)new InterceptSendToMockEndpointStrategy(mockEndpointsValue, true));
                }
            });
        }
    }

    public static void handleUseOverridePropertiesWithPropertiesComponent(ConfigurableApplicationContext context, Class<?> testClass) throws Exception {
        Collection<Method> methods = CamelSpringTestHelper.getAllMethods(testClass);
        LinkedList<Properties> properties = new LinkedList<Properties>();
        for (Method method : methods) {
            if (AnnotationUtils.findAnnotation((Method)method, UseOverridePropertiesWithPropertiesComponent.class) == null) continue;
            Class<?>[] argTypes = method.getParameterTypes();
            if (argTypes.length > 0) {
                throw new IllegalArgumentException("Method [" + method.getName() + "] is annotated with UseOverridePropertiesWithPropertiesComponent but is not a no-argument method.");
            }
            if (!Properties.class.isAssignableFrom(method.getReturnType())) {
                throw new IllegalArgumentException("Method [" + method.getName() + "] is annotated with UseOverridePropertiesWithPropertiesComponent but does not return a java.util.Properties.");
            }
            if (!Modifier.isStatic(method.getModifiers())) {
                throw new IllegalArgumentException("Method [" + method.getName() + "] is annotated with UseOverridePropertiesWithPropertiesComponent but is not static.");
            }
            if (!Modifier.isPublic(method.getModifiers())) {
                throw new IllegalArgumentException("Method [" + method.getName() + "] is annotated with UseOverridePropertiesWithPropertiesComponent but is not public.");
            }
            try {
                properties.add((Properties)method.invoke(null, new Object[0]));
            }
            catch (Exception e) {
                throw new RuntimeException("Method [" + method.getName() + "] threw exception during evaluation.", e);
            }
        }
        final Properties extra = new Properties();
        for (Properties prop : properties) {
            extra.putAll((Map<?, ?>)prop);
        }
        if (!extra.isEmpty()) {
            context.addBeanFactoryPostProcessor(beanFactory -> beanFactory.addBeanPostProcessor(new BeanPostProcessor(){

                public Object postProcessBeforeInitialization(Object bean, String beanName) {
                    if (bean instanceof PropertiesComponent) {
                        PropertiesComponent pc = (PropertiesComponent)bean;
                        LOGGER.info("Using {} properties to override any existing properties on the PropertiesComponent", (Object)extra.size());
                        pc.setOverrideProperties(extra);
                    }
                    return bean;
                }
            }));
        }
    }

    public static void handleCamelContextStartup(ConfigurableApplicationContext context, Class<?> testClass) throws Exception {
        boolean skip = "true".equalsIgnoreCase(System.getProperty("skipStartingCamelContext"));
        if (skip) {
            LOGGER.info("Skipping starting CamelContext(s) as system property skipStartingCamelContext is set to be true.");
        } else if (testClass.isAnnotationPresent(UseAdviceWith.class)) {
            if (testClass.getAnnotation(UseAdviceWith.class).value()) {
                LOGGER.info("Skipping starting CamelContext(s) as UseAdviceWith annotation was found and isUseAdviceWith is set to true.");
                skip = true;
            } else {
                LOGGER.info("Starting CamelContext(s) as UseAdviceWith annotation was found, but isUseAdviceWith is set to false.");
                skip = false;
            }
        }
        if (!skip) {
            CamelSpringTestHelper.doToSpringCamelContexts((ApplicationContext)context, new CamelSpringTestHelper.DoToSpringCamelContextsStrategy(){

                @Override
                public void execute(String contextName, SpringCamelContext camelContext) throws Exception {
                    if (!camelContext.isStarted()) {
                        LOGGER.info("Starting CamelContext with name [{}].", (Object)contextName);
                        camelContext.start();
                    } else {
                        LOGGER.debug("CamelContext with name [{}] already started.", (Object)contextName);
                    }
                }
            });
        }
    }
}

