/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.vertx.common;

import io.netty.buffer.ByteBuf;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonArray;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.apache.camel.Converter;
import org.apache.camel.util.IOHelper;

@Converter(generateLoader=true)
public final class VertxJsonArrayConverter {
    private VertxJsonArrayConverter() {
    }

    @Converter
    public static JsonArray toJsonArray(Buffer buffer) {
        return new JsonArray(buffer);
    }

    @Converter
    public static JsonArray toJsonArray(String string) {
        return new JsonArray(string);
    }

    @Converter
    public static JsonArray toJsonArray(byte[] bytes) {
        return Buffer.buffer((byte[])bytes).toJsonArray();
    }

    @Converter
    public static JsonArray toJsonArray(ByteBuf byteBuf) {
        return Buffer.buffer((ByteBuf)byteBuf).toJsonArray();
    }

    @Converter
    public static JsonArray toJsonArray(List list) {
        return new JsonArray(list);
    }

    @Converter
    public static JsonArray toJsonArray(InputStream inputStream) throws IOException {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            IOHelper.copy((InputStream)IOHelper.buffered((InputStream)inputStream), (OutputStream)bos);
            JsonArray jsonArray = Buffer.buffer((byte[])bos.toByteArray()).toJsonArray();
            return jsonArray;
        }
        finally {
            IOHelper.close((Closeable)inputStream);
        }
    }

    @Converter
    public static Buffer toBuffer(JsonArray jsonArray) {
        return jsonArray.toBuffer();
    }

    @Converter
    public static String toString(JsonArray jsonArray) {
        return jsonArray.encode();
    }

    @Converter
    public static byte[] toBytes(JsonArray jsonArray) {
        return jsonArray.toBuffer().getBytes();
    }

    @Converter
    public static List toList(JsonArray jsonArray) {
        return jsonArray.getList();
    }

    @Converter
    public static InputStream toInputStream(JsonArray jsonArray) {
        return new ByteArrayInputStream(jsonArray.toBuffer().getBytes());
    }
}

