/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements;

import com.google.common.collect.ImmutableMap;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.cql3.statements.UpdatesCollector;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.db.CounterMutation;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.IMutation;
import org.apache.cassandra.db.Mutation;
import org.apache.cassandra.db.RegularAndStaticColumns;
import org.apache.cassandra.db.partitions.PartitionUpdate;
import org.apache.cassandra.db.virtual.VirtualMutation;
import org.apache.cassandra.schema.TableId;
import org.apache.cassandra.schema.TableMetadata;

final class BatchUpdatesCollector
implements UpdatesCollector {
    private final Map<TableId, RegularAndStaticColumns> updatedColumns;
    private final int updatedRows;
    private final Map<String, Map<ByteBuffer, IMutationBuilder>> mutationBuilders = new HashMap<String, Map<ByteBuffer, IMutationBuilder>>();

    BatchUpdatesCollector(Map<TableId, RegularAndStaticColumns> updatedColumns, int updatedRows) {
        this.updatedColumns = updatedColumns;
        this.updatedRows = updatedRows;
    }

    @Override
    public PartitionUpdate.Builder getPartitionUpdateBuilder(TableMetadata metadata, DecoratedKey dk, ConsistencyLevel consistency) {
        IMutationBuilder mut = this.getMutationBuilder(metadata, dk, consistency);
        PartitionUpdate.Builder upd = mut.get(metadata.id);
        if (upd == null) {
            RegularAndStaticColumns columns = this.updatedColumns.get(metadata.id);
            assert (columns != null);
            upd = new PartitionUpdate.Builder(metadata, dk, columns, this.updatedRows);
            mut.add(upd);
        }
        return upd;
    }

    private IMutationBuilder getMutationBuilder(TableMetadata metadata, DecoratedKey dk, ConsistencyLevel consistency) {
        return this.keyspaceMap(metadata.keyspace).computeIfAbsent(dk.getKey(), k -> this.makeMutationBuilder(metadata, dk, consistency));
    }

    private IMutationBuilder makeMutationBuilder(TableMetadata metadata, DecoratedKey partitionKey, ConsistencyLevel cl) {
        if (metadata.isVirtual()) {
            return new VirtualMutationBuilder(metadata.keyspace, partitionKey);
        }
        MutationBuilder builder = new MutationBuilder(metadata.keyspace, partitionKey);
        return metadata.isCounter() ? new CounterMutationBuilder(builder, cl) : builder;
    }

    @Override
    public List<IMutation> toMutations() {
        ArrayList<IMutation> ms = new ArrayList<IMutation>();
        for (Map<ByteBuffer, IMutationBuilder> ksMap : this.mutationBuilders.values()) {
            for (IMutationBuilder builder : ksMap.values()) {
                IMutation mutation = builder.build();
                mutation.validateIndexedColumns();
                ms.add(mutation);
            }
        }
        return ms;
    }

    private Map<ByteBuffer, IMutationBuilder> keyspaceMap(String ksName) {
        return this.mutationBuilders.computeIfAbsent(ksName, k -> new HashMap());
    }

    private static class VirtualMutationBuilder
    implements IMutationBuilder {
        private final String keyspaceName;
        private final DecoratedKey partitionKey;
        private final HashMap<TableId, PartitionUpdate.Builder> modifications = new HashMap();

        private VirtualMutationBuilder(String keyspaceName, DecoratedKey partitionKey) {
            this.keyspaceName = keyspaceName;
            this.partitionKey = partitionKey;
        }

        @Override
        public VirtualMutationBuilder add(PartitionUpdate.Builder builder) {
            PartitionUpdate.Builder prev = this.modifications.put(builder.metadata().id, builder);
            if (null != prev) {
                throw new IllegalStateException();
            }
            return this;
        }

        @Override
        public VirtualMutation build() {
            ImmutableMap.Builder updates = new ImmutableMap.Builder();
            this.modifications.forEach((tableId, updateBuilder) -> updates.put(tableId, (Object)updateBuilder.build()));
            return new VirtualMutation(this.keyspaceName, this.partitionKey, (ImmutableMap<TableId, PartitionUpdate>)updates.build());
        }

        @Override
        public PartitionUpdate.Builder get(TableId tableId) {
            return this.modifications.get(tableId);
        }
    }

    private static class CounterMutationBuilder
    implements IMutationBuilder {
        private final MutationBuilder mutationBuilder;
        private final ConsistencyLevel cl;

        private CounterMutationBuilder(MutationBuilder mutationBuilder, ConsistencyLevel cl) {
            this.mutationBuilder = mutationBuilder;
            this.cl = cl;
        }

        @Override
        public IMutationBuilder add(PartitionUpdate.Builder builder) {
            return this.mutationBuilder.add(builder);
        }

        @Override
        public IMutation build() {
            return new CounterMutation(this.mutationBuilder.build(), this.cl);
        }

        @Override
        public PartitionUpdate.Builder get(TableId id) {
            return this.mutationBuilder.get(id);
        }
    }

    private static class MutationBuilder
    implements IMutationBuilder {
        private final HashMap<TableId, PartitionUpdate.Builder> modifications = new HashMap();
        private final DecoratedKey key;
        private final String keyspaceName;
        private final long createdAt = System.currentTimeMillis();

        private MutationBuilder(String keyspaceName, DecoratedKey key) {
            this.keyspaceName = keyspaceName;
            this.key = key;
        }

        @Override
        public MutationBuilder add(PartitionUpdate.Builder updateBuilder) {
            assert (updateBuilder != null);
            assert (updateBuilder.partitionKey().getPartitioner() == this.key.getPartitioner());
            PartitionUpdate.Builder prev = this.modifications.put(updateBuilder.metadata().id, updateBuilder);
            if (prev != null) {
                throw new IllegalArgumentException("Table " + updateBuilder.metadata().name + " already has modifications in this mutation: " + prev);
            }
            return this;
        }

        @Override
        public Mutation build() {
            ImmutableMap.Builder updates = new ImmutableMap.Builder();
            for (Map.Entry<TableId, PartitionUpdate.Builder> updateEntry : this.modifications.entrySet()) {
                PartitionUpdate update = updateEntry.getValue().build();
                updates.put((Object)updateEntry.getKey(), (Object)update);
            }
            return new Mutation(this.keyspaceName, this.key, (ImmutableMap<TableId, PartitionUpdate>)updates.build(), this.createdAt);
        }

        @Override
        public PartitionUpdate.Builder get(TableId tableId) {
            return this.modifications.get(tableId);
        }

        public DecoratedKey key() {
            return this.key;
        }

        public boolean isEmpty() {
            return this.modifications.isEmpty();
        }

        public String getKeyspaceName() {
            return this.keyspaceName;
        }
    }

    private static interface IMutationBuilder {
        public IMutationBuilder add(PartitionUpdate.Builder var1);

        public IMutation build();

        public PartitionUpdate.Builder get(TableId var1);
    }
}

