/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import com.google.common.base.Objects;
import com.google.common.hash.Hasher;
import java.io.IOException;
import org.apache.cassandra.cache.IMeasurableMemory;
import org.apache.cassandra.db.LivenessInfo;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.db.rows.Cell;
import org.apache.cassandra.io.ISerializer;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.utils.HashingUtils;
import org.apache.cassandra.utils.ObjectSizes;

public class DeletionTime
implements Comparable<DeletionTime>,
IMeasurableMemory {
    private static final long EMPTY_SIZE = ObjectSizes.measure(new DeletionTime(0L, 0));
    public static final DeletionTime LIVE = new DeletionTime(Long.MIN_VALUE, Integer.MAX_VALUE);
    public static final Serializer serializer = new Serializer();
    private final long markedForDeleteAt;
    private final int localDeletionTime;

    public DeletionTime(long markedForDeleteAt, int localDeletionTime) {
        this.markedForDeleteAt = markedForDeleteAt;
        this.localDeletionTime = localDeletionTime;
    }

    public long markedForDeleteAt() {
        return this.markedForDeleteAt;
    }

    public int localDeletionTime() {
        return this.localDeletionTime;
    }

    public boolean isLive() {
        return this.markedForDeleteAt() == Long.MIN_VALUE && this.localDeletionTime() == Integer.MAX_VALUE;
    }

    public void digest(Hasher hasher) {
        HashingUtils.updateWithLong(hasher, this.markedForDeleteAt());
    }

    public boolean validate() {
        return this.localDeletionTime >= 0;
    }

    public boolean equals(Object o) {
        if (!(o instanceof DeletionTime)) {
            return false;
        }
        DeletionTime that = (DeletionTime)o;
        return this.markedForDeleteAt() == that.markedForDeleteAt() && this.localDeletionTime() == that.localDeletionTime();
    }

    public final int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.markedForDeleteAt(), this.localDeletionTime()});
    }

    public String toString() {
        return String.format("deletedAt=%d, localDeletion=%d", this.markedForDeleteAt(), this.localDeletionTime());
    }

    @Override
    public int compareTo(DeletionTime dt) {
        if (this.markedForDeleteAt() < dt.markedForDeleteAt()) {
            return -1;
        }
        if (this.markedForDeleteAt() > dt.markedForDeleteAt()) {
            return 1;
        }
        if (this.localDeletionTime() < dt.localDeletionTime()) {
            return -1;
        }
        if (this.localDeletionTime() > dt.localDeletionTime()) {
            return 1;
        }
        return 0;
    }

    public boolean supersedes(DeletionTime dt) {
        return this.markedForDeleteAt() > dt.markedForDeleteAt() || this.markedForDeleteAt() == dt.markedForDeleteAt() && this.localDeletionTime() > dt.localDeletionTime();
    }

    public boolean deletes(LivenessInfo info) {
        return this.deletes(info.timestamp());
    }

    public boolean deletes(Cell cell) {
        return this.deletes(cell.timestamp());
    }

    public boolean deletes(long timestamp) {
        return timestamp <= this.markedForDeleteAt();
    }

    public int dataSize() {
        return 12;
    }

    @Override
    public long unsharedHeapSize() {
        return EMPTY_SIZE;
    }

    public static class Serializer
    implements ISerializer<DeletionTime> {
        @Override
        public void serialize(DeletionTime delTime, DataOutputPlus out) throws IOException {
            out.writeInt(delTime.localDeletionTime());
            out.writeLong(delTime.markedForDeleteAt());
        }

        @Override
        public DeletionTime deserialize(DataInputPlus in) throws IOException {
            int ldt = in.readInt();
            long mfda = in.readLong();
            return mfda == Long.MIN_VALUE && ldt == Integer.MAX_VALUE ? LIVE : new DeletionTime(mfda, ldt);
        }

        @Override
        public void skip(DataInputPlus in) throws IOException {
            in.skipBytesFully(12);
        }

        @Override
        public long serializedSize(DeletionTime delTime) {
            return TypeSizes.sizeof(delTime.localDeletionTime()) + TypeSizes.sizeof(delTime.markedForDeleteAt());
        }
    }
}

