/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.compaction;

import java.util.Set;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.Directories;
import org.apache.cassandra.db.compaction.AbstractCompactionTask;
import org.apache.cassandra.db.compaction.ActiveCompactionsTracker;
import org.apache.cassandra.db.compaction.writers.CompactionAwareWriter;
import org.apache.cassandra.db.lifecycle.LifecycleTransaction;
import org.apache.cassandra.io.sstable.Component;
import org.apache.cassandra.io.sstable.CorruptSSTableException;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.io.sstable.metadata.StatsMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingleSSTableLCSTask
extends AbstractCompactionTask {
    private static final Logger logger = LoggerFactory.getLogger(SingleSSTableLCSTask.class);
    private final int level;

    public SingleSSTableLCSTask(ColumnFamilyStore cfs, LifecycleTransaction txn, int level) {
        super(cfs, txn);
        assert (txn.originals().size() == 1);
        this.level = level;
    }

    @Override
    public CompactionAwareWriter getCompactionAwareWriter(ColumnFamilyStore cfs, Directories directories, LifecycleTransaction txn, Set<SSTableReader> nonExpiredSSTables) {
        throw new UnsupportedOperationException("This method should never be called on SingleSSTableLCSTask");
    }

    @Override
    protected int executeInternal(ActiveCompactionsTracker activeCompactions) {
        this.run();
        return 1;
    }

    @Override
    protected void runMayThrow() {
        SSTableReader sstable = this.transaction.onlyOne();
        StatsMetadata metadataBefore = sstable.getSSTableMetadata();
        if (this.level == metadataBefore.sstableLevel) {
            logger.info("Not compacting {}, level is already {}", (Object)sstable, (Object)this.level);
        } else {
            try {
                logger.info("Changing level on {} from {} to {}", new Object[]{sstable, metadataBefore.sstableLevel, this.level});
                sstable.descriptor.getMetadataSerializer().mutateLevel(sstable.descriptor, this.level);
                sstable.reloadSSTableMetadata();
            }
            catch (Throwable t) {
                this.transaction.abort();
                throw new CorruptSSTableException(t, sstable.descriptor.filenameFor(Component.DATA));
            }
            this.cfs.getTracker().notifySSTableMetadataChanged(sstable, metadataBefore);
        }
        this.finishTransaction(sstable);
    }

    private void finishTransaction(SSTableReader sstable) {
        this.transaction.cancel(sstable);
        this.transaction.prepareToCommit();
        this.transaction.commit();
    }
}

