/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.lifecycle;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.db.lifecycle.LogRecord;
import org.apache.cassandra.db.lifecycle.LogTransaction;
import org.apache.cassandra.io.FSError;
import org.apache.cassandra.io.FSReadError;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.utils.NativeLibrary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class LogReplica
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(LogReplica.class);
    private final File file;
    private int directoryDescriptor;
    private final Map<String, String> errors = new HashMap<String, String>();

    static LogReplica create(File directory, String fileName) {
        int folderFD = NativeLibrary.tryOpenDirectory(directory.getPath());
        if (folderFD == -1) {
            throw new FSReadError((Throwable)new IOException(String.format("Invalid folder descriptor trying to create log replica %s", directory.getPath())), directory.getPath());
        }
        return new LogReplica(new File(fileName), folderFD);
    }

    static LogReplica open(File file) {
        int folderFD = NativeLibrary.tryOpenDirectory(file.getParentFile().getPath());
        if (folderFD == -1) {
            throw new FSReadError((Throwable)new IOException(String.format("Invalid folder descriptor trying to create log replica %s", file.getParentFile().getPath())), file.getParentFile().getPath());
        }
        return new LogReplica(file, folderFD);
    }

    LogReplica(File file, int directoryDescriptor) {
        this.file = file;
        this.directoryDescriptor = directoryDescriptor;
    }

    File file() {
        return this.file;
    }

    List<String> readLines() {
        return FileUtils.readLines(this.file);
    }

    String getFileName() {
        return this.file.getName();
    }

    String getDirectory() {
        return this.file.getParent();
    }

    void append(LogRecord record) {
        boolean existed = this.exists();
        try {
            FileUtils.appendAndSync(this.file, record.toString());
        }
        catch (FSError e) {
            logger.error("Failed to sync file {}", (Object)this.file, (Object)e);
            FileUtils.handleFSErrorAndPropagate(e);
        }
        if (!existed) {
            this.syncDirectory();
        }
    }

    void syncDirectory() {
        try {
            if (this.directoryDescriptor >= 0) {
                NativeLibrary.trySync(this.directoryDescriptor);
            }
        }
        catch (FSError e) {
            logger.error("Failed to sync directory descriptor {}", (Object)this.directoryDescriptor, (Object)e);
            FileUtils.handleFSErrorAndPropagate(e);
        }
    }

    void delete() {
        LogTransaction.delete(this.file);
        this.syncDirectory();
    }

    boolean exists() {
        return this.file.exists();
    }

    @Override
    public void close() {
        if (this.directoryDescriptor >= 0) {
            NativeLibrary.tryCloseFD(this.directoryDescriptor);
            this.directoryDescriptor = -1;
        }
    }

    public String toString() {
        return String.format("[%s] ", this.file);
    }

    void setError(String line, String error) {
        this.errors.put(line, error);
    }

    void printContentsWithAnyErrors(StringBuilder str) {
        str.append(this.file.getPath());
        str.append(System.lineSeparator());
        FileUtils.readLines(this.file).forEach(line -> this.printLineWithAnyError(str, (String)line));
    }

    private void printLineWithAnyError(StringBuilder str, String line) {
        str.append('\t');
        str.append(line);
        str.append(System.lineSeparator());
        String error = this.errors.get(line);
        if (error != null) {
            str.append("\t\t***");
            str.append(error);
            str.append(System.lineSeparator());
        }
    }
}

