/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.marshal;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.cassandra.db.marshal.AbstractCompositeType;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.TypeParser;
import org.apache.cassandra.db.marshal.UserType;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.exceptions.SyntaxException;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.utils.ByteBufferUtil;

public class CompositeType
extends AbstractCompositeType {
    private static final int STATIC_MARKER = 65535;
    public final List<AbstractType<?>> types;
    private static final ConcurrentMap<List<AbstractType<?>>, CompositeType> instances = new ConcurrentHashMap();

    public static CompositeType getInstance(TypeParser parser) throws ConfigurationException, SyntaxException {
        return CompositeType.getInstance(parser.getTypeParameters());
    }

    public static CompositeType getInstance(Iterable<AbstractType<?>> types) {
        return CompositeType.getInstance(Lists.newArrayList(types));
    }

    public static CompositeType getInstance(AbstractType ... types) {
        return CompositeType.getInstance(Arrays.asList(types));
    }

    @Override
    protected boolean readIsStatic(ByteBuffer bb) {
        return CompositeType.readStatic(bb);
    }

    private static boolean readStatic(ByteBuffer bb) {
        if (bb.remaining() < 2) {
            return false;
        }
        int header = ByteBufferUtil.getShortLength(bb, bb.position());
        if ((header & 0xFFFF) != 65535) {
            return false;
        }
        ByteBufferUtil.readShortLength(bb);
        return true;
    }

    public static CompositeType getInstance(List<AbstractType<?>> types) {
        assert (types != null && !types.isEmpty());
        CompositeType t = (CompositeType)instances.get(types);
        return null == t ? instances.computeIfAbsent(types, CompositeType::new) : t;
    }

    protected CompositeType(List<AbstractType<?>> types) {
        this.types = ImmutableList.copyOf(types);
    }

    @Override
    protected AbstractType<?> getComparator(int i, ByteBuffer bb) {
        try {
            return this.types.get(i);
        }
        catch (IndexOutOfBoundsException e) {
            throw new RuntimeException("Cannot get comparator " + i + " in " + this + ". This might due to a mismatch between the schema and the data read", e);
        }
    }

    @Override
    protected AbstractType<?> getComparator(int i, ByteBuffer bb1, ByteBuffer bb2) {
        return this.getComparator(i, bb1);
    }

    @Override
    protected AbstractType<?> getAndAppendComparator(int i, ByteBuffer bb, StringBuilder sb) {
        return this.types.get(i);
    }

    @Override
    protected AbstractCompositeType.ParsedComparator parseComparator(int i, String part) {
        return new StaticParsedComparator(this.types.get(i), part);
    }

    @Override
    protected AbstractType<?> validateComparator(int i, ByteBuffer bb) throws MarshalException {
        if (i >= this.types.size()) {
            throw new MarshalException("Too many bytes for comparator");
        }
        return this.types.get(i);
    }

    @Override
    public ByteBuffer decompose(Object ... objects) {
        assert (objects.length == this.types.size());
        ByteBuffer[] serialized = new ByteBuffer[objects.length];
        for (int i = 0; i < objects.length; ++i) {
            ByteBuffer buffer;
            serialized[i] = buffer = this.types.get(i).decompose(objects[i]);
        }
        return CompositeType.build(serialized);
    }

    @Override
    public ByteBuffer[] split(ByteBuffer name) {
        ByteBuffer[] l = new ByteBuffer[this.types.size()];
        ByteBuffer bb = name.duplicate();
        CompositeType.readStatic(bb);
        int i = 0;
        while (bb.remaining() > 0) {
            l[i++] = ByteBufferUtil.readBytesWithShortLength(bb);
            bb.get();
        }
        return i == l.length ? l : Arrays.copyOfRange(l, 0, i);
    }

    public static List<ByteBuffer> splitName(ByteBuffer name) {
        ArrayList<ByteBuffer> l = new ArrayList<ByteBuffer>();
        ByteBuffer bb = name.duplicate();
        CompositeType.readStatic(bb);
        while (bb.remaining() > 0) {
            l.add(ByteBufferUtil.readBytesWithShortLength(bb));
            bb.get();
        }
        return l;
    }

    public static ByteBuffer extractComponent(ByteBuffer bb, int idx) {
        bb = bb.duplicate();
        CompositeType.readStatic(bb);
        int i = 0;
        while (bb.remaining() > 0) {
            ByteBuffer c = ByteBufferUtil.readBytesWithShortLength(bb);
            if (i == idx) {
                return c;
            }
            bb.get();
            ++i;
        }
        return null;
    }

    public static boolean isStaticName(ByteBuffer bb) {
        return bb.remaining() >= 2 && (ByteBufferUtil.getShortLength(bb, bb.position()) & 0xFFFF) == 65535;
    }

    @Override
    public int componentsCount() {
        return this.types.size();
    }

    @Override
    public List<AbstractType<?>> getComponents() {
        return this.types;
    }

    @Override
    public boolean isCompatibleWith(AbstractType<?> previous) {
        if (this == previous) {
            return true;
        }
        if (!(previous instanceof CompositeType)) {
            return false;
        }
        CompositeType cp = (CompositeType)previous;
        if (this.types.size() < cp.types.size()) {
            return false;
        }
        for (int i = 0; i < cp.types.size(); ++i) {
            AbstractType<?> tprev = cp.types.get(i);
            AbstractType<?> tnew = this.types.get(i);
            if (tnew.isCompatibleWith(tprev)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isValueCompatibleWithInternal(AbstractType<?> otherType) {
        if (this == otherType) {
            return true;
        }
        if (!(otherType instanceof CompositeType)) {
            return false;
        }
        CompositeType cp = (CompositeType)otherType;
        if (this.types.size() < cp.types.size()) {
            return false;
        }
        for (int i = 0; i < cp.types.size(); ++i) {
            AbstractType<?> tprev = cp.types.get(i);
            AbstractType<?> tnew = this.types.get(i);
            if (tnew.isValueCompatibleWith(tprev)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean referencesUserType(ByteBuffer name) {
        return Iterables.any(this.types, t -> t.referencesUserType(name));
    }

    public CompositeType withUpdatedUserType(UserType udt) {
        if (!this.referencesUserType(udt.name)) {
            return this;
        }
        instances.remove(this.types);
        return CompositeType.getInstance(Iterables.transform(this.types, t -> t.withUpdatedUserType(udt)));
    }

    @Override
    public AbstractType<?> expandUserTypes() {
        return CompositeType.getInstance(Iterables.transform(this.types, AbstractType::expandUserTypes));
    }

    @Override
    public String toString() {
        return this.getClass().getName() + TypeParser.stringifyTypeParameters(this.types);
    }

    public static ByteBuffer build(ByteBuffer ... buffers) {
        return CompositeType.build(false, buffers);
    }

    public static ByteBuffer build(boolean isStatic, ByteBuffer ... buffers) {
        int totalLength = isStatic ? 2 : 0;
        for (ByteBuffer bb : buffers) {
            totalLength += 2 + bb.remaining() + 1;
        }
        ByteBuffer out = ByteBuffer.allocate(totalLength);
        if (isStatic) {
            out.putShort((short)-1);
        }
        for (ByteBuffer bb : buffers) {
            ByteBufferUtil.writeShortLength(out, bb.remaining());
            int toCopy = bb.remaining();
            ByteBufferUtil.copyBytes(bb, bb.position(), out, out.position(), toCopy);
            out.position(out.position() + toCopy);
            out.put((byte)0);
        }
        out.flip();
        return out;
    }

    private static class StaticParsedComparator
    implements AbstractCompositeType.ParsedComparator {
        final AbstractType<?> type;
        final String part;

        StaticParsedComparator(AbstractType<?> type, String part) {
            this.type = type;
            this.part = part;
        }

        @Override
        public AbstractType<?> getAbstractType() {
            return this.type;
        }

        @Override
        public String getRemainingPart() {
            return this.part;
        }

        @Override
        public int getComparatorSerializedSize() {
            return 0;
        }

        @Override
        public void serializeComparator(ByteBuffer bb) {
        }
    }
}

