/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.streaming;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.compaction.AbstractCompactionStrategy;
import org.apache.cassandra.db.compaction.LeveledCompactionStrategy;
import org.apache.cassandra.db.compaction.Verifier;
import org.apache.cassandra.db.streaming.CassandraCompressedStreamWriter;
import org.apache.cassandra.db.streaming.CassandraEntireSSTableStreamWriter;
import org.apache.cassandra.db.streaming.CassandraStreamHeader;
import org.apache.cassandra.db.streaming.CassandraStreamWriter;
import org.apache.cassandra.db.streaming.ComponentManifest;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.io.sstable.Component;
import org.apache.cassandra.io.sstable.KeyIterator;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.io.util.DataOutputStreamPlus;
import org.apache.cassandra.net.AsyncStreamingOutputPlus;
import org.apache.cassandra.schema.TableId;
import org.apache.cassandra.streaming.OutgoingStream;
import org.apache.cassandra.streaming.StreamOperation;
import org.apache.cassandra.streaming.StreamSession;
import org.apache.cassandra.utils.concurrent.Ref;

public class CassandraOutgoingFile
implements OutgoingStream {
    public static final List<Component> STREAM_COMPONENTS = ImmutableList.of((Object)Component.DATA, (Object)Component.PRIMARY_INDEX, (Object)Component.STATS, (Object)Component.COMPRESSION_INFO, (Object)Component.FILTER, (Object)Component.SUMMARY, (Object)Component.DIGEST, (Object)Component.CRC);
    private final Ref<SSTableReader> ref;
    private final long estimatedKeys;
    private final List<SSTableReader.PartitionPositionBounds> sections;
    private final String filename;
    private final CassandraStreamHeader header;
    private final boolean keepSSTableLevel;
    private final ComponentManifest manifest;
    private Boolean isFullyContained;
    private final List<Range<Token>> normalizedRanges;

    public CassandraOutgoingFile(StreamOperation operation, Ref<SSTableReader> ref, List<SSTableReader.PartitionPositionBounds> sections, List<Range<Token>> normalizedRanges, long estimatedKeys) {
        Preconditions.checkNotNull((Object)ref.get());
        Range.assertNormalized(normalizedRanges);
        this.ref = ref;
        this.estimatedKeys = estimatedKeys;
        this.sections = sections;
        this.normalizedRanges = ImmutableList.copyOf(normalizedRanges);
        this.filename = ref.get().getFilename();
        this.manifest = CassandraOutgoingFile.getComponentManifest(ref.get());
        SSTableReader sstable = ref.get();
        this.keepSSTableLevel = operation == StreamOperation.BOOTSTRAP || operation == StreamOperation.REBUILD;
        this.header = CassandraStreamHeader.builder().withSSTableFormat(sstable.descriptor.formatType).withSSTableVersion(sstable.descriptor.version).withSSTableLevel(this.keepSSTableLevel ? sstable.getSSTableLevel() : 0).withEstimatedKeys(estimatedKeys).withSections(sections).withCompressionMetadata(sstable.compression ? sstable.getCompressionMetadata() : null).withSerializationHeader(sstable.header.toComponent()).isEntireSSTable(this.shouldStreamEntireSSTable()).withComponentManifest(this.manifest).withFirstKey(sstable.first).withTableId(sstable.metadata().id).build();
    }

    @VisibleForTesting
    public static ComponentManifest getComponentManifest(SSTableReader sstable) {
        LinkedHashMap<Component, Long> components = new LinkedHashMap<Component, Long>(STREAM_COMPONENTS.size());
        for (Component component : STREAM_COMPONENTS) {
            File file = new File(sstable.descriptor.filenameFor(component));
            if (!file.exists()) continue;
            components.put(component, file.length());
        }
        return new ComponentManifest(components);
    }

    public static CassandraOutgoingFile fromStream(OutgoingStream stream) {
        Preconditions.checkArgument((boolean)(stream instanceof CassandraOutgoingFile));
        return (CassandraOutgoingFile)stream;
    }

    @VisibleForTesting
    public Ref<SSTableReader> getRef() {
        return this.ref;
    }

    @Override
    public String getName() {
        return this.filename;
    }

    @Override
    public long getSize() {
        return this.header.size();
    }

    @Override
    public TableId getTableId() {
        return this.ref.get().metadata().id;
    }

    @Override
    public long getRepairedAt() {
        return this.ref.get().getRepairedAt();
    }

    @Override
    public UUID getPendingRepair() {
        return this.ref.get().getPendingRepair();
    }

    @Override
    public void write(StreamSession session, DataOutputStreamPlus out, int version) throws IOException {
        SSTableReader sstable = this.ref.get();
        CassandraStreamHeader.serializer.serialize(this.header, out, version);
        out.flush();
        if (this.shouldStreamEntireSSTable() && out instanceof AsyncStreamingOutputPlus) {
            CassandraEntireSSTableStreamWriter writer = new CassandraEntireSSTableStreamWriter(sstable, session, this.manifest);
            writer.write((AsyncStreamingOutputPlus)out);
        } else {
            CassandraStreamWriter writer = this.header.compressionInfo == null ? new CassandraStreamWriter(sstable, this.header.sections, session) : new CassandraCompressedStreamWriter(sstable, this.header.sections, this.header.compressionInfo, session);
            writer.write(out);
        }
    }

    @VisibleForTesting
    public boolean shouldStreamEntireSSTable() {
        if (!DatabaseDescriptor.streamEntireSSTables() || this.ref.get().getSSTableMetadata().hasLegacyCounterShards) {
            return false;
        }
        ColumnFamilyStore cfs = ColumnFamilyStore.getIfExists(this.getTableId());
        if (cfs == null) {
            return false;
        }
        AbstractCompactionStrategy compactionStrategy = cfs.getCompactionStrategyManager().getCompactionStrategyFor(this.ref.get());
        if (compactionStrategy instanceof LeveledCompactionStrategy) {
            return this.contained(this.normalizedRanges, this.ref.get());
        }
        return false;
    }

    @VisibleForTesting
    public boolean contained(List<Range<Token>> normalizedRanges, SSTableReader sstable) {
        if (this.isFullyContained != null) {
            return this.isFullyContained;
        }
        this.isFullyContained = this.computeContainment(normalizedRanges, sstable);
        return this.isFullyContained;
    }

    private boolean computeContainment(List<Range<Token>> normalizedRanges, SSTableReader sstable) {
        if (normalizedRanges == null) {
            return false;
        }
        Verifier.RangeOwnHelper rangeOwnHelper = new Verifier.RangeOwnHelper(normalizedRanges);
        try (KeyIterator iter = new KeyIterator(sstable.descriptor, sstable.metadata());){
            while (iter.hasNext()) {
                DecoratedKey key = (DecoratedKey)iter.next();
                if (rangeOwnHelper.check(key)) continue;
                boolean bl = false;
                return bl;
            }
        }
        return true;
    }

    @Override
    public void finish() {
        this.ref.release();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CassandraOutgoingFile that = (CassandraOutgoingFile)o;
        return this.estimatedKeys == that.estimatedKeys && Objects.equals(this.ref, that.ref) && Objects.equals(this.sections, that.sections);
    }

    public int hashCode() {
        return Objects.hash(this.ref, this.estimatedKeys, this.sections);
    }

    public String toString() {
        return "CassandraOutgoingFile{" + this.filename + '}';
    }
}

