/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.hints;

import java.io.Serializable;
import java.util.HashMap;
import java.util.UUID;
import javax.annotation.Nullable;
import org.apache.cassandra.diag.DiagnosticEvent;
import org.apache.cassandra.hints.HintsDispatcher;
import org.apache.cassandra.locator.InetAddressAndPort;

final class HintEvent
extends DiagnosticEvent {
    private final HintEventType type;
    private final HintsDispatcher dispatcher;
    private final UUID targetHostId;
    private final InetAddressAndPort targetAddress;
    @Nullable
    private final HintResult dispatchResult;
    @Nullable
    private final Long pageHintsSuccessful;
    @Nullable
    private final Long pageHintsFailed;
    @Nullable
    private final Long pageHintsTimeout;

    HintEvent(HintEventType type, HintsDispatcher dispatcher, UUID targetHostId, InetAddressAndPort targetAddress, @Nullable HintResult dispatchResult, @Nullable Long pageHintsSuccessful, @Nullable Long pageHintsFailed, @Nullable Long pageHintsTimeout) {
        this.type = type;
        this.dispatcher = dispatcher;
        this.targetHostId = targetHostId;
        this.targetAddress = targetAddress;
        this.dispatchResult = dispatchResult;
        this.pageHintsSuccessful = pageHintsSuccessful;
        this.pageHintsFailed = pageHintsFailed;
        this.pageHintsTimeout = pageHintsTimeout;
    }

    public Enum<HintEventType> getType() {
        return this.type;
    }

    public HashMap<String, Serializable> toMap() {
        HashMap<String, Serializable> ret = new HashMap<String, Serializable>();
        ret.put("targetHostId", this.targetHostId);
        ret.put("targetAddress", (Serializable)((Object)this.targetAddress.getHostAddress(true)));
        if (this.dispatchResult != null) {
            ret.put("dispatchResult", (Serializable)((Object)this.dispatchResult.name()));
        }
        if (this.pageHintsSuccessful != null || this.pageHintsFailed != null || this.pageHintsTimeout != null) {
            ret.put("hint.page.hints_succeeded", this.pageHintsSuccessful);
            ret.put("hint.page.hints_failed", this.pageHintsFailed);
            ret.put("hint.page.hints_timed_out", this.pageHintsTimeout);
        }
        return ret;
    }

    static enum HintResult {
        PAGE_SUCCESS,
        PAGE_FAILURE;

    }

    static enum HintEventType {
        DISPATCHING_STARTED,
        DISPATCHING_PAUSED,
        DISPATCHING_RESUMED,
        DISPATCHING_SHUTDOWN,
        DISPATCHER_CREATED,
        DISPATCHER_CLOSED,
        DISPATCHER_PAGE,
        DISPATCHER_HINT_RESULT,
        ABORT_REQUESTED;

    }
}

