/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.locator;

import com.google.common.annotations.VisibleForTesting;
import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Set;
import org.apache.cassandra.db.SystemKeyspace;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.gms.ApplicationState;
import org.apache.cassandra.gms.EndpointState;
import org.apache.cassandra.gms.Gossiper;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.locator.AbstractNetworkTopologySnitch;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.locator.SnitchProperties;
import org.apache.cassandra.utils.FBUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Ec2Snitch
extends AbstractNetworkTopologySnitch {
    protected static final Logger logger = LoggerFactory.getLogger(Ec2Snitch.class);
    private static final String SNITCH_PROP_NAMING_SCHEME = "ec2_naming_scheme";
    static final String EC2_NAMING_LEGACY = "legacy";
    private static final String EC2_NAMING_STANDARD = "standard";
    private static final String ZONE_NAME_QUERY_URL = "http://169.254.169.254/latest/meta-data/placement/availability-zone";
    private static final String DEFAULT_DC = "UNKNOWN-DC";
    private static final String DEFAULT_RACK = "UNKNOWN-RACK";
    final String ec2region;
    private final String ec2zone;
    private final boolean usingLegacyNaming;
    private Map<InetAddressAndPort, Map<String, String>> savedEndpoints;

    public Ec2Snitch() throws IOException, ConfigurationException {
        this(new SnitchProperties());
    }

    public Ec2Snitch(SnitchProperties props) throws IOException, ConfigurationException {
        String region;
        String az = this.awsApiCall(ZONE_NAME_QUERY_URL);
        this.usingLegacyNaming = Ec2Snitch.isUsingLegacyNaming(props);
        if (this.usingLegacyNaming) {
            String[] splits = az.split("-");
            this.ec2zone = splits[splits.length - 1];
            region = az.substring(0, az.length() - 1);
            if (region.endsWith("1")) {
                region = az.substring(0, az.length() - 3);
            }
        } else {
            region = az.replaceFirst("[a-z]+$", "");
            this.ec2zone = az;
        }
        String datacenterSuffix = props.get("dc_suffix", "");
        this.ec2region = region.concat(datacenterSuffix);
        logger.info("EC2Snitch using region: {}, zone: {}.", (Object)this.ec2region, (Object)this.ec2zone);
    }

    private static boolean isUsingLegacyNaming(SnitchProperties props) {
        return props.get(SNITCH_PROP_NAMING_SCHEME, EC2_NAMING_STANDARD).equalsIgnoreCase(EC2_NAMING_LEGACY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String awsApiCall(String url) throws IOException, ConfigurationException {
        String string;
        HttpURLConnection conn = (HttpURLConnection)new URL(url).openConnection();
        DataInputStream d = null;
        try {
            conn.setRequestMethod("GET");
            if (conn.getResponseCode() != 200) {
                throw new ConfigurationException("Ec2Snitch was unable to execute the API call. Not an ec2 node?");
            }
            int cl = conn.getContentLength();
            byte[] b = new byte[cl];
            d = new DataInputStream((FilterInputStream)conn.getContent());
            d.readFully(b);
            string = new String(b, StandardCharsets.UTF_8);
        }
        catch (Throwable throwable) {
            FileUtils.close(d);
            conn.disconnect();
            throw throwable;
        }
        FileUtils.close(d);
        conn.disconnect();
        return string;
    }

    @Override
    public String getRack(InetAddressAndPort endpoint) {
        if (endpoint.equals(FBUtilities.getBroadcastAddressAndPort())) {
            return this.ec2zone;
        }
        EndpointState state = Gossiper.instance.getEndpointStateForEndpoint(endpoint);
        if (state == null || state.getApplicationState(ApplicationState.RACK) == null) {
            if (this.savedEndpoints == null) {
                this.savedEndpoints = SystemKeyspace.loadDcRackInfo();
            }
            if (this.savedEndpoints.containsKey(endpoint)) {
                return this.savedEndpoints.get(endpoint).get("rack");
            }
            return DEFAULT_RACK;
        }
        return state.getApplicationState((ApplicationState)ApplicationState.RACK).value;
    }

    @Override
    public String getDatacenter(InetAddressAndPort endpoint) {
        if (endpoint.equals(FBUtilities.getBroadcastAddressAndPort())) {
            return this.ec2region;
        }
        EndpointState state = Gossiper.instance.getEndpointStateForEndpoint(endpoint);
        if (state == null || state.getApplicationState(ApplicationState.DC) == null) {
            if (this.savedEndpoints == null) {
                this.savedEndpoints = SystemKeyspace.loadDcRackInfo();
            }
            if (this.savedEndpoints.containsKey(endpoint)) {
                return this.savedEndpoints.get(endpoint).get("data_center");
            }
            return DEFAULT_DC;
        }
        return state.getApplicationState((ApplicationState)ApplicationState.DC).value;
    }

    @Override
    public boolean validate(Set<String> datacenters, Set<String> racks) {
        return Ec2Snitch.validate(datacenters, racks, this.usingLegacyNaming);
    }

    @VisibleForTesting
    static boolean validate(Set<String> datacenters, Set<String> racks, boolean usingLegacyNaming) {
        boolean valid = true;
        for (String dc : datacenters) {
            boolean dcUsesLegacyFormat = !dc.matches("[a-z]+-[a-z].+-[\\d].*");
            if (dcUsesLegacyFormat == usingLegacyNaming) continue;
            valid = false;
        }
        for (String rack : racks) {
            boolean rackUsesLegacyFormat = rack.matches("[\\d][a-z]");
            if (rackUsesLegacyFormat == usingLegacyNaming) continue;
            valid = false;
        }
        if (!valid) {
            logger.error("This ec2-enabled snitch appears to be using the {} naming scheme for regions, but existing nodes in cluster are using the opposite: region(s) = {}, availability zone(s) = {}. Please check the {} property in the {} configuration file for more details.", new Object[]{usingLegacyNaming ? EC2_NAMING_LEGACY : EC2_NAMING_STANDARD, datacenters, racks, SNITCH_PROP_NAMING_SCHEME, "cassandra-rackdc.properties"});
        }
        return valid;
    }
}

