/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.net;

import java.io.IOException;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.config.EncryptionOptions;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.metrics.InternodeOutboundMetrics;
import org.apache.cassandra.metrics.MessagingMetrics;
import org.apache.cassandra.net.EndpointMessagingVersions;
import org.apache.cassandra.net.InboundMessageHandlers;
import org.apache.cassandra.net.MessagingServiceMBean;
import org.apache.cassandra.net.OutboundConnections;
import org.apache.cassandra.security.SSLFactory;
import org.apache.cassandra.utils.MBeanWrapper;

public class MessagingServiceMBeanImpl
implements MessagingServiceMBean {
    public static final String MBEAN_NAME = "org.apache.cassandra.net:type=MessagingService";
    public final ConcurrentMap<InetAddressAndPort, OutboundConnections> channelManagers = new ConcurrentHashMap<InetAddressAndPort, OutboundConnections>();
    public final ConcurrentMap<InetAddressAndPort, InboundMessageHandlers> messageHandlers = new ConcurrentHashMap<InetAddressAndPort, InboundMessageHandlers>();
    public final EndpointMessagingVersions versions = new EndpointMessagingVersions();
    public final MessagingMetrics metrics = new MessagingMetrics();

    MessagingServiceMBeanImpl(boolean testOnly) {
        if (!testOnly) {
            MBeanWrapper.instance.registerMBean((Object)this, MBEAN_NAME);
            this.metrics.scheduleLogging();
        }
    }

    @Override
    public Map<String, Integer> getLargeMessagePendingTasks() {
        HashMap<String, Integer> pendingTasks = new HashMap<String, Integer>(this.channelManagers.size());
        for (Map.Entry entry : this.channelManagers.entrySet()) {
            pendingTasks.put(((InetAddressAndPort)entry.getKey()).toString(false), ((OutboundConnections)entry.getValue()).large.pendingCount());
        }
        return pendingTasks;
    }

    @Override
    public Map<String, Long> getLargeMessageCompletedTasks() {
        HashMap<String, Long> completedTasks = new HashMap<String, Long>(this.channelManagers.size());
        for (Map.Entry entry : this.channelManagers.entrySet()) {
            completedTasks.put(((InetAddressAndPort)entry.getKey()).toString(false), ((OutboundConnections)entry.getValue()).large.sentCount());
        }
        return completedTasks;
    }

    @Override
    public Map<String, Long> getLargeMessageDroppedTasks() {
        HashMap<String, Long> droppedTasks = new HashMap<String, Long>(this.channelManagers.size());
        for (Map.Entry entry : this.channelManagers.entrySet()) {
            droppedTasks.put(((InetAddressAndPort)entry.getKey()).toString(false), ((OutboundConnections)entry.getValue()).large.dropped());
        }
        return droppedTasks;
    }

    @Override
    public Map<String, Integer> getSmallMessagePendingTasks() {
        HashMap<String, Integer> pendingTasks = new HashMap<String, Integer>(this.channelManagers.size());
        for (Map.Entry entry : this.channelManagers.entrySet()) {
            pendingTasks.put(((InetAddressAndPort)entry.getKey()).toString(false), ((OutboundConnections)entry.getValue()).small.pendingCount());
        }
        return pendingTasks;
    }

    @Override
    public Map<String, Long> getSmallMessageCompletedTasks() {
        HashMap<String, Long> completedTasks = new HashMap<String, Long>(this.channelManagers.size());
        for (Map.Entry entry : this.channelManagers.entrySet()) {
            completedTasks.put(((InetAddressAndPort)entry.getKey()).toString(false), ((OutboundConnections)entry.getValue()).small.sentCount());
        }
        return completedTasks;
    }

    @Override
    public Map<String, Long> getSmallMessageDroppedTasks() {
        HashMap<String, Long> droppedTasks = new HashMap<String, Long>(this.channelManagers.size());
        for (Map.Entry entry : this.channelManagers.entrySet()) {
            droppedTasks.put(((InetAddressAndPort)entry.getKey()).toString(false), ((OutboundConnections)entry.getValue()).small.dropped());
        }
        return droppedTasks;
    }

    @Override
    public Map<String, Integer> getGossipMessagePendingTasks() {
        HashMap<String, Integer> pendingTasks = new HashMap<String, Integer>(this.channelManagers.size());
        for (Map.Entry entry : this.channelManagers.entrySet()) {
            pendingTasks.put(((InetAddressAndPort)entry.getKey()).toString(false), ((OutboundConnections)entry.getValue()).urgent.pendingCount());
        }
        return pendingTasks;
    }

    @Override
    public Map<String, Long> getGossipMessageCompletedTasks() {
        HashMap<String, Long> completedTasks = new HashMap<String, Long>(this.channelManagers.size());
        for (Map.Entry entry : this.channelManagers.entrySet()) {
            completedTasks.put(((InetAddressAndPort)entry.getKey()).toString(false), ((OutboundConnections)entry.getValue()).urgent.sentCount());
        }
        return completedTasks;
    }

    @Override
    public Map<String, Long> getGossipMessageDroppedTasks() {
        HashMap<String, Long> droppedTasks = new HashMap<String, Long>(this.channelManagers.size());
        for (Map.Entry entry : this.channelManagers.entrySet()) {
            droppedTasks.put(((InetAddressAndPort)entry.getKey()).toString(false), ((OutboundConnections)entry.getValue()).urgent.dropped());
        }
        return droppedTasks;
    }

    @Override
    public Map<String, Integer> getLargeMessagePendingTasksWithPort() {
        HashMap<String, Integer> pendingTasks = new HashMap<String, Integer>(this.channelManagers.size());
        for (Map.Entry entry : this.channelManagers.entrySet()) {
            pendingTasks.put(((InetAddressAndPort)entry.getKey()).toString(), ((OutboundConnections)entry.getValue()).large.pendingCount());
        }
        return pendingTasks;
    }

    @Override
    public Map<String, Long> getLargeMessageCompletedTasksWithPort() {
        HashMap<String, Long> completedTasks = new HashMap<String, Long>(this.channelManagers.size());
        for (Map.Entry entry : this.channelManagers.entrySet()) {
            completedTasks.put(((InetAddressAndPort)entry.getKey()).toString(), ((OutboundConnections)entry.getValue()).large.sentCount());
        }
        return completedTasks;
    }

    @Override
    public Map<String, Long> getLargeMessageDroppedTasksWithPort() {
        HashMap<String, Long> droppedTasks = new HashMap<String, Long>(this.channelManagers.size());
        for (Map.Entry entry : this.channelManagers.entrySet()) {
            droppedTasks.put(((InetAddressAndPort)entry.getKey()).toString(), ((OutboundConnections)entry.getValue()).large.dropped());
        }
        return droppedTasks;
    }

    @Override
    public Map<String, Integer> getSmallMessagePendingTasksWithPort() {
        HashMap<String, Integer> pendingTasks = new HashMap<String, Integer>(this.channelManagers.size());
        for (Map.Entry entry : this.channelManagers.entrySet()) {
            pendingTasks.put(((InetAddressAndPort)entry.getKey()).toString(), ((OutboundConnections)entry.getValue()).small.pendingCount());
        }
        return pendingTasks;
    }

    @Override
    public Map<String, Long> getSmallMessageCompletedTasksWithPort() {
        HashMap<String, Long> completedTasks = new HashMap<String, Long>(this.channelManagers.size());
        for (Map.Entry entry : this.channelManagers.entrySet()) {
            completedTasks.put(((InetAddressAndPort)entry.getKey()).toString(), ((OutboundConnections)entry.getValue()).small.sentCount());
        }
        return completedTasks;
    }

    @Override
    public Map<String, Long> getSmallMessageDroppedTasksWithPort() {
        HashMap<String, Long> droppedTasks = new HashMap<String, Long>(this.channelManagers.size());
        for (Map.Entry entry : this.channelManagers.entrySet()) {
            droppedTasks.put(((InetAddressAndPort)entry.getKey()).toString(), ((OutboundConnections)entry.getValue()).small.dropped());
        }
        return droppedTasks;
    }

    @Override
    public Map<String, Integer> getGossipMessagePendingTasksWithPort() {
        HashMap<String, Integer> pendingTasks = new HashMap<String, Integer>(this.channelManagers.size());
        for (Map.Entry entry : this.channelManagers.entrySet()) {
            pendingTasks.put(((InetAddressAndPort)entry.getKey()).toString(), ((OutboundConnections)entry.getValue()).urgent.pendingCount());
        }
        return pendingTasks;
    }

    @Override
    public Map<String, Long> getGossipMessageCompletedTasksWithPort() {
        HashMap<String, Long> completedTasks = new HashMap<String, Long>(this.channelManagers.size());
        for (Map.Entry entry : this.channelManagers.entrySet()) {
            completedTasks.put(((InetAddressAndPort)entry.getKey()).toString(), ((OutboundConnections)entry.getValue()).urgent.sentCount());
        }
        return completedTasks;
    }

    @Override
    public Map<String, Long> getGossipMessageDroppedTasksWithPort() {
        HashMap<String, Long> droppedTasks = new HashMap<String, Long>(this.channelManagers.size());
        for (Map.Entry entry : this.channelManagers.entrySet()) {
            droppedTasks.put(((InetAddressAndPort)entry.getKey()).toString(), ((OutboundConnections)entry.getValue()).urgent.dropped());
        }
        return droppedTasks;
    }

    @Override
    public Map<String, Integer> getDroppedMessages() {
        return this.metrics.getDroppedMessages();
    }

    @Override
    public long getTotalTimeouts() {
        return InternodeOutboundMetrics.totalExpiredCallbacks.getCount();
    }

    @Override
    public Map<String, Long> getTimeoutsPerHost() {
        HashMap<String, Long> result = new HashMap<String, Long>(this.channelManagers.size());
        for (Map.Entry entry : this.channelManagers.entrySet()) {
            String ip = ((InetAddressAndPort)entry.getKey()).toString(false);
            long recent = ((OutboundConnections)entry.getValue()).expiredCallbacks();
            result.put(ip, recent);
        }
        return result;
    }

    @Override
    public Map<String, Long> getTimeoutsPerHostWithPort() {
        HashMap<String, Long> result = new HashMap<String, Long>(this.channelManagers.size());
        for (Map.Entry entry : this.channelManagers.entrySet()) {
            String ip = ((InetAddressAndPort)entry.getKey()).toString();
            long recent = ((OutboundConnections)entry.getValue()).expiredCallbacks();
            result.put(ip, recent);
        }
        return result;
    }

    @Override
    public Map<String, Double> getBackPressurePerHost() {
        HashMap<String, Double> map = new HashMap<String, Double>(this.channelManagers.size());
        for (Map.Entry entry : this.channelManagers.entrySet()) {
            map.put(((InetAddressAndPort)entry.getKey()).toString(false), ((OutboundConnections)entry.getValue()).getBackPressureState().getBackPressureRateLimit());
        }
        return map;
    }

    @Override
    public Map<String, Double> getBackPressurePerHostWithPort() {
        HashMap<String, Double> map = new HashMap<String, Double>(this.channelManagers.size());
        for (Map.Entry entry : this.channelManagers.entrySet()) {
            map.put(((InetAddressAndPort)entry.getKey()).toString(false), ((OutboundConnections)entry.getValue()).getBackPressureState().getBackPressureRateLimit());
        }
        return map;
    }

    @Override
    public void setBackPressureEnabled(boolean enabled) {
        DatabaseDescriptor.setBackPressureEnabled(enabled);
    }

    @Override
    public boolean isBackPressureEnabled() {
        return DatabaseDescriptor.backPressureEnabled();
    }

    @Override
    public void reloadSslCertificates() throws IOException {
        EncryptionOptions.ServerEncryptionOptions serverOpts = DatabaseDescriptor.getInternodeMessagingEncyptionOptions();
        EncryptionOptions clientOpts = DatabaseDescriptor.getNativeProtocolEncryptionOptions();
        SSLFactory.validateSslCerts(serverOpts, clientOpts);
        SSLFactory.checkCertFilesForHotReloading(serverOpts, clientOpts);
    }

    @Override
    public int getVersion(String address) throws UnknownHostException {
        return this.versions.get(address);
    }
}

