/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.repair.asymmetric;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.repair.asymmetric.StreamFromOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangeDenormalizer {
    private static final Logger logger = LoggerFactory.getLogger(RangeDenormalizer.class);

    public static Set<Range<Token>> denormalize(Range<Token> range, Map<Range<Token>, StreamFromOptions> incoming) {
        logger.trace("Denormalizing range={} incoming={}", range, incoming);
        HashSet<Range<Token>> existingRanges = new HashSet<Range<Token>>(incoming.keySet());
        HashMap<Range, StreamFromOptions> existingOverlappingRanges = new HashMap<Range, StreamFromOptions>();
        for (Range range2 : existingRanges) {
            if (!range.intersects(range2)) continue;
            existingOverlappingRanges.put(range2, incoming.remove(range2));
        }
        Set<Range<Token>> intersections = RangeDenormalizer.intersection(existingRanges, range);
        Sets.SetView setView = Sets.union(RangeDenormalizer.subtractFromAllRanges(existingOverlappingRanges.keySet(), range), intersections);
        Sets.SetView newInput = Sets.union(range.subtractAll(existingOverlappingRanges.keySet()), intersections);
        RangeDenormalizer.assertNonOverLapping((Set<Range<Token>>)setView);
        RangeDenormalizer.assertNonOverLapping((Set<Range<Token>>)newInput);
        for (Range r : setView) {
            for (Map.Entry entry : existingOverlappingRanges.entrySet()) {
                if (!r.intersects((Range)entry.getKey())) continue;
                incoming.put(r, ((StreamFromOptions)entry.getValue()).copy(r));
            }
        }
        logger.trace("denormalized {} to {}", range, (Object)newInput);
        logger.trace("denormalized incoming to {}", incoming);
        RangeDenormalizer.assertNonOverLapping(incoming.keySet());
        return newInput;
    }

    @VisibleForTesting
    static Set<Range<Token>> subtractFromAllRanges(Collection<Range<Token>> ranges, Range<Token> range) {
        HashSet<Range<Token>> result = new HashSet<Range<Token>>();
        for (Range<Token> r : ranges) {
            result.addAll(r.subtract(range));
        }
        return result;
    }

    private static void assertNonOverLapping(Set<Range<Token>> ranges) {
        List sortedRanges = Range.sort(ranges);
        Comparable lastToken = null;
        for (Range range : sortedRanges) {
            if (lastToken != null && lastToken.compareTo(range.left) > 0) {
                throw new AssertionError((Object)("Ranges are overlapping: " + ranges));
            }
            lastToken = (Token)range.right;
        }
    }

    private static Set<Range<Token>> intersection(Collection<Range<Token>> ranges, Range<Token> range) {
        HashSet<Range<Token>> result = new HashSet<Range<Token>>();
        for (Range<Token> r : ranges) {
            result.addAll(range.intersectionWith(r));
        }
        return result;
    }
}

