/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.repair.consistent;

import com.google.common.base.Preconditions;
import org.apache.cassandra.repair.consistent.ConsistentSession;
import org.apache.cassandra.utils.FBUtilities;

public class LocalSession
extends ConsistentSession {
    public final int startedAt;
    private volatile int lastUpdate;

    public LocalSession(Builder builder) {
        super(builder);
        this.startedAt = builder.startedAt;
        this.lastUpdate = builder.lastUpdate;
    }

    public boolean isCompleted() {
        ConsistentSession.State s = this.getState();
        return s == ConsistentSession.State.FINALIZED || s == ConsistentSession.State.FAILED;
    }

    public int getStartedAt() {
        return this.startedAt;
    }

    public int getLastUpdate() {
        return this.lastUpdate;
    }

    public void setLastUpdate() {
        this.lastUpdate = FBUtilities.nowInSeconds();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LocalSession session = (LocalSession)o;
        if (this.startedAt != session.startedAt) {
            return false;
        }
        return this.lastUpdate == session.lastUpdate;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.startedAt;
        result = 31 * result + this.lastUpdate;
        return result;
    }

    @Override
    public String toString() {
        return "LocalSession{sessionID=" + this.sessionID + ", state=" + (Object)((Object)this.getState()) + ", coordinator=" + this.coordinator + ", tableIds=" + this.tableIds + ", repairedAt=" + this.repairedAt + ", ranges=" + this.ranges + ", participants=" + this.participants + ", startedAt=" + this.startedAt + ", lastUpdate=" + this.lastUpdate + '}';
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends ConsistentSession.AbstractBuilder {
        private int startedAt;
        private int lastUpdate;

        public void withStartedAt(int startedAt) {
            this.startedAt = startedAt;
        }

        public void withLastUpdate(int lastUpdate) {
            this.lastUpdate = lastUpdate;
        }

        @Override
        void validate() {
            super.validate();
            Preconditions.checkArgument((this.startedAt > 0 ? 1 : 0) != 0);
            Preconditions.checkArgument((this.lastUpdate > 0 ? 1 : 0) != 0);
        }

        public LocalSession build() {
            this.validate();
            return new LocalSession(this);
        }
    }
}

