/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.schema;

import java.util.Collection;
import java.util.EnumSet;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import org.apache.cassandra.db.SystemKeyspace;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.gms.FailureDetector;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.net.NoPayload;
import org.apache.cassandra.net.RequestCallback;
import org.apache.cassandra.net.Verb;
import org.apache.cassandra.schema.MigrationManager;
import org.apache.cassandra.schema.Schema;
import org.apache.cassandra.schema.SchemaMigrationDiagnostics;
import org.apache.cassandra.utils.WrappedRunnable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class MigrationTask
extends WrappedRunnable {
    private static final Logger logger = LoggerFactory.getLogger(MigrationTask.class);
    private static final ConcurrentLinkedQueue<CountDownLatch> inflightTasks = new ConcurrentLinkedQueue();
    private static final Set<SystemKeyspace.BootstrapState> monitoringBootstrapStates = EnumSet.of(SystemKeyspace.BootstrapState.NEEDS_BOOTSTRAP, SystemKeyspace.BootstrapState.IN_PROGRESS);
    private final InetAddressAndPort endpoint;

    MigrationTask(InetAddressAndPort endpoint) {
        this.endpoint = endpoint;
        SchemaMigrationDiagnostics.taskCreated(endpoint);
    }

    static ConcurrentLinkedQueue<CountDownLatch> getInflightTasks() {
        return inflightTasks;
    }

    @Override
    public void runMayThrow() throws Exception {
        if (!FailureDetector.instance.isAlive(this.endpoint)) {
            logger.warn("Can't send schema pull request: node {} is down.", (Object)this.endpoint);
            SchemaMigrationDiagnostics.taskSendAborted(this.endpoint);
            return;
        }
        if (!MigrationManager.shouldPullSchemaFrom(this.endpoint)) {
            logger.info("Skipped sending a migration request: node {} has a higher major version now.", (Object)this.endpoint);
            SchemaMigrationDiagnostics.taskSendAborted(this.endpoint);
            return;
        }
        Message<NoPayload> message = Message.out(Verb.SCHEMA_PULL_REQ, NoPayload.noPayload);
        CountDownLatch completionLatch = new CountDownLatch(1);
        RequestCallback cb = msg -> {
            try {
                Schema.instance.mergeAndAnnounceVersion((Collection)msg.payload);
            }
            catch (ConfigurationException e) {
                logger.error("Configuration exception merging remote schema", (Throwable)e);
            }
            finally {
                completionLatch.countDown();
            }
        };
        if (monitoringBootstrapStates.contains((Object)SystemKeyspace.getBootstrapState())) {
            inflightTasks.offer(completionLatch);
        }
        MessagingService.instance().sendWithCallback(message, this.endpoint, cb);
        SchemaMigrationDiagnostics.taskRequestSend(this.endpoint);
    }
}

