/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service;

import com.google.common.base.Preconditions;
import com.google.common.cache.CacheLoader;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.PeekingIterator;
import com.google.common.primitives.Ints;
import com.google.common.util.concurrent.Uninterruptibles;
import java.nio.ByteBuffer;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.cassandra.audit.AuditLogManager;
import org.apache.cassandra.audit.FullQueryLoggerOptions;
import org.apache.cassandra.batchlog.Batch;
import org.apache.cassandra.batchlog.BatchlogManager;
import org.apache.cassandra.concurrent.Stage;
import org.apache.cassandra.concurrent.StageManager;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.db.CounterMutation;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.HintedHandOffManager;
import org.apache.cassandra.db.IMutation;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.Mutation;
import org.apache.cassandra.db.PartitionPosition;
import org.apache.cassandra.db.PartitionRangeReadCommand;
import org.apache.cassandra.db.ReadCommand;
import org.apache.cassandra.db.ReadExecutionController;
import org.apache.cassandra.db.ReadResponse;
import org.apache.cassandra.db.SinglePartitionReadCommand;
import org.apache.cassandra.db.TruncateRequest;
import org.apache.cassandra.db.WriteType;
import org.apache.cassandra.db.filter.DataLimits;
import org.apache.cassandra.db.filter.TombstoneOverwhelmingException;
import org.apache.cassandra.db.partitions.FilteredPartition;
import org.apache.cassandra.db.partitions.PartitionIterator;
import org.apache.cassandra.db.partitions.PartitionIterators;
import org.apache.cassandra.db.partitions.PartitionUpdate;
import org.apache.cassandra.db.partitions.UnfilteredPartitionIterator;
import org.apache.cassandra.db.rows.RowIterator;
import org.apache.cassandra.db.view.ViewUtils;
import org.apache.cassandra.dht.AbstractBounds;
import org.apache.cassandra.dht.Bounds;
import org.apache.cassandra.dht.RingPosition;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.exceptions.IsBootstrappingException;
import org.apache.cassandra.exceptions.OverloadedException;
import org.apache.cassandra.exceptions.ReadFailureException;
import org.apache.cassandra.exceptions.ReadTimeoutException;
import org.apache.cassandra.exceptions.RequestFailureException;
import org.apache.cassandra.exceptions.RequestFailureReason;
import org.apache.cassandra.exceptions.RequestTimeoutException;
import org.apache.cassandra.exceptions.UnavailableException;
import org.apache.cassandra.exceptions.WriteFailureException;
import org.apache.cassandra.exceptions.WriteTimeoutException;
import org.apache.cassandra.gms.Gossiper;
import org.apache.cassandra.hints.Hint;
import org.apache.cassandra.hints.HintsService;
import org.apache.cassandra.index.Index;
import org.apache.cassandra.locator.AbstractReplicationStrategy;
import org.apache.cassandra.locator.EndpointsForRange;
import org.apache.cassandra.locator.EndpointsForToken;
import org.apache.cassandra.locator.IEndpointSnitch;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.locator.LocalStrategy;
import org.apache.cassandra.locator.Replica;
import org.apache.cassandra.locator.ReplicaLayout;
import org.apache.cassandra.locator.ReplicaPlan;
import org.apache.cassandra.locator.ReplicaPlans;
import org.apache.cassandra.locator.Replicas;
import org.apache.cassandra.locator.TokenMetadata;
import org.apache.cassandra.metrics.CASClientRequestMetrics;
import org.apache.cassandra.metrics.CASClientWriteRequestMetrics;
import org.apache.cassandra.metrics.ClientRequestMetrics;
import org.apache.cassandra.metrics.ClientWriteRequestMetrics;
import org.apache.cassandra.metrics.ReadRepairMetrics;
import org.apache.cassandra.metrics.StorageMetrics;
import org.apache.cassandra.metrics.ViewWriteMetrics;
import org.apache.cassandra.net.ForwardingInfo;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.net.MessageFlag;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.net.NoPayload;
import org.apache.cassandra.net.RequestCallback;
import org.apache.cassandra.net.Verb;
import org.apache.cassandra.schema.Schema;
import org.apache.cassandra.schema.SchemaConstants;
import org.apache.cassandra.schema.TableId;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.service.AbstractWriteResponseHandler;
import org.apache.cassandra.service.BatchlogResponseHandler;
import org.apache.cassandra.service.CASRequest;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.service.StorageProxyMBean;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.service.TruncateResponseHandler;
import org.apache.cassandra.service.WriteResponseHandler;
import org.apache.cassandra.service.paxos.Commit;
import org.apache.cassandra.service.paxos.PaxosState;
import org.apache.cassandra.service.paxos.PrepareCallback;
import org.apache.cassandra.service.paxos.PrepareVerbHandler;
import org.apache.cassandra.service.paxos.ProposeCallback;
import org.apache.cassandra.service.paxos.ProposeVerbHandler;
import org.apache.cassandra.service.reads.AbstractReadExecutor;
import org.apache.cassandra.service.reads.DataResolver;
import org.apache.cassandra.service.reads.ReadCallback;
import org.apache.cassandra.service.reads.repair.ReadRepair;
import org.apache.cassandra.tracing.Tracing;
import org.apache.cassandra.triggers.TriggerExecutor;
import org.apache.cassandra.utils.AbstractIterator;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.MBeanWrapper;
import org.apache.cassandra.utils.MonotonicClock;
import org.apache.cassandra.utils.Pair;
import org.apache.cassandra.utils.UUIDGen;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageProxy
implements StorageProxyMBean {
    public static final String MBEAN_NAME = "org.apache.cassandra.db:type=StorageProxy";
    private static final Logger logger = LoggerFactory.getLogger(StorageProxy.class);
    public static final String UNREACHABLE = "UNREACHABLE";
    private static final WritePerformer standardWritePerformer;
    private static final WritePerformer counterWritePerformer;
    private static final WritePerformer counterWriteOnCoordinatorPerformer;
    public static final StorageProxy instance;
    private static volatile int maxHintsInProgress;
    private static final CacheLoader<InetAddressAndPort, AtomicInteger> hintsInProgress;
    private static final ClientRequestMetrics readMetrics;
    private static final ClientRequestMetrics rangeMetrics;
    private static final ClientWriteRequestMetrics writeMetrics;
    private static final CASClientWriteRequestMetrics casWriteMetrics;
    private static final CASClientRequestMetrics casReadMetrics;
    private static final ViewWriteMetrics viewWriteMetrics;
    private static final Map<ConsistencyLevel, ClientRequestMetrics> readMetricsMap;
    private static final Map<ConsistencyLevel, ClientWriteRequestMetrics> writeMetricsMap;
    private static final double CONCURRENT_SUBREQUESTS_MARGIN = 0.1;

    private StorageProxy() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static RowIterator cas(String keyspaceName, String cfName, DecoratedKey key, CASRequest request, ConsistencyLevel consistencyForPaxos, ConsistencyLevel consistencyForCommit, ClientState state, int nowInSeconds, long queryStartNanoTime) throws UnavailableException, IsBootstrappingException, RequestFailureException, RequestTimeoutException, InvalidRequestException {
        long startTimeForMetrics = System.nanoTime();
        TableMetadata metadata = Schema.instance.getTableMetadata(keyspaceName, cfName);
        int contentions = 0;
        try {
            consistencyForPaxos.validateForCas();
            consistencyForCommit.validateForCasCommit(keyspaceName);
            long timeoutNanos = DatabaseDescriptor.getCasContentionTimeout(TimeUnit.NANOSECONDS);
            while (System.nanoTime() - queryStartNanoTime < timeoutNanos) {
                FilteredPartition current;
                ReplicaPlan.ForPaxosWrite replicaPlan = ReplicaPlans.forPaxos(Keyspace.open(keyspaceName), key, consistencyForPaxos);
                PaxosBallotAndContention pair = StorageProxy.beginAndRepairPaxos(queryStartNanoTime, key, metadata, replicaPlan, consistencyForPaxos, consistencyForCommit, true, state);
                UUID ballot = pair.ballot;
                contentions += pair.contentions;
                Tracing.trace("Reading existing values for CAS precondition");
                SinglePartitionReadCommand readCommand = (SinglePartitionReadCommand)request.readCommand(nowInSeconds);
                ConsistencyLevel readConsistency = consistencyForPaxos == ConsistencyLevel.LOCAL_SERIAL ? ConsistencyLevel.LOCAL_QUORUM : ConsistencyLevel.QUORUM;
                try (RowIterator rowIter = StorageProxy.readOne(readCommand, readConsistency, queryStartNanoTime);){
                    current = FilteredPartition.create(rowIter);
                }
                if (!request.appliesTo(current)) {
                    Tracing.trace("CAS precondition does not match current values {}", (Object)current);
                    StorageProxy.casWriteMetrics.conditionNotMet.inc();
                    rowIter = current.rowIterator();
                    return rowIter;
                }
                PartitionUpdate updates = request.makeUpdates(current);
                long size = updates.dataSize();
                StorageProxy.casWriteMetrics.mutationSize.update(size);
                StorageProxy.writeMetricsMap.get((Object)((Object)consistencyForPaxos)).mutationSize.update(size);
                updates = TriggerExecutor.instance.execute(updates);
                Commit proposal = Commit.newProposal(ballot, updates);
                Tracing.trace("CAS precondition is met; proposing client-requested updates for {}", (Object)ballot);
                if (StorageProxy.proposePaxos(proposal, replicaPlan, true, queryStartNanoTime)) {
                    StorageProxy.commitPaxos(proposal, consistencyForCommit, true, queryStartNanoTime);
                    Tracing.trace("CAS successful");
                    RowIterator rowIterator = null;
                    return rowIterator;
                }
                Tracing.trace("Paxos proposal not accepted (pre-empted by a higher ballot)");
                ++contentions;
                Uninterruptibles.sleepUninterruptibly((long)ThreadLocalRandom.current().nextInt(100), (TimeUnit)TimeUnit.MILLISECONDS);
            }
            throw new WriteTimeoutException(WriteType.CAS, consistencyForPaxos, 0, consistencyForPaxos.blockFor(Keyspace.open(keyspaceName)));
        }
        catch (ReadTimeoutException | WriteTimeoutException e) {
            StorageProxy.casWriteMetrics.timeouts.mark();
            StorageProxy.writeMetricsMap.get((Object)((Object)consistencyForPaxos)).timeouts.mark();
            throw e;
        }
        catch (ReadFailureException | WriteFailureException e) {
            StorageProxy.casWriteMetrics.failures.mark();
            StorageProxy.writeMetricsMap.get((Object)((Object)consistencyForPaxos)).failures.mark();
            throw e;
        }
        catch (UnavailableException e) {
            StorageProxy.casWriteMetrics.unavailables.mark();
            StorageProxy.writeMetricsMap.get((Object)((Object)consistencyForPaxos)).unavailables.mark();
            throw e;
        }
        finally {
            StorageProxy.recordCasContention(contentions);
            Keyspace.open((String)keyspaceName).getColumnFamilyStore((String)cfName).metric.topCasPartitionContention.addSample(key.getKey(), contentions);
            long latency = System.nanoTime() - startTimeForMetrics;
            casWriteMetrics.addNano(latency);
            writeMetricsMap.get((Object)consistencyForPaxos).addNano(latency);
        }
    }

    private static void recordCasContention(int contentions) {
        if (contentions > 0) {
            StorageProxy.casWriteMetrics.contention.update(contentions);
        }
    }

    private static PaxosBallotAndContention beginAndRepairPaxos(long queryStartNanoTime, DecoratedKey key, TableMetadata metadata, ReplicaPlan.ForPaxosWrite paxosPlan, ConsistencyLevel consistencyForPaxos, ConsistencyLevel consistencyForCommit, boolean isWrite, ClientState state) throws WriteTimeoutException, WriteFailureException {
        long timeoutNanos = DatabaseDescriptor.getCasContentionTimeout(TimeUnit.NANOSECONDS);
        PrepareCallback summary = null;
        int contentions = 0;
        while (System.nanoTime() - queryStartNanoTime < timeoutNanos) {
            long minTimestampMicrosToUse = summary == null ? Long.MIN_VALUE : 1L + UUIDGen.microsTimestamp(summary.mostRecentInProgressCommit.ballot);
            long ballotMicros = state.getTimestampForPaxos(minTimestampMicrosToUse);
            UUID ballot = UUIDGen.getRandomTimeUUIDFromMicros(ballotMicros);
            Tracing.trace("Preparing {}", (Object)ballot);
            Commit toPrepare = Commit.newPrepare(key, metadata, ballot);
            summary = StorageProxy.preparePaxos(toPrepare, paxosPlan, queryStartNanoTime);
            if (!summary.promised) {
                Tracing.trace("Some replicas have already promised a higher ballot than ours; aborting");
                ++contentions;
                Uninterruptibles.sleepUninterruptibly((long)ThreadLocalRandom.current().nextInt(100), (TimeUnit)TimeUnit.MILLISECONDS);
                continue;
            }
            Commit inProgress = summary.mostRecentInProgressCommitWithUpdate;
            Commit mostRecent = summary.mostRecentCommit;
            if (!inProgress.update.isEmpty() && inProgress.isAfter(mostRecent)) {
                Tracing.trace("Finishing incomplete paxos round {}", (Object)inProgress);
                if (isWrite) {
                    StorageProxy.casWriteMetrics.unfinishedCommit.inc();
                } else {
                    StorageProxy.casReadMetrics.unfinishedCommit.inc();
                }
                Commit refreshedInProgress = Commit.newProposal(ballot, inProgress.update);
                if (StorageProxy.proposePaxos(refreshedInProgress, paxosPlan, false, queryStartNanoTime)) {
                    try {
                        StorageProxy.commitPaxos(refreshedInProgress, consistencyForCommit, false, queryStartNanoTime);
                        continue;
                    }
                    catch (WriteTimeoutException e) {
                        StorageProxy.recordCasContention(contentions);
                        throw new WriteTimeoutException(WriteType.CAS, e.consistency, e.received, e.blockFor);
                    }
                }
                Tracing.trace("Some replicas have already promised a higher ballot than ours; aborting");
                ++contentions;
                Uninterruptibles.sleepUninterruptibly((long)ThreadLocalRandom.current().nextInt(100), (TimeUnit)TimeUnit.MILLISECONDS);
                continue;
            }
            int nowInSec = Ints.checkedCast((long)TimeUnit.MICROSECONDS.toSeconds(ballotMicros));
            Iterable<InetAddressAndPort> missingMRC = summary.replicasMissingMostRecentCommit(metadata, nowInSec);
            if (Iterables.size(missingMRC) > 0) {
                Tracing.trace("Repairing replicas that missed the most recent commit");
                StorageProxy.sendCommit(mostRecent, missingMRC);
                continue;
            }
            return new PaxosBallotAndContention(ballot, contentions);
        }
        StorageProxy.recordCasContention(contentions);
        throw new WriteTimeoutException(WriteType.CAS, consistencyForPaxos, 0, consistencyForPaxos.blockFor(Keyspace.open(metadata.keyspace)));
    }

    private static void sendCommit(Commit commit, Iterable<InetAddressAndPort> replicas) {
        Message<Commit> message = Message.out(Verb.PAXOS_COMMIT_REQ, commit);
        for (InetAddressAndPort target : replicas) {
            MessagingService.instance().send(message, target);
        }
    }

    private static PrepareCallback preparePaxos(Commit toPrepare, ReplicaPlan.ForPaxosWrite replicaPlan, long queryStartNanoTime) throws WriteTimeoutException {
        PrepareCallback callback = new PrepareCallback(toPrepare.update.partitionKey(), toPrepare.update.metadata(), replicaPlan.requiredParticipants(), replicaPlan.consistencyLevel(), queryStartNanoTime);
        Message<Commit> message = Message.out(Verb.PAXOS_PREPARE_REQ, toPrepare);
        for (Replica replica : (EndpointsForToken)replicaPlan.contacts()) {
            if (replica.isSelf()) {
                StageManager.getStage(Verb.PAXOS_PREPARE_REQ.stage).execute(() -> {
                    try {
                        callback.onResponse(message.responseWith((Commit)((Object)PrepareVerbHandler.doPrepare(toPrepare))));
                    }
                    catch (Exception ex) {
                        logger.error("Failed paxos prepare locally", (Throwable)ex);
                    }
                });
                continue;
            }
            MessagingService.instance().sendWithCallback(message, replica.endpoint(), callback);
        }
        callback.await();
        return callback;
    }

    private static boolean proposePaxos(Commit proposal, ReplicaPlan.ForPaxosWrite replicaPlan, boolean timeoutIfPartial, long queryStartNanoTime) throws WriteTimeoutException {
        ProposeCallback callback = new ProposeCallback(((EndpointsForToken)replicaPlan.contacts()).size(), replicaPlan.requiredParticipants(), !timeoutIfPartial, replicaPlan.consistencyLevel(), queryStartNanoTime);
        Message<Commit> message = Message.out(Verb.PAXOS_PROPOSE_REQ, proposal);
        for (Replica replica : (EndpointsForToken)replicaPlan.contacts()) {
            if (replica.isSelf()) {
                StageManager.getStage(Verb.PAXOS_PROPOSE_REQ.stage).execute(() -> {
                    try {
                        Message<Boolean> response = message.responseWith((Commit)((Object)ProposeVerbHandler.doPropose(proposal)));
                        callback.onResponse(response);
                    }
                    catch (Exception ex) {
                        logger.error("Failed paxos propose locally", (Throwable)ex);
                    }
                });
                continue;
            }
            MessagingService.instance().sendWithCallback(message, replica.endpoint(), callback);
        }
        callback.await();
        if (callback.isSuccessful()) {
            return true;
        }
        if (timeoutIfPartial && !callback.isFullyRefused()) {
            throw new WriteTimeoutException(WriteType.CAS, replicaPlan.consistencyLevel(), callback.getAcceptCount(), replicaPlan.requiredParticipants());
        }
        return false;
    }

    private static void commitPaxos(Commit proposal, ConsistencyLevel consistencyLevel, boolean allowHints, long queryStartNanoTime) throws WriteTimeoutException {
        boolean shouldBlock = consistencyLevel != ConsistencyLevel.ANY;
        Keyspace keyspace = Keyspace.open(proposal.update.metadata().keyspace);
        Token tk = proposal.update.partitionKey().getToken();
        AbstractWriteResponseHandler responseHandler = null;
        ReplicaPlan.ForTokenWrite replicaPlan = ReplicaPlans.forWrite(keyspace, consistencyLevel, tk, ReplicaPlans.writeAll);
        if (shouldBlock) {
            AbstractReplicationStrategy rs = keyspace.getReplicationStrategy();
            responseHandler = rs.getWriteResponseHandler(replicaPlan, null, WriteType.SIMPLE, queryStartNanoTime);
            responseHandler.setSupportsBackPressure(false);
        }
        Message<Commit> message = Message.outWithFlag(Verb.PAXOS_COMMIT_REQ, proposal, MessageFlag.CALL_BACK_ON_FAILURE);
        for (Replica replica : (EndpointsForToken)replicaPlan.liveAndDown()) {
            InetAddressAndPort destination = replica.endpoint();
            StorageProxy.checkHintOverload(replica);
            if (replicaPlan.isAlive(replica)) {
                if (shouldBlock) {
                    if (replica.isSelf()) {
                        StorageProxy.commitPaxosLocal(replica, message, responseHandler);
                        continue;
                    }
                    MessagingService.instance().sendWriteWithCallback(message, replica, responseHandler, allowHints && StorageProxy.shouldHint(replica));
                    continue;
                }
                MessagingService.instance().send(message, destination);
                continue;
            }
            if (responseHandler != null) {
                responseHandler.expired();
            }
            if (!allowHints || !StorageProxy.shouldHint(replica)) continue;
            StorageProxy.submitHint(proposal.makeMutation(), replica, null);
        }
        if (shouldBlock) {
            responseHandler.get();
        }
    }

    private static void commitPaxosLocal(Replica localReplica, final Message<Commit> message, final AbstractWriteResponseHandler<?> responseHandler) {
        StageManager.getStage(Verb.PAXOS_COMMIT_REQ.stage).maybeExecuteImmediately(new LocalMutationRunnable(localReplica){

            @Override
            public void runMayThrow() {
                try {
                    PaxosState.commit((Commit)message.payload);
                    if (responseHandler != null) {
                        responseHandler.onResponse(null);
                    }
                }
                catch (Exception ex) {
                    if (!(ex instanceof WriteTimeoutException)) {
                        logger.error("Failed to apply paxos commit locally : ", (Throwable)ex);
                    }
                    responseHandler.onFailure(FBUtilities.getBroadcastAddressAndPort(), RequestFailureReason.forException(ex));
                }
            }

            @Override
            protected Verb verb() {
                return Verb.PAXOS_COMMIT_REQ;
            }
        });
    }

    public static void mutate(List<? extends IMutation> mutations, ConsistencyLevel consistencyLevel, long queryStartNanoTime) throws UnavailableException, OverloadedException, WriteTimeoutException, WriteFailureException {
        block15: {
            Tracing.trace("Determining replicas for mutation");
            String localDataCenter = DatabaseDescriptor.getEndpointSnitch().getLocalDatacenter();
            long startTime = System.nanoTime();
            ArrayList<AbstractWriteResponseHandler<IMutation>> responseHandlers = new ArrayList<AbstractWriteResponseHandler<IMutation>>(mutations.size());
            WriteType plainWriteType = mutations.size() <= 1 ? WriteType.SIMPLE : WriteType.UNLOGGED_BATCH;
            try {
                for (IMutation iMutation : mutations) {
                    if (iMutation instanceof CounterMutation) {
                        responseHandlers.add(StorageProxy.mutateCounter((CounterMutation)iMutation, localDataCenter, queryStartNanoTime));
                        continue;
                    }
                    responseHandlers.add(StorageProxy.performWrite(iMutation, consistencyLevel, localDataCenter, standardWritePerformer, null, plainWriteType, queryStartNanoTime));
                }
                for (int i = 0; i < mutations.size(); ++i) {
                    if (mutations.get(i) instanceof CounterMutation) continue;
                    ((AbstractWriteResponseHandler)responseHandlers.get(i)).maybeTryAdditionalReplicas(mutations.get(i), standardWritePerformer, localDataCenter);
                }
                for (AbstractWriteResponseHandler abstractWriteResponseHandler : responseHandlers) {
                    abstractWriteResponseHandler.get();
                }
            }
            catch (WriteFailureException | WriteTimeoutException ex) {
                if (consistencyLevel == ConsistencyLevel.ANY) {
                    StorageProxy.hintMutations(mutations);
                    break block15;
                }
                if (ex instanceof WriteFailureException) {
                    StorageProxy.writeMetrics.failures.mark();
                    StorageProxy.writeMetricsMap.get((Object)((Object)consistencyLevel)).failures.mark();
                    WriteFailureException writeFailureException = (WriteFailureException)ex;
                    Tracing.trace("Write failure; received {} of {} required replies, failed {} requests", writeFailureException.received, writeFailureException.blockFor, writeFailureException.failureReasonByEndpoint.size());
                } else {
                    StorageProxy.writeMetrics.timeouts.mark();
                    StorageProxy.writeMetricsMap.get((Object)((Object)consistencyLevel)).timeouts.mark();
                    WriteTimeoutException writeTimeoutException = (WriteTimeoutException)ex;
                    Tracing.trace("Write timeout; received {} of {} required replies", (Object)writeTimeoutException.received, (Object)writeTimeoutException.blockFor);
                }
                throw ex;
            }
            catch (UnavailableException e) {
                StorageProxy.writeMetrics.unavailables.mark();
                StorageProxy.writeMetricsMap.get((Object)((Object)consistencyLevel)).unavailables.mark();
                Tracing.trace("Unavailable");
                throw e;
            }
            catch (OverloadedException e) {
                StorageProxy.writeMetrics.unavailables.mark();
                StorageProxy.writeMetricsMap.get((Object)((Object)consistencyLevel)).unavailables.mark();
                Tracing.trace("Overloaded");
                throw e;
            }
            finally {
                long latency = System.nanoTime() - startTime;
                writeMetrics.addNano(latency);
                writeMetricsMap.get((Object)consistencyLevel).addNano(latency);
                StorageProxy.updateCoordinatorWriteLatencyTableMetric(mutations, latency);
            }
        }
    }

    private static void hintMutations(Collection<? extends IMutation> mutations) {
        for (IMutation iMutation : mutations) {
            if (iMutation instanceof CounterMutation) continue;
            StorageProxy.hintMutation((Mutation)iMutation);
        }
        Tracing.trace("Wrote hints to satisfy CL.ANY after no replicas acknowledged the write");
    }

    private static void hintMutation(Mutation mutation) {
        String keyspaceName = mutation.getKeyspaceName();
        Token token = mutation.key().getToken();
        EndpointsForToken replicasToHint = (EndpointsForToken)((EndpointsForToken)ReplicaLayout.forTokenWriteLiveAndDown(Keyspace.open(keyspaceName), token).all()).filter(StorageProxy::shouldHint);
        StorageProxy.submitHint(mutation, replicasToHint, null);
    }

    public boolean appliesLocally(Mutation mutation) {
        String keyspaceName = mutation.getKeyspaceName();
        Token token = mutation.key().getToken();
        InetAddressAndPort local = FBUtilities.getBroadcastAddressAndPort();
        return ((EndpointsForToken)ReplicaLayout.forTokenWriteLiveAndDown(Keyspace.open(keyspaceName), token).all()).endpoints().contains(local);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void mutateMV(ByteBuffer dataKey, Collection<Mutation> mutations, boolean writeCommitLog, AtomicLong baseComplete, long queryStartNanoTime) throws UnavailableException, OverloadedException, WriteTimeoutException {
        Tracing.trace("Determining replicas for mutation");
        String localDataCenter = DatabaseDescriptor.getEndpointSnitch().getLocalDatacenter();
        long startTime = System.nanoTime();
        try {
            UUID batchUUID = UUIDGen.getTimeUUID();
            if (StorageService.instance.isStarting() || StorageService.instance.isJoining() || StorageService.instance.isMoving()) {
                BatchlogManager.store(Batch.createLocal(batchUUID, FBUtilities.timestampMicros(), mutations), writeCommitLog);
            } else {
                ArrayList<WriteResponseHandlerWrapper> wrappers = new ArrayList<WriteResponseHandlerWrapper>(mutations.size());
                HashSet<Mutation> nonLocalMutations = new HashSet<Mutation>(mutations);
                Token baseToken = StorageService.instance.getTokenMetadata().partitioner.getToken(dataKey);
                ConsistencyLevel consistencyLevel = ConsistencyLevel.ONE;
                ReplicaPlan.ForTokenWrite replicaPlan = ReplicaPlans.forLocalBatchlogWrite();
                BatchlogResponseHandler.BatchlogCleanup cleanup = new BatchlogResponseHandler.BatchlogCleanup(mutations.size(), () -> StorageProxy.asyncRemoveFromBatchlog(replicaPlan, batchUUID));
                for (Mutation mutation : mutations) {
                    String keyspaceName = mutation.getKeyspaceName();
                    Token tk = mutation.key().getToken();
                    Optional<Replica> pairedEndpoint = ViewUtils.getViewNaturalEndpoint(keyspaceName, baseToken, tk);
                    EndpointsForToken pendingReplicas = StorageService.instance.getTokenMetadata().pendingEndpointsForToken(tk, keyspaceName);
                    if (!pairedEndpoint.isPresent()) {
                        if (!pendingReplicas.isEmpty()) continue;
                        logger.warn("Received base materialized view mutation for key {} that does not belong to this node. There is probably a range movement happening (move or decommission),but this node hasn't updated its ring metadata yet. Adding mutation to local batchlog to be replayed later.", (Object)mutation.key());
                        continue;
                    }
                    if (pairedEndpoint.get().isSelf() && StorageService.instance.isJoined() && pendingReplicas.isEmpty()) {
                        try {
                            mutation.apply(writeCommitLog);
                            nonLocalMutations.remove(mutation);
                            cleanup.ackMutation();
                            continue;
                        }
                        catch (Exception exc) {
                            logger.error("Error applying local view update to keyspace {}: {}", (Object)mutation.getKeyspaceName(), (Object)mutation);
                            throw exc;
                        }
                    }
                    wrappers.add(StorageProxy.wrapViewBatchResponseHandler(mutation, consistencyLevel, consistencyLevel, EndpointsForToken.of(tk, pairedEndpoint.get()), pendingReplicas, baseComplete, WriteType.BATCH, cleanup, queryStartNanoTime));
                }
                if (!nonLocalMutations.isEmpty()) {
                    BatchlogManager.store(Batch.createLocal(batchUUID, FBUtilities.timestampMicros(), nonLocalMutations), writeCommitLog);
                }
                if (!wrappers.isEmpty()) {
                    StorageProxy.asyncWriteBatchedMutations(wrappers, localDataCenter, Stage.VIEW_MUTATION);
                }
            }
        }
        finally {
            viewWriteMetrics.addNano(System.nanoTime() - startTime);
        }
    }

    public static void mutateWithTriggers(List<? extends IMutation> mutations, ConsistencyLevel consistencyLevel, boolean mutateAtomically, long queryStartNanoTime) throws WriteTimeoutException, WriteFailureException, UnavailableException, OverloadedException, InvalidRequestException {
        Collection<Mutation> augmented = TriggerExecutor.instance.execute(mutations);
        boolean updatesView = Keyspace.open((String)mutations.iterator().next().getKeyspaceName()).viewManager.updatesAffectView(mutations, true);
        long size = IMutation.dataSize(mutations);
        StorageProxy.writeMetrics.mutationSize.update(size);
        StorageProxy.writeMetricsMap.get((Object)((Object)consistencyLevel)).mutationSize.update(size);
        if (augmented != null) {
            StorageProxy.mutateAtomically(augmented, consistencyLevel, updatesView, queryStartNanoTime);
        } else if (mutateAtomically || updatesView) {
            StorageProxy.mutateAtomically(mutations, consistencyLevel, updatesView, queryStartNanoTime);
        } else {
            StorageProxy.mutate(mutations, consistencyLevel, queryStartNanoTime);
        }
    }

    public static void mutateAtomically(Collection<Mutation> mutations, ConsistencyLevel consistency_level, boolean requireQuorumForRemove, long queryStartNanoTime) throws UnavailableException, OverloadedException, WriteTimeoutException {
        Tracing.trace("Determining replicas for atomic batch");
        long startTime = System.nanoTime();
        ArrayList<WriteResponseHandlerWrapper> wrappers = new ArrayList<WriteResponseHandlerWrapper>(mutations.size());
        if (mutations.stream().anyMatch(mutation -> Keyspace.open(mutation.getKeyspaceName()).getReplicationStrategy().hasTransientReplicas())) {
            throw new AssertionError((Object)"Logged batches are unsupported with transient replication");
        }
        try {
            ConsistencyLevel batchConsistencyLevel = requireQuorumForRemove ? ConsistencyLevel.QUORUM : consistency_level;
            switch (consistency_level) {
                case ALL: 
                case EACH_QUORUM: {
                    batchConsistencyLevel = consistency_level;
                }
            }
            ReplicaPlan.ForTokenWrite replicaPlan = ReplicaPlans.forBatchlogWrite(batchConsistencyLevel == ConsistencyLevel.ANY);
            UUID batchUUID = UUIDGen.getTimeUUID();
            BatchlogResponseHandler.BatchlogCleanup cleanup = new BatchlogResponseHandler.BatchlogCleanup(mutations.size(), () -> StorageProxy.asyncRemoveFromBatchlog(replicaPlan, batchUUID));
            for (Mutation mutation2 : mutations) {
                WriteResponseHandlerWrapper wrapper = StorageProxy.wrapBatchResponseHandler(mutation2, consistency_level, batchConsistencyLevel, WriteType.BATCH, cleanup, queryStartNanoTime);
                wrappers.add(wrapper);
            }
            StorageProxy.syncWriteToBatchlog(mutations, replicaPlan, batchUUID, queryStartNanoTime);
            StorageProxy.syncWriteBatchedMutations(wrappers, Stage.MUTATION);
        }
        catch (UnavailableException e) {
            StorageProxy.writeMetrics.unavailables.mark();
            StorageProxy.writeMetricsMap.get((Object)((Object)consistency_level)).unavailables.mark();
            Tracing.trace("Unavailable");
            throw e;
        }
        catch (WriteTimeoutException e) {
            StorageProxy.writeMetrics.timeouts.mark();
            StorageProxy.writeMetricsMap.get((Object)((Object)consistency_level)).timeouts.mark();
            Tracing.trace("Write timeout; received {} of {} required replies", (Object)e.received, (Object)e.blockFor);
            throw e;
        }
        catch (WriteFailureException e) {
            StorageProxy.writeMetrics.failures.mark();
            StorageProxy.writeMetricsMap.get((Object)((Object)consistency_level)).failures.mark();
            Tracing.trace("Write failure; received {} of {} required replies", (Object)e.received, (Object)e.blockFor);
            throw e;
        }
        finally {
            long latency = System.nanoTime() - startTime;
            writeMetrics.addNano(latency);
            writeMetricsMap.get((Object)consistency_level).addNano(latency);
            StorageProxy.updateCoordinatorWriteLatencyTableMetric(mutations, latency);
        }
    }

    private static void updateCoordinatorWriteLatencyTableMetric(Collection<? extends IMutation> mutations, long latency) {
        if (null == mutations) {
            return;
        }
        try {
            mutations.forEach(mutation -> mutation.getTableIds().forEach(tableId -> Keyspace.open((String)mutation.getKeyspaceName()).getColumnFamilyStore((TableId)tableId).metric.coordinatorWriteLatency.update(latency, TimeUnit.NANOSECONDS)));
        }
        catch (Exception ex) {
            logger.warn("Exception occurred updating coordinatorWriteLatency metric", (Throwable)ex);
        }
    }

    private static void syncWriteToBatchlog(Collection<Mutation> mutations, ReplicaPlan.ForTokenWrite replicaPlan, UUID uuid, long queryStartNanoTime) throws WriteTimeoutException, WriteFailureException {
        WriteResponseHandler handler = new WriteResponseHandler(replicaPlan, WriteType.BATCH_LOG, queryStartNanoTime);
        Batch batch = Batch.createLocal(uuid, FBUtilities.timestampMicros(), mutations);
        Message<Batch> message = Message.out(Verb.BATCH_STORE_REQ, batch);
        for (Replica replica : (EndpointsForToken)replicaPlan.liveAndDown()) {
            logger.trace("Sending batchlog store request {} to {} for {} mutations", new Object[]{batch.id, replica, batch.size()});
            if (replica.isSelf()) {
                StorageProxy.performLocally(Stage.MUTATION, replica, () -> BatchlogManager.store(batch), handler);
                continue;
            }
            MessagingService.instance().sendWithCallback(message, replica.endpoint(), handler);
        }
        handler.get();
    }

    private static void asyncRemoveFromBatchlog(ReplicaPlan.ForTokenWrite replicaPlan, UUID uuid) {
        Message<UUID> message = Message.out(Verb.BATCH_REMOVE_REQ, uuid);
        for (Replica target : (EndpointsForToken)replicaPlan.contacts()) {
            if (logger.isTraceEnabled()) {
                logger.trace("Sending batchlog remove request {} to {}", (Object)uuid, (Object)target);
            }
            if (target.isSelf()) {
                StorageProxy.performLocally(Stage.MUTATION, target, () -> BatchlogManager.remove(uuid));
                continue;
            }
            MessagingService.instance().send(message, target.endpoint());
        }
    }

    private static void asyncWriteBatchedMutations(List<WriteResponseHandlerWrapper> wrappers, String localDataCenter, Stage stage) {
        for (WriteResponseHandlerWrapper wrapper : wrappers) {
            Replicas.temporaryAssertFull(wrapper.handler.replicaPlan.liveAndDown());
            ReplicaPlan.ForTokenWrite replicas = wrapper.handler.replicaPlan.withContact((EndpointsForToken)wrapper.handler.replicaPlan.liveAndDown());
            try {
                StorageProxy.sendToHintedReplicas(wrapper.mutation, replicas, wrapper.handler, localDataCenter, stage);
            }
            catch (OverloadedException | WriteTimeoutException e) {
                wrapper.handler.onFailure(FBUtilities.getBroadcastAddressAndPort(), RequestFailureReason.forException(e));
            }
        }
    }

    private static void syncWriteBatchedMutations(List<WriteResponseHandlerWrapper> wrappers, Stage stage) throws WriteTimeoutException, OverloadedException {
        String localDataCenter = DatabaseDescriptor.getEndpointSnitch().getLocalDatacenter();
        for (WriteResponseHandlerWrapper wrapper : wrappers) {
            EndpointsForToken sendTo = (EndpointsForToken)wrapper.handler.replicaPlan.liveAndDown();
            Replicas.temporaryAssertFull(sendTo);
            StorageProxy.sendToHintedReplicas(wrapper.mutation, wrapper.handler.replicaPlan.withContact(sendTo), wrapper.handler, localDataCenter, stage);
        }
        for (WriteResponseHandlerWrapper wrapper : wrappers) {
            wrapper.handler.get();
        }
    }

    public static AbstractWriteResponseHandler<IMutation> performWrite(IMutation mutation, ConsistencyLevel consistencyLevel, String localDataCenter, WritePerformer performer, Runnable callback, WriteType writeType, long queryStartNanoTime) {
        String keyspaceName = mutation.getKeyspaceName();
        Keyspace keyspace = Keyspace.open(keyspaceName);
        AbstractReplicationStrategy rs = keyspace.getReplicationStrategy();
        Token tk = mutation.key().getToken();
        ReplicaPlan.ForTokenWrite replicaPlan = ReplicaPlans.forWrite(keyspace, consistencyLevel, tk, ReplicaPlans.writeNormal);
        AbstractWriteResponseHandler<IMutation> responseHandler = rs.getWriteResponseHandler(replicaPlan, callback, writeType, queryStartNanoTime);
        performer.apply(mutation, replicaPlan, responseHandler, localDataCenter);
        return responseHandler;
    }

    private static WriteResponseHandlerWrapper wrapBatchResponseHandler(Mutation mutation, ConsistencyLevel consistencyLevel, ConsistencyLevel batchConsistencyLevel, WriteType writeType, BatchlogResponseHandler.BatchlogCleanup cleanup, long queryStartNanoTime) {
        Keyspace keyspace = Keyspace.open(mutation.getKeyspaceName());
        AbstractReplicationStrategy rs = keyspace.getReplicationStrategy();
        Token tk = mutation.key().getToken();
        ReplicaPlan.ForTokenWrite replicaPlan = ReplicaPlans.forWrite(keyspace, consistencyLevel, tk, ReplicaPlans.writeNormal);
        AbstractWriteResponseHandler writeHandler = rs.getWriteResponseHandler(replicaPlan, null, writeType, queryStartNanoTime);
        BatchlogResponseHandler<IMutation> batchHandler = new BatchlogResponseHandler<IMutation>(writeHandler, batchConsistencyLevel.blockFor(keyspace), cleanup, queryStartNanoTime);
        return new WriteResponseHandlerWrapper(batchHandler, mutation);
    }

    private static WriteResponseHandlerWrapper wrapViewBatchResponseHandler(Mutation mutation, ConsistencyLevel consistencyLevel, ConsistencyLevel batchConsistencyLevel, EndpointsForToken naturalEndpoints, EndpointsForToken pendingEndpoints, AtomicLong baseComplete, WriteType writeType, BatchlogResponseHandler.BatchlogCleanup cleanup, long queryStartNanoTime) {
        Keyspace keyspace = Keyspace.open(mutation.getKeyspaceName());
        AbstractReplicationStrategy rs = keyspace.getReplicationStrategy();
        ReplicaLayout.ForTokenWrite liveAndDown = ReplicaLayout.forTokenWrite(naturalEndpoints, pendingEndpoints);
        ReplicaPlan.ForTokenWrite replicaPlan = ReplicaPlans.forWrite(keyspace, consistencyLevel, liveAndDown, ReplicaPlans.writeAll);
        AbstractWriteResponseHandler<IMutation> writeHandler = rs.getWriteResponseHandler(replicaPlan, () -> {
            long delay = Math.max(0L, System.currentTimeMillis() - baseComplete.get());
            StorageProxy.viewWriteMetrics.viewWriteLatency.update(delay, TimeUnit.MILLISECONDS);
        }, writeType, queryStartNanoTime);
        ViewWriteMetricsWrapped batchHandler = new ViewWriteMetricsWrapped(writeHandler, batchConsistencyLevel.blockFor(keyspace), cleanup, queryStartNanoTime);
        return new WriteResponseHandlerWrapper(batchHandler, mutation);
    }

    public static void sendToHintedReplicas(Mutation mutation, ReplicaPlan.ForTokenWrite plan, AbstractWriteResponseHandler<IMutation> responseHandler, String localDataCenter, Stage stage) throws OverloadedException {
        ArrayList<Replica> localDc = null;
        HashMap<String, Collection> dcGroups = null;
        Message<Mutation> message = null;
        boolean insertLocal = false;
        Replica localReplica = null;
        ArrayList<Replica> endpointsToHint = null;
        ArrayList<InetAddressAndPort> backPressureHosts = null;
        for (Replica destination : (EndpointsForToken)plan.contacts()) {
            StorageProxy.checkHintOverload(destination);
            if (plan.isAlive(destination)) {
                String dc;
                if (destination.isSelf()) {
                    insertLocal = true;
                    localReplica = destination;
                    continue;
                }
                if (message == null) {
                    message = Message.outWithFlag(Verb.MUTATION_REQ, mutation, MessageFlag.CALL_BACK_ON_FAILURE);
                }
                if (localDataCenter.equals(dc = DatabaseDescriptor.getEndpointSnitch().getDatacenter(destination))) {
                    if (localDc == null) {
                        localDc = new ArrayList<Replica>(((EndpointsForToken)plan.contacts()).size());
                    }
                    localDc.add(destination);
                } else {
                    Collection messages;
                    if (dcGroups == null) {
                        dcGroups = new HashMap<String, Collection>();
                    }
                    if ((messages = (Collection)dcGroups.get(dc)) == null) {
                        messages = dcGroups.computeIfAbsent(dc, v -> new ArrayList(3));
                    }
                    messages.add(destination);
                }
                if (backPressureHosts == null) {
                    backPressureHosts = new ArrayList<InetAddressAndPort>(((EndpointsForToken)plan.contacts()).size());
                }
                backPressureHosts.add(destination.endpoint());
                continue;
            }
            responseHandler.expired();
            if (!StorageProxy.shouldHint(destination)) continue;
            if (endpointsToHint == null) {
                endpointsToHint = new ArrayList<Replica>();
            }
            endpointsToHint.add(destination);
        }
        if (backPressureHosts != null) {
            MessagingService.instance().applyBackPressure(backPressureHosts, responseHandler.currentTimeoutNanos());
        }
        if (endpointsToHint != null) {
            StorageProxy.submitHint(mutation, EndpointsForToken.copyOf(mutation.key().getToken(), endpointsToHint), responseHandler);
        }
        if (insertLocal) {
            Preconditions.checkNotNull(localReplica);
            StorageProxy.performLocally(stage, localReplica, mutation::apply, responseHandler);
        }
        if (localDc != null) {
            for (Replica destination : localDc) {
                MessagingService.instance().sendWriteWithCallback(message, destination, responseHandler, true);
            }
        }
        if (dcGroups != null) {
            for (Collection dcTargets : dcGroups.values()) {
                StorageProxy.sendMessagesToNonlocalDC(message, EndpointsForToken.copyOf(mutation.key().getToken(), dcTargets), responseHandler);
            }
        }
    }

    private static void checkHintOverload(Replica destination) {
        if (StorageMetrics.totalHintsInProgress.getCount() > (long)maxHintsInProgress && StorageProxy.getHintsInProgressFor(destination.endpoint()).get() > 0 && StorageProxy.shouldHint(destination)) {
            throw new OverloadedException("Too many in flight hints: " + StorageMetrics.totalHintsInProgress.getCount() + " destination: " + destination + " destination hints: " + StorageProxy.getHintsInProgressFor(destination.endpoint()).get());
        }
    }

    private static void sendMessagesToNonlocalDC(Message<? extends IMutation> message, EndpointsForToken targets, AbstractWriteResponseHandler<IMutation> handler) {
        if (targets.size() > 1) {
            EndpointsForToken forwardToReplicas = (EndpointsForToken)targets.subList(1, targets.size());
            for (Replica replica : forwardToReplicas) {
                MessagingService.instance().callbacks.addWithExpiration(handler, message, replica, handler.replicaPlan.consistencyLevel(), true);
                logger.trace("Adding FWD message to {}@{}", (Object)message.id(), (Object)replica);
            }
            long[] messageIds = new long[forwardToReplicas.size()];
            Arrays.fill(messageIds, message.id());
            message = message.withForwardTo(new ForwardingInfo(forwardToReplicas.endpointList(), messageIds));
        }
        MessagingService.instance().sendWriteWithCallback(message, targets.get(0), handler, true);
        logger.trace("Sending message to {}@{}", (Object)message.id(), (Object)targets.get(0));
    }

    private static void performLocally(Stage stage, Replica localReplica, final Runnable runnable) {
        StageManager.getStage(stage).maybeExecuteImmediately(new LocalMutationRunnable(localReplica){

            @Override
            public void runMayThrow() {
                try {
                    runnable.run();
                }
                catch (Exception ex) {
                    logger.error("Failed to apply mutation locally : ", (Throwable)ex);
                }
            }

            @Override
            protected Verb verb() {
                return Verb.MUTATION_REQ;
            }
        });
    }

    private static void performLocally(Stage stage, Replica localReplica, final Runnable runnable, final RequestCallback<?> handler) {
        StageManager.getStage(stage).maybeExecuteImmediately(new LocalMutationRunnable(localReplica){

            @Override
            public void runMayThrow() {
                try {
                    runnable.run();
                    handler.onResponse(null);
                }
                catch (Exception ex) {
                    if (!(ex instanceof WriteTimeoutException)) {
                        logger.error("Failed to apply mutation locally : ", (Throwable)ex);
                    }
                    handler.onFailure(FBUtilities.getBroadcastAddressAndPort(), RequestFailureReason.forException(ex));
                }
            }

            @Override
            protected Verb verb() {
                return Verb.MUTATION_REQ;
            }
        });
    }

    public static AbstractWriteResponseHandler<IMutation> mutateCounter(CounterMutation cm, String localDataCenter, long queryStartNanoTime) throws UnavailableException, OverloadedException {
        Replica replica = StorageProxy.findSuitableReplica(cm.getKeyspaceName(), cm.key(), localDataCenter, cm.consistency());
        if (replica.isSelf()) {
            return StorageProxy.applyCounterMutationOnCoordinator(cm, localDataCenter, queryStartNanoTime);
        }
        String keyspaceName = cm.getKeyspaceName();
        Keyspace keyspace = Keyspace.open(keyspaceName);
        Token tk = cm.key().getToken();
        ReplicaPlans.forWrite(keyspace, cm.consistency(), tk, ReplicaPlans.writeAll);
        WriteResponseHandler<IMutation> responseHandler = new WriteResponseHandler<IMutation>(ReplicaPlans.forForwardingCounterWrite(keyspace, tk, replica), WriteType.COUNTER, queryStartNanoTime);
        Tracing.trace("Enqueuing counter update to {}", (Object)replica);
        Message<CounterMutation> message = Message.outWithFlag(Verb.COUNTER_MUTATION_REQ, cm, MessageFlag.CALL_BACK_ON_FAILURE);
        MessagingService.instance().sendWriteWithCallback(message, replica, responseHandler, false);
        return responseHandler;
    }

    private static Replica findSuitableReplica(String keyspaceName, DecoratedKey key, String localDataCenter, ConsistencyLevel cl) throws UnavailableException {
        Keyspace keyspace = Keyspace.open(keyspaceName);
        IEndpointSnitch snitch = DatabaseDescriptor.getEndpointSnitch();
        EndpointsForToken replicas = keyspace.getReplicationStrategy().getNaturalReplicasForToken(key);
        if ((replicas = (EndpointsForToken)replicas.filter(replica -> StorageService.instance.isRpcReady(replica.endpoint()))).isEmpty()) {
            throw UnavailableException.create(cl, cl.blockFor(keyspace), 0);
        }
        ArrayList<Replica> localReplicas = new ArrayList<Replica>(replicas.size());
        for (Replica replica2 : replicas) {
            if (!snitch.getDatacenter(replica2).equals(localDataCenter)) continue;
            localReplicas.add(replica2);
        }
        if (localReplicas.isEmpty()) {
            if (cl.isDatacenterLocal()) {
                throw UnavailableException.create(cl, cl.blockFor(keyspace), 0);
            }
            replicas = snitch.sortedByProximity(FBUtilities.getBroadcastAddressAndPort(), replicas);
            return replicas.get(0);
        }
        return (Replica)localReplicas.get(ThreadLocalRandom.current().nextInt(localReplicas.size()));
    }

    public static AbstractWriteResponseHandler<IMutation> applyCounterMutationOnLeader(CounterMutation cm, String localDataCenter, Runnable callback, long queryStartNanoTime) throws UnavailableException, OverloadedException {
        return StorageProxy.performWrite(cm, cm.consistency(), localDataCenter, counterWritePerformer, callback, WriteType.COUNTER, queryStartNanoTime);
    }

    public static AbstractWriteResponseHandler<IMutation> applyCounterMutationOnCoordinator(CounterMutation cm, String localDataCenter, long queryStartNanoTime) throws UnavailableException, OverloadedException {
        return StorageProxy.performWrite(cm, cm.consistency(), localDataCenter, counterWriteOnCoordinatorPerformer, null, WriteType.COUNTER, queryStartNanoTime);
    }

    private static Runnable counterWriteTask(final IMutation mutation, final ReplicaPlan.ForTokenWrite replicaPlan, final AbstractWriteResponseHandler<IMutation> responseHandler, final String localDataCenter) {
        return new DroppableRunnable(Verb.COUNTER_MUTATION_REQ){

            @Override
            public void runMayThrow() throws OverloadedException, WriteTimeoutException {
                assert (mutation instanceof CounterMutation);
                Mutation result = ((CounterMutation)mutation).applyCounterMutation();
                responseHandler.onResponse(null);
                StorageProxy.sendToHintedReplicas(result, replicaPlan, responseHandler, localDataCenter, Stage.COUNTER_MUTATION);
            }
        };
    }

    private static boolean systemKeyspaceQuery(List<? extends ReadCommand> cmds) {
        for (ReadCommand readCommand : cmds) {
            if (SchemaConstants.isLocalSystemKeyspace(readCommand.metadata().keyspace)) continue;
            return false;
        }
        return true;
    }

    public static RowIterator readOne(SinglePartitionReadCommand command, ConsistencyLevel consistencyLevel, long queryStartNanoTime) throws UnavailableException, IsBootstrappingException, ReadFailureException, ReadTimeoutException, InvalidRequestException {
        return StorageProxy.readOne(command, consistencyLevel, null, queryStartNanoTime);
    }

    public static RowIterator readOne(SinglePartitionReadCommand command, ConsistencyLevel consistencyLevel, ClientState state, long queryStartNanoTime) throws UnavailableException, IsBootstrappingException, ReadFailureException, ReadTimeoutException, InvalidRequestException {
        return PartitionIterators.getOnlyElement(StorageProxy.read(SinglePartitionReadCommand.Group.one(command), consistencyLevel, state, queryStartNanoTime), command);
    }

    public static PartitionIterator read(SinglePartitionReadCommand.Group group, ConsistencyLevel consistencyLevel, long queryStartNanoTime) throws UnavailableException, IsBootstrappingException, ReadFailureException, ReadTimeoutException, InvalidRequestException {
        assert (!consistencyLevel.isSerialConsistency());
        return StorageProxy.read(group, consistencyLevel, null, queryStartNanoTime);
    }

    public static PartitionIterator read(SinglePartitionReadCommand.Group group, ConsistencyLevel consistencyLevel, ClientState state, long queryStartNanoTime) throws UnavailableException, IsBootstrappingException, ReadFailureException, ReadTimeoutException, InvalidRequestException {
        if (StorageService.instance.isBootstrapMode() && !StorageProxy.systemKeyspaceQuery(group.queries)) {
            StorageProxy.readMetrics.unavailables.mark();
            StorageProxy.readMetricsMap.get((Object)((Object)consistencyLevel)).unavailables.mark();
            throw new IsBootstrappingException();
        }
        return consistencyLevel.isSerialConsistency() ? StorageProxy.readWithPaxos(group, consistencyLevel, state, queryStartNanoTime) : StorageProxy.readRegular(group, consistencyLevel, queryStartNanoTime);
    }

    private static PartitionIterator readWithPaxos(SinglePartitionReadCommand.Group group, ConsistencyLevel consistencyLevel, ClientState state, long queryStartNanoTime) throws InvalidRequestException, UnavailableException, ReadFailureException, ReadTimeoutException {
        assert (state != null);
        if (group.queries.size() > 1) {
            throw new InvalidRequestException("SERIAL/LOCAL_SERIAL consistency may only be requested for one partition at a time");
        }
        long start = System.nanoTime();
        SinglePartitionReadCommand command = (SinglePartitionReadCommand)group.queries.get(0);
        TableMetadata metadata = command.metadata();
        DecoratedKey key = command.partitionKey();
        PartitionIterator result = null;
        try {
            ReplicaPlan.ForPaxosWrite replicaPlan = ReplicaPlans.forPaxos(Keyspace.open(metadata.keyspace), key, consistencyLevel);
            ConsistencyLevel consistencyForCommitOrFetch = consistencyLevel == ConsistencyLevel.LOCAL_SERIAL ? ConsistencyLevel.LOCAL_QUORUM : ConsistencyLevel.QUORUM;
            try {
                PaxosBallotAndContention pair = StorageProxy.beginAndRepairPaxos(start, key, metadata, replicaPlan, consistencyLevel, consistencyForCommitOrFetch, false, state);
                if (pair.contentions > 0) {
                    StorageProxy.casReadMetrics.contention.update(pair.contentions);
                }
            }
            catch (WriteTimeoutException e) {
                throw new ReadTimeoutException(consistencyLevel, 0, consistencyLevel.blockFor(Keyspace.open(metadata.keyspace)), false);
            }
            catch (WriteFailureException e) {
                throw new ReadFailureException(consistencyLevel, e.received, e.blockFor, false, (Map<InetAddressAndPort, RequestFailureReason>)e.failureReasonByEndpoint);
            }
            result = StorageProxy.fetchRows(group.queries, consistencyForCommitOrFetch, queryStartNanoTime);
        }
        catch (UnavailableException e) {
            StorageProxy.readMetrics.unavailables.mark();
            StorageProxy.casReadMetrics.unavailables.mark();
            StorageProxy.readMetricsMap.get((Object)((Object)consistencyLevel)).unavailables.mark();
            throw e;
        }
        catch (ReadTimeoutException e) {
            StorageProxy.readMetrics.timeouts.mark();
            StorageProxy.casReadMetrics.timeouts.mark();
            StorageProxy.readMetricsMap.get((Object)((Object)consistencyLevel)).timeouts.mark();
            throw e;
        }
        catch (ReadFailureException e) {
            StorageProxy.readMetrics.failures.mark();
            StorageProxy.casReadMetrics.failures.mark();
            StorageProxy.readMetricsMap.get((Object)((Object)consistencyLevel)).failures.mark();
            throw e;
        }
        finally {
            long latency = System.nanoTime() - start;
            readMetrics.addNano(latency);
            casReadMetrics.addNano(latency);
            readMetricsMap.get((Object)consistencyLevel).addNano(latency);
            Keyspace.open((String)metadata.keyspace).getColumnFamilyStore((String)metadata.name).metric.coordinatorReadLatency.update(latency, TimeUnit.NANOSECONDS);
        }
        return result;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static PartitionIterator readRegular(SinglePartitionReadCommand.Group group, ConsistencyLevel consistencyLevel, long queryStartNanoTime) throws UnavailableException, ReadFailureException, ReadTimeoutException {
        PartitionIterator partitionIterator;
        long start = System.nanoTime();
        try {
            PartitionIterator result = StorageProxy.fetchRows(group.queries, consistencyLevel, queryStartNanoTime);
            boolean enforceStrictLiveness = ((SinglePartitionReadCommand)group.queries.get(0)).metadata().enforceStrictLiveness();
            if (group.queries.size() > 1) {
                result = group.limits().filter(result, group.nowInSec(), group.selectsFullPartition(), enforceStrictLiveness);
            }
            partitionIterator = result;
        }
        catch (UnavailableException e) {
            try {
                StorageProxy.readMetrics.unavailables.mark();
                StorageProxy.readMetricsMap.get((Object)((Object)consistencyLevel)).unavailables.mark();
                throw e;
                catch (ReadTimeoutException e2) {
                    StorageProxy.readMetrics.timeouts.mark();
                    StorageProxy.readMetricsMap.get((Object)((Object)consistencyLevel)).timeouts.mark();
                    throw e2;
                }
                catch (ReadFailureException e3) {
                    StorageProxy.readMetrics.failures.mark();
                    StorageProxy.readMetricsMap.get((Object)((Object)consistencyLevel)).failures.mark();
                    throw e3;
                }
            }
            catch (Throwable throwable) {
                long latency = System.nanoTime() - start;
                readMetrics.addNano(latency);
                readMetricsMap.get((Object)consistencyLevel).addNano(latency);
                Iterator iterator = group.queries.iterator();
                while (true) {
                    if (!iterator.hasNext()) {
                        throw throwable;
                    }
                    ReadCommand command = (ReadCommand)iterator.next();
                    Keyspace.openAndGetStore((TableMetadata)command.metadata()).metric.coordinatorReadLatency.update(latency, TimeUnit.NANOSECONDS);
                }
            }
        }
        long latency = System.nanoTime() - start;
        readMetrics.addNano(latency);
        readMetricsMap.get((Object)consistencyLevel).addNano(latency);
        Iterator iterator = group.queries.iterator();
        while (iterator.hasNext()) {
            ReadCommand command = (ReadCommand)iterator.next();
            Keyspace.openAndGetStore((TableMetadata)command.metadata()).metric.coordinatorReadLatency.update(latency, TimeUnit.NANOSECONDS);
        }
        return partitionIterator;
    }

    private static PartitionIterator concatAndBlockOnRepair(List<PartitionIterator> iterators, final List<ReadRepair> repairs) {
        final PartitionIterator concatenated = PartitionIterators.concat(iterators);
        if (repairs.isEmpty()) {
            return concatenated;
        }
        return new PartitionIterator(){

            @Override
            public void close() {
                concatenated.close();
                repairs.forEach(ReadRepair::maybeSendAdditionalWrites);
                repairs.forEach(ReadRepair::awaitWrites);
            }

            @Override
            public boolean hasNext() {
                return concatenated.hasNext();
            }

            @Override
            public RowIterator next() {
                return (RowIterator)concatenated.next();
            }
        };
    }

    private static PartitionIterator fetchRows(List<SinglePartitionReadCommand> commands, ConsistencyLevel consistencyLevel, long queryStartNanoTime) throws UnavailableException, ReadFailureException, ReadTimeoutException {
        int i;
        int cmdCount = commands.size();
        AbstractReadExecutor[] reads = new AbstractReadExecutor[cmdCount];
        for (i = 0; i < cmdCount; ++i) {
            reads[i] = AbstractReadExecutor.getReadExecutor(commands.get(i), consistencyLevel, queryStartNanoTime);
        }
        for (i = 0; i < cmdCount; ++i) {
            reads[i].executeAsync();
        }
        for (i = 0; i < cmdCount; ++i) {
            reads[i].maybeTryAdditionalReplicas();
        }
        for (i = 0; i < cmdCount; ++i) {
            reads[i].awaitResponses();
        }
        for (i = 0; i < cmdCount; ++i) {
            reads[i].maybeSendAdditionalDataRequests();
        }
        for (i = 0; i < cmdCount; ++i) {
            reads[i].awaitReadRepair();
        }
        ArrayList<PartitionIterator> results = new ArrayList<PartitionIterator>(cmdCount);
        ArrayList<ReadRepair> repairs = new ArrayList<ReadRepair>(cmdCount);
        for (int i2 = 0; i2 < cmdCount; ++i2) {
            results.add(reads[i2].getResult());
            repairs.add(reads[i2].getReadRepair());
        }
        return StorageProxy.concatAndBlockOnRepair(results, repairs);
    }

    private static float estimateResultsPerRange(PartitionRangeReadCommand command, Keyspace keyspace) {
        ColumnFamilyStore cfs = keyspace.getColumnFamilyStore(command.metadata().id);
        Index index = command.getIndex(cfs);
        float maxExpectedResults = index == null ? command.limits().estimateTotalResults(cfs) : (float)index.getEstimatedResultRows();
        return maxExpectedResults / (float)DatabaseDescriptor.getNumTokens() / (float)keyspace.getReplicationStrategy().getReplicationFactor().allReplicas;
    }

    public static PartitionIterator getRangeSlice(PartitionRangeReadCommand command, ConsistencyLevel consistencyLevel, long queryStartNanoTime) {
        Tracing.trace("Computing ranges to query");
        Keyspace keyspace = Keyspace.open(command.metadata().keyspace);
        RangeIterator ranges = new RangeIterator(command, keyspace, consistencyLevel);
        float resultsPerRange = StorageProxy.estimateResultsPerRange(command, keyspace);
        resultsPerRange = (float)((double)resultsPerRange - (double)resultsPerRange * 0.1);
        int concurrencyFactor = (double)resultsPerRange == 0.0 ? 1 : Math.max(1, Math.min(ranges.rangeCount(), (int)Math.ceil((float)command.limits().count() / resultsPerRange)));
        logger.trace("Estimated result rows per range: {}; requested rows: {}, ranges.size(): {}; concurrent range requests: {}", new Object[]{Float.valueOf(resultsPerRange), command.limits().count(), ranges.rangeCount(), concurrencyFactor});
        Tracing.trace("Submitting range requests on {} ranges with a concurrency of {} ({} rows per range expected)", ranges.rangeCount(), concurrencyFactor, Float.valueOf(resultsPerRange));
        return command.limits().filter(command.postReconciliationProcessing(new RangeCommandIterator(ranges, command, concurrencyFactor, keyspace, consistencyLevel, queryStartNanoTime)), command.nowInSec(), command.selectsFullPartition(), command.metadata().enforceStrictLiveness());
    }

    @Override
    public Map<String, List<String>> getSchemaVersions() {
        return StorageProxy.describeSchemaVersions(false);
    }

    @Override
    public Map<String, List<String>> getSchemaVersionsWithPort() {
        return StorageProxy.describeSchemaVersions(true);
    }

    public static Map<String, List<String>> describeSchemaVersions(boolean withPort) {
        String myVersion = Schema.instance.getVersion().toString();
        ConcurrentHashMap versions = new ConcurrentHashMap();
        Set<InetAddressAndPort> liveHosts = Gossiper.instance.getLiveMembers();
        CountDownLatch latch = new CountDownLatch(liveHosts.size());
        RequestCallback cb = message -> {
            versions.put(message.from(), message.payload);
            latch.countDown();
        };
        Message<NoPayload> message2 = Message.out(Verb.SCHEMA_VERSION_REQ, NoPayload.noPayload);
        for (InetAddressAndPort endpoint : liveHosts) {
            MessagingService.instance().sendWithCallback(message2, endpoint, cb);
        }
        try {
            latch.await(DatabaseDescriptor.getRpcTimeout(TimeUnit.NANOSECONDS), TimeUnit.NANOSECONDS);
        }
        catch (InterruptedException ex) {
            throw new AssertionError((Object)"This latch shouldn't have been interrupted.");
        }
        HashMap<String, List<String>> results = new HashMap<String, List<String>>();
        Iterable allHosts = Iterables.concat(Gossiper.instance.getLiveMembers(), Gossiper.instance.getUnreachableMembers());
        for (InetAddressAndPort inetAddressAndPort : allHosts) {
            UUID version = (UUID)versions.get(inetAddressAndPort);
            String stringVersion = version == null ? UNREACHABLE : version.toString();
            ArrayList<String> hosts = (ArrayList<String>)results.get(stringVersion);
            if (hosts == null) {
                hosts = new ArrayList<String>();
                results.put(stringVersion, hosts);
            }
            hosts.add(inetAddressAndPort.getHostAddress(withPort));
        }
        if (results.get(UNREACHABLE) != null) {
            logger.debug("Hosts not in agreement. Didn't get a response from everybody: {}", (Object)StringUtils.join((Iterable)((Iterable)results.get(UNREACHABLE)), (String)","));
        }
        for (Map.Entry entry : results.entrySet()) {
            if (((String)entry.getKey()).equals(UNREACHABLE) || ((String)entry.getKey()).equals(myVersion)) continue;
            for (String host : (List)entry.getValue()) {
                logger.debug("{} disagrees ({})", (Object)host, entry.getKey());
            }
        }
        if (results.size() == 1) {
            logger.debug("Schemas are in agreement.");
        }
        return results;
    }

    static <T extends RingPosition<T>> List<AbstractBounds<T>> getRestrictedRanges(AbstractBounds<T> queryRange) {
        Token upperBoundToken;
        Object upperBound;
        if (queryRange instanceof Bounds && queryRange.left.equals(queryRange.right) && !queryRange.left.isMinimum()) {
            return Collections.singletonList(queryRange);
        }
        TokenMetadata tokenMetadata = StorageService.instance.getTokenMetadata();
        ArrayList<AbstractBounds<T>> ranges = new ArrayList<AbstractBounds<T>>();
        Iterator<Token> ringIter = TokenMetadata.ringIterator(tokenMetadata.sortedTokens(), queryRange.left.getToken(), true);
        AbstractBounds remainder = queryRange;
        while (ringIter.hasNext() && (remainder.left.equals(upperBound = (upperBoundToken = ringIter.next()).upperBound(queryRange.left.getClass())) || remainder.contains(upperBound))) {
            Pair<AbstractBounds<T>, AbstractBounds<T>> splits = remainder.split(upperBound);
            if (splits == null) continue;
            ranges.add((AbstractBounds<T>)splits.left);
            remainder = (AbstractBounds)splits.right;
        }
        ranges.add(remainder);
        return ranges;
    }

    @Override
    public boolean getHintedHandoffEnabled() {
        return DatabaseDescriptor.hintedHandoffEnabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setHintedHandoffEnabled(boolean b) {
        StorageService storageService = StorageService.instance;
        synchronized (storageService) {
            if (b) {
                StorageService.instance.checkServiceAllowedToStart("hinted handoff");
            }
            DatabaseDescriptor.setHintedHandoffEnabled(b);
        }
    }

    @Override
    public void enableHintsForDC(String dc) {
        DatabaseDescriptor.enableHintsForDC(dc);
    }

    @Override
    public void disableHintsForDC(String dc) {
        DatabaseDescriptor.disableHintsForDC(dc);
    }

    @Override
    public Set<String> getHintedHandoffDisabledDCs() {
        return DatabaseDescriptor.hintedHandoffDisabledDCs();
    }

    @Override
    public int getMaxHintWindow() {
        return DatabaseDescriptor.getMaxHintWindow();
    }

    @Override
    public void setMaxHintWindow(int ms) {
        DatabaseDescriptor.setMaxHintWindow(ms);
    }

    public static boolean shouldHint(Replica replica) {
        boolean hintWindowExpired;
        String dc;
        if (!DatabaseDescriptor.hintedHandoffEnabled()) {
            return false;
        }
        if (replica.isTransient() || replica.isSelf()) {
            return false;
        }
        Set<String> disabledDCs = DatabaseDescriptor.hintedHandoffDisabledDCs();
        if (!disabledDCs.isEmpty() && disabledDCs.contains(dc = DatabaseDescriptor.getEndpointSnitch().getDatacenter(replica))) {
            Tracing.trace("Not hinting {} since its data center {} has been disabled {}", replica, dc, disabledDCs);
            return false;
        }
        boolean bl = hintWindowExpired = Gossiper.instance.getEndpointDowntime(replica.endpoint()) > (long)DatabaseDescriptor.getMaxHintWindow();
        if (hintWindowExpired) {
            HintsService.instance.metrics.incrPastWindow(replica.endpoint());
            Tracing.trace("Not hinting {} which has been down {} ms", (Object)replica, (Object)Gossiper.instance.getEndpointDowntime(replica.endpoint()));
        }
        return !hintWindowExpired;
    }

    public static void truncateBlocking(String keyspace, String cfname) throws UnavailableException, TimeoutException {
        logger.debug("Starting a blocking truncate operation on keyspace {}, CF {}", (Object)keyspace, (Object)cfname);
        if (StorageProxy.isAnyStorageHostDown()) {
            logger.info("Cannot perform truncate, some hosts are down");
            int liveMembers = Gossiper.instance.getLiveMembers().size();
            throw UnavailableException.create(ConsistencyLevel.ALL, liveMembers + Gossiper.instance.getUnreachableMembers().size(), liveMembers);
        }
        Set<InetAddressAndPort> allEndpoints = StorageService.instance.getLiveRingMembers(true);
        int blockFor = allEndpoints.size();
        TruncateResponseHandler responseHandler = new TruncateResponseHandler(blockFor);
        Tracing.trace("Enqueuing truncate messages to hosts {}", allEndpoints);
        Message<TruncateRequest> message = Message.out(Verb.TRUNCATE_REQ, new TruncateRequest(keyspace, cfname));
        for (InetAddressAndPort endpoint : allEndpoints) {
            MessagingService.instance().sendWithCallback(message, endpoint, responseHandler);
        }
        try {
            responseHandler.get();
        }
        catch (TimeoutException e) {
            Tracing.trace("Timed out");
            throw e;
        }
    }

    private static boolean isAnyStorageHostDown() {
        return !Gossiper.instance.getUnreachableTokenOwners().isEmpty();
    }

    @Override
    public long getTotalHints() {
        return StorageMetrics.totalHints.getCount();
    }

    @Override
    public int getMaxHintsInProgress() {
        return maxHintsInProgress;
    }

    @Override
    public void setMaxHintsInProgress(int qs) {
        maxHintsInProgress = qs;
    }

    @Override
    public int getHintsInProgress() {
        return (int)StorageMetrics.totalHintsInProgress.getCount();
    }

    public void verifyNoHintsInProgress() {
        if (this.getHintsInProgress() > 0) {
            logger.warn("Some hints were not written before shutdown.  This is not supposed to happen.  You should (a) run repair, and (b) file a bug report");
        }
    }

    private static AtomicInteger getHintsInProgressFor(InetAddressAndPort destination) {
        try {
            return (AtomicInteger)hintsInProgress.load((Object)destination);
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
    }

    public static Future<Void> submitHint(Mutation mutation, Replica target, AbstractWriteResponseHandler<IMutation> responseHandler) {
        return StorageProxy.submitHint(mutation, EndpointsForToken.of((Token)target.range().right, target), responseHandler);
    }

    public static Future<Void> submitHint(final Mutation mutation, EndpointsForToken targets, final AbstractWriteResponseHandler<IMutation> responseHandler) {
        Replicas.assertFull(targets);
        HintRunnable runnable = new HintRunnable(targets){

            @Override
            public void runMayThrow() {
                HashSet<InetAddressAndPort> validTargets = new HashSet<InetAddressAndPort>(this.targets.size());
                HashSet<UUID> hostIds = new HashSet<UUID>(this.targets.size());
                for (InetAddressAndPort target : this.targets.endpoints()) {
                    UUID hostId = StorageService.instance.getHostIdForEndpoint(target);
                    if (hostId != null) {
                        hostIds.add(hostId);
                        validTargets.add(target);
                        continue;
                    }
                    logger.debug("Discarding hint for endpoint not part of ring: {}", (Object)target);
                }
                logger.trace("Adding hints for {}", validTargets);
                HintsService.instance.write(hostIds, Hint.create(mutation, System.currentTimeMillis()));
                validTargets.forEach(HintsService.instance.metrics::incrCreatedHints);
                if (responseHandler != null && responseHandler.replicaPlan.consistencyLevel() == ConsistencyLevel.ANY) {
                    responseHandler.onResponse(null);
                }
            }
        };
        return StorageProxy.submitHint(runnable);
    }

    private static Future<Void> submitHint(HintRunnable runnable) {
        StorageMetrics.totalHintsInProgress.inc((long)runnable.targets.size());
        for (Replica target : runnable.targets) {
            StorageProxy.getHintsInProgressFor(target.endpoint()).incrementAndGet();
        }
        return StageManager.getStage(Stage.MUTATION).submit(runnable);
    }

    @Override
    public Long getRpcTimeout() {
        return DatabaseDescriptor.getRpcTimeout(TimeUnit.MILLISECONDS);
    }

    @Override
    public void setRpcTimeout(Long timeoutInMillis) {
        DatabaseDescriptor.setRpcTimeout(timeoutInMillis);
    }

    @Override
    public Long getReadRpcTimeout() {
        return DatabaseDescriptor.getReadRpcTimeout(TimeUnit.MILLISECONDS);
    }

    @Override
    public void setReadRpcTimeout(Long timeoutInMillis) {
        DatabaseDescriptor.setReadRpcTimeout(timeoutInMillis);
    }

    @Override
    public Long getWriteRpcTimeout() {
        return DatabaseDescriptor.getWriteRpcTimeout(TimeUnit.MILLISECONDS);
    }

    @Override
    public void setWriteRpcTimeout(Long timeoutInMillis) {
        DatabaseDescriptor.setWriteRpcTimeout(timeoutInMillis);
    }

    @Override
    public Long getCounterWriteRpcTimeout() {
        return DatabaseDescriptor.getCounterWriteRpcTimeout(TimeUnit.MILLISECONDS);
    }

    @Override
    public void setCounterWriteRpcTimeout(Long timeoutInMillis) {
        DatabaseDescriptor.setCounterWriteRpcTimeout(timeoutInMillis);
    }

    @Override
    public Long getCasContentionTimeout() {
        return DatabaseDescriptor.getCasContentionTimeout(TimeUnit.MILLISECONDS);
    }

    @Override
    public void setCasContentionTimeout(Long timeoutInMillis) {
        DatabaseDescriptor.setCasContentionTimeout(timeoutInMillis);
    }

    @Override
    public Long getRangeRpcTimeout() {
        return DatabaseDescriptor.getRangeRpcTimeout(TimeUnit.MILLISECONDS);
    }

    @Override
    public void setRangeRpcTimeout(Long timeoutInMillis) {
        DatabaseDescriptor.setRangeRpcTimeout(timeoutInMillis);
    }

    @Override
    public Long getTruncateRpcTimeout() {
        return DatabaseDescriptor.getTruncateRpcTimeout(TimeUnit.MILLISECONDS);
    }

    @Override
    public void setTruncateRpcTimeout(Long timeoutInMillis) {
        DatabaseDescriptor.setTruncateRpcTimeout(timeoutInMillis);
    }

    @Override
    public Long getNativeTransportMaxConcurrentConnections() {
        return DatabaseDescriptor.getNativeTransportMaxConcurrentConnections();
    }

    @Override
    public void setNativeTransportMaxConcurrentConnections(Long nativeTransportMaxConcurrentConnections) {
        DatabaseDescriptor.setNativeTransportMaxConcurrentConnections(nativeTransportMaxConcurrentConnections);
    }

    public Long getNativeTransportMaxConcurrentConnectionsPerIp() {
        return DatabaseDescriptor.getNativeTransportMaxConcurrentConnectionsPerIp();
    }

    public void setNativeTransportMaxConcurrentConnectionsPerIp(Long nativeTransportMaxConcurrentConnections) {
        DatabaseDescriptor.setNativeTransportMaxConcurrentConnectionsPerIp(nativeTransportMaxConcurrentConnections);
    }

    @Override
    public void reloadTriggerClasses() {
        TriggerExecutor.instance.reloadClasses();
    }

    @Override
    public long getReadRepairAttempted() {
        return ReadRepairMetrics.attempted.getCount();
    }

    @Override
    public long getReadRepairRepairedBlocking() {
        return ReadRepairMetrics.repairedBlocking.getCount();
    }

    @Override
    public long getReadRepairRepairedBackground() {
        return ReadRepairMetrics.repairedBackground.getCount();
    }

    @Override
    public int getNumberOfTables() {
        return Schema.instance.getNumberOfTables();
    }

    @Override
    public String getIdealConsistencyLevel() {
        return DatabaseDescriptor.getIdealConsistencyLevel().toString();
    }

    @Override
    public String setIdealConsistencyLevel(String cl) {
        ConsistencyLevel original = DatabaseDescriptor.getIdealConsistencyLevel();
        ConsistencyLevel newCL = ConsistencyLevel.valueOf(cl.trim().toUpperCase());
        DatabaseDescriptor.setIdealConsistencyLevel(newCL);
        return String.format("Updating ideal consistency level new value: %s old value %s", new Object[]{newCL, original.toString()});
    }

    @Override
    public void configureFullQueryLogger(String path, String rollCycle, Boolean blocking, int maxQueueWeight, long maxLogSize, String archiveCommand, int maxArchiveRetries) {
        FullQueryLoggerOptions fqlOptions = DatabaseDescriptor.getFullQueryLogOptions();
        path = path != null ? path : fqlOptions.log_dir;
        rollCycle = rollCycle != null ? rollCycle : fqlOptions.roll_cycle;
        blocking = blocking != null ? blocking : fqlOptions.block;
        maxQueueWeight = maxQueueWeight != Integer.MIN_VALUE ? maxQueueWeight : fqlOptions.max_queue_weight;
        maxLogSize = maxLogSize != Long.MIN_VALUE ? maxLogSize : fqlOptions.max_log_size;
        archiveCommand = archiveCommand != null ? archiveCommand : fqlOptions.archive_command;
        maxArchiveRetries = maxArchiveRetries != Integer.MIN_VALUE ? maxArchiveRetries : fqlOptions.max_archive_retries;
        Preconditions.checkNotNull((Object)path, (Object)"cassandra.yaml did not set log_dir and not set as parameter");
        AuditLogManager.getInstance().configureFQL(Paths.get(path, new String[0]), rollCycle, blocking, maxQueueWeight, maxLogSize, archiveCommand, maxArchiveRetries);
    }

    @Override
    public void resetFullQueryLogger() {
        AuditLogManager.getInstance().resetFQL(DatabaseDescriptor.getFullQueryLogOptions().log_dir);
    }

    @Override
    public void stopFullQueryLogger() {
        AuditLogManager.getInstance().disableFQL();
    }

    @Override
    @Deprecated
    public int getOtcBacklogExpirationInterval() {
        return 0;
    }

    @Override
    @Deprecated
    public void setOtcBacklogExpirationInterval(int intervalInMillis) {
    }

    @Override
    public void enableRepairedDataTrackingForRangeReads() {
        DatabaseDescriptor.setRepairedDataTrackingForRangeReadsEnabled(true);
    }

    @Override
    public void disableRepairedDataTrackingForRangeReads() {
        DatabaseDescriptor.setRepairedDataTrackingForRangeReadsEnabled(false);
    }

    @Override
    public boolean getRepairedDataTrackingEnabledForRangeReads() {
        return DatabaseDescriptor.getRepairedDataTrackingForRangeReadsEnabled();
    }

    @Override
    public void enableRepairedDataTrackingForPartitionReads() {
        DatabaseDescriptor.setRepairedDataTrackingForPartitionReadsEnabled(true);
    }

    @Override
    public void disableRepairedDataTrackingForPartitionReads() {
        DatabaseDescriptor.setRepairedDataTrackingForPartitionReadsEnabled(false);
    }

    @Override
    public boolean getRepairedDataTrackingEnabledForPartitionReads() {
        return DatabaseDescriptor.getRepairedDataTrackingForPartitionReadsEnabled();
    }

    @Override
    public void enableReportingUnconfirmedRepairedDataMismatches() {
        DatabaseDescriptor.reportUnconfirmedRepairedDataMismatches(true);
    }

    @Override
    public void disableReportingUnconfirmedRepairedDataMismatches() {
        DatabaseDescriptor.reportUnconfirmedRepairedDataMismatches(false);
    }

    @Override
    public boolean getReportingUnconfirmedRepairedDataMismatchesEnabled() {
        return DatabaseDescriptor.reportUnconfirmedRepairedDataMismatches();
    }

    static {
        instance = new StorageProxy();
        maxHintsInProgress = 128 * FBUtilities.getAvailableProcessors();
        hintsInProgress = new CacheLoader<InetAddressAndPort, AtomicInteger>(){

            public AtomicInteger load(InetAddressAndPort inetAddress) {
                return new AtomicInteger(0);
            }
        };
        readMetrics = new ClientRequestMetrics("Read");
        rangeMetrics = new ClientRequestMetrics("RangeSlice");
        writeMetrics = new ClientWriteRequestMetrics("Write");
        casWriteMetrics = new CASClientWriteRequestMetrics("CASWrite");
        casReadMetrics = new CASClientRequestMetrics("CASRead");
        viewWriteMetrics = new ViewWriteMetrics("ViewWrite");
        readMetricsMap = new EnumMap<ConsistencyLevel, ClientRequestMetrics>(ConsistencyLevel.class);
        writeMetricsMap = new EnumMap<ConsistencyLevel, ClientWriteRequestMetrics>(ConsistencyLevel.class);
        MBeanWrapper.instance.registerMBean((Object)instance, MBEAN_NAME);
        HintsService.instance.registerMBean();
        HintedHandOffManager.instance.registerMBean();
        standardWritePerformer = (mutation, targets, responseHandler, localDataCenter) -> {
            assert (mutation instanceof Mutation);
            StorageProxy.sendToHintedReplicas((Mutation)mutation, targets, responseHandler, localDataCenter, Stage.MUTATION);
        };
        counterWritePerformer = (mutation, targets, responseHandler, localDataCenter) -> {
            EndpointsForToken selected = (EndpointsForToken)((EndpointsForToken)targets.contacts()).withoutSelf();
            Replicas.temporaryAssertFull(selected);
            StorageProxy.counterWriteTask(mutation, targets.withContact(selected), responseHandler, localDataCenter).run();
        };
        counterWriteOnCoordinatorPerformer = (mutation, targets, responseHandler, localDataCenter) -> {
            EndpointsForToken selected = (EndpointsForToken)((EndpointsForToken)targets.contacts()).withoutSelf();
            Replicas.temporaryAssertFull(selected);
            StageManager.getStage(Stage.COUNTER_MUTATION).execute(StorageProxy.counterWriteTask(mutation, targets.withContact(selected), responseHandler, localDataCenter));
        };
        for (ConsistencyLevel level : ConsistencyLevel.values()) {
            readMetricsMap.put(level, new ClientRequestMetrics("Read-" + level.name()));
            writeMetricsMap.put(level, new ClientWriteRequestMetrics("Write-" + level.name()));
        }
        ReadRepairMetrics.init();
    }

    static class PaxosBallotAndContention {
        final UUID ballot;
        final int contentions;

        PaxosBallotAndContention(UUID ballot, int contentions) {
            this.ballot = ballot;
            this.contentions = contentions;
        }

        public final int hashCode() {
            int hashCode = 31 + (this.ballot == null ? 0 : this.ballot.hashCode());
            return 31 * hashCode * this.contentions;
        }

        public final boolean equals(Object o) {
            if (!(o instanceof PaxosBallotAndContention)) {
                return false;
            }
            PaxosBallotAndContention that = (PaxosBallotAndContention)o;
            return Objects.equals(this.ballot, that.ballot) && this.contentions == that.contentions;
        }
    }

    private static abstract class HintRunnable
    implements Runnable {
        public final EndpointsForToken targets;

        protected HintRunnable(EndpointsForToken targets) {
            this.targets = targets;
        }

        @Override
        public void run() {
            try {
                this.runMayThrow();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                StorageMetrics.totalHintsInProgress.dec((long)this.targets.size());
                for (InetAddressAndPort target : this.targets.endpoints()) {
                    StorageProxy.getHintsInProgressFor(target).decrementAndGet();
                }
            }
        }

        protected abstract void runMayThrow() throws Exception;
    }

    private static abstract class LocalMutationRunnable
    implements Runnable {
        private final long approxCreationTimeNanos = MonotonicClock.approxTime.now();
        private final Replica localReplica;

        LocalMutationRunnable(Replica localReplica) {
            this.localReplica = localReplica;
        }

        @Override
        public final void run() {
            long expirationTimeNanos;
            Verb verb = this.verb();
            long nowNanos = MonotonicClock.approxTime.now();
            if (nowNanos > (expirationTimeNanos = verb.expiresAtNanos(this.approxCreationTimeNanos))) {
                long timeTakenNanos = nowNanos - this.approxCreationTimeNanos;
                MessagingService.instance().metrics.recordSelfDroppedMessage(Verb.MUTATION_REQ, timeTakenNanos, TimeUnit.NANOSECONDS);
                HintRunnable runnable = new HintRunnable(EndpointsForToken.of((Token)this.localReplica.range().right, this.localReplica)){

                    @Override
                    protected void runMayThrow() throws Exception {
                        this.runMayThrow();
                    }
                };
                StorageProxy.submitHint(runnable);
                return;
            }
            try {
                this.runMayThrow();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        protected abstract Verb verb();

        protected abstract void runMayThrow() throws Exception;
    }

    private static abstract class DroppableRunnable
    implements Runnable {
        final long approxCreationTimeNanos = MonotonicClock.approxTime.now();
        final Verb verb;

        public DroppableRunnable(Verb verb) {
            this.verb = verb;
        }

        @Override
        public final void run() {
            long expirationTimeNanos;
            long approxCurrentTimeNanos = MonotonicClock.approxTime.now();
            if (approxCurrentTimeNanos > (expirationTimeNanos = this.verb.expiresAtNanos(this.approxCreationTimeNanos))) {
                long timeTakenNanos = approxCurrentTimeNanos - this.approxCreationTimeNanos;
                MessagingService.instance().metrics.recordSelfDroppedMessage(this.verb, timeTakenNanos, TimeUnit.NANOSECONDS);
                return;
            }
            try {
                this.runMayThrow();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        protected abstract void runMayThrow() throws Exception;
    }

    private static class ViewWriteMetricsWrapped
    extends BatchlogResponseHandler<IMutation> {
        public ViewWriteMetricsWrapped(AbstractWriteResponseHandler<IMutation> writeHandler, int i, BatchlogResponseHandler.BatchlogCleanup cleanup, long queryStartNanoTime) {
            super(writeHandler, i, cleanup, queryStartNanoTime);
            viewWriteMetrics.viewReplicasAttempted.inc((long)this.candidateReplicaCount());
        }

        @Override
        public void onResponse(Message<IMutation> msg) {
            super.onResponse(msg);
            viewWriteMetrics.viewReplicasSuccess.inc();
        }
    }

    public static interface WritePerformer {
        public void apply(IMutation var1, ReplicaPlan.ForTokenWrite var2, AbstractWriteResponseHandler<IMutation> var3, String var4) throws OverloadedException;
    }

    private static class RangeCommandIterator
    extends AbstractIterator<RowIterator>
    implements PartitionIterator {
        private final Iterator<ReplicaPlan.ForRangeRead> ranges;
        private final int totalRangeCount;
        private final PartitionRangeReadCommand command;
        private final boolean enforceStrictLiveness;
        private final long startTime;
        private final long queryStartNanoTime;
        private DataLimits.Counter counter;
        private PartitionIterator sentQueryIterator;
        private int concurrencyFactor;
        private int liveReturned;
        private int rangesQueried;

        public RangeCommandIterator(RangeIterator ranges, PartitionRangeReadCommand command, int concurrencyFactor, Keyspace keyspace, ConsistencyLevel consistency, long queryStartNanoTime) {
            this.command = command;
            this.concurrencyFactor = concurrencyFactor;
            this.startTime = System.nanoTime();
            this.ranges = new RangeMerger(ranges, keyspace, consistency);
            this.totalRangeCount = ranges.rangeCount();
            this.queryStartNanoTime = queryStartNanoTime;
            this.enforceStrictLiveness = command.metadata().enforceStrictLiveness();
        }

        @Override
        public RowIterator computeNext() {
            try {
                while (this.sentQueryIterator == null || !this.sentQueryIterator.hasNext()) {
                    if (!this.ranges.hasNext()) {
                        return (RowIterator)this.endOfData();
                    }
                    if (this.sentQueryIterator != null) {
                        this.liveReturned += this.counter.counted();
                        this.sentQueryIterator.close();
                        this.updateConcurrencyFactor();
                    }
                    this.sentQueryIterator = this.sendNextRequests();
                }
                return (RowIterator)this.sentQueryIterator.next();
            }
            catch (UnavailableException e) {
                rangeMetrics.unavailables.mark();
                throw e;
            }
            catch (ReadTimeoutException e) {
                rangeMetrics.timeouts.mark();
                throw e;
            }
            catch (ReadFailureException e) {
                rangeMetrics.failures.mark();
                throw e;
            }
        }

        private void updateConcurrencyFactor() {
            if (this.liveReturned == 0) {
                this.concurrencyFactor = this.totalRangeCount - this.rangesQueried;
                return;
            }
            int remainingRows = this.command.limits().count() - this.liveReturned;
            float rowsPerRange = (float)this.liveReturned / (float)this.rangesQueried;
            this.concurrencyFactor = Math.max(1, Math.min(this.totalRangeCount - this.rangesQueried, Math.round((float)remainingRows / rowsPerRange)));
            logger.trace("Didn't get enough response rows; actual rows per range: {}; remaining rows: {}, new concurrent requests: {}", new Object[]{Float.valueOf(rowsPerRange), remainingRows, this.concurrencyFactor});
        }

        private SingleRangeResponse query(ReplicaPlan.ForRangeRead replicaPlan, boolean isFirst) {
            PartitionRangeReadCommand rangeCommand = this.command.forSubRange(replicaPlan.range(), isFirst);
            if (DatabaseDescriptor.getRepairedDataTrackingForRangeReadsEnabled() && ((EndpointsForRange)((EndpointsForRange)replicaPlan.contacts()).filter(Replica::isFull)).size() > 1) {
                this.command.trackRepairedStatus();
                rangeCommand.trackRepairedStatus();
            }
            ReplicaPlan.SharedForRangeRead sharedReplicaPlan = ReplicaPlan.shared(replicaPlan);
            ReadRepair<EndpointsForRange, ReplicaPlan.ForRangeRead> readRepair = ReadRepair.create(this.command, sharedReplicaPlan, this.queryStartNanoTime);
            DataResolver<EndpointsForRange, ReplicaPlan.ForRangeRead> resolver = new DataResolver<EndpointsForRange, ReplicaPlan.ForRangeRead>(rangeCommand, sharedReplicaPlan, readRepair, this.queryStartNanoTime);
            ReadCallback<EndpointsForRange, ReplicaPlan.ForRangeRead> handler = new ReadCallback<EndpointsForRange, ReplicaPlan.ForRangeRead>(resolver, rangeCommand, sharedReplicaPlan, this.queryStartNanoTime);
            if (((EndpointsForRange)replicaPlan.contacts()).size() == 1 && ((EndpointsForRange)replicaPlan.contacts()).get(0).isSelf()) {
                StageManager.getStage(Stage.READ).execute(new LocalReadRunnable(rangeCommand, handler));
            } else {
                for (Replica replica : (EndpointsForRange)replicaPlan.contacts()) {
                    Tracing.trace("Enqueuing request to {}", (Object)replica);
                    PartitionRangeReadCommand command = replica.isFull() ? rangeCommand : rangeCommand.copyAsTransientQuery(replica);
                    Message<ReadCommand> message = command.createMessage(command.isTrackingRepairedStatus() && replica.isFull());
                    MessagingService.instance().sendWithCallback(message, replica.endpoint(), handler);
                }
            }
            return new SingleRangeResponse(resolver, handler, readRepair);
        }

        private PartitionIterator sendNextRequests() {
            ArrayList<SingleRangeResponse> concurrentQueries = new ArrayList<SingleRangeResponse>(this.concurrencyFactor);
            ArrayList<ReadRepair> readRepairs = new ArrayList<ReadRepair>(this.concurrencyFactor);
            try {
                for (int i = 0; i < this.concurrencyFactor && this.ranges.hasNext(); ++i) {
                    SingleRangeResponse response = this.query(this.ranges.next(), i == 0);
                    concurrentQueries.add(response);
                    readRepairs.add(response.readRepair);
                    ++this.rangesQueried;
                }
            }
            catch (Throwable t) {
                for (PartitionIterator partitionIterator : concurrentQueries) {
                    partitionIterator.close();
                }
                throw t;
            }
            Tracing.trace("Submitted {} concurrent range requests", (Object)concurrentQueries.size());
            this.counter = DataLimits.NONE.newCounter(this.command.nowInSec(), true, this.command.selectsFullPartition(), this.enforceStrictLiveness);
            return this.counter.applyTo(StorageProxy.concatAndBlockOnRepair(concurrentQueries, readRepairs));
        }

        @Override
        public void close() {
            try {
                if (this.sentQueryIterator != null) {
                    this.sentQueryIterator.close();
                }
            }
            finally {
                long latency = System.nanoTime() - this.startTime;
                rangeMetrics.addNano(latency);
                Keyspace.openAndGetStore((TableMetadata)this.command.metadata()).metric.coordinatorScanLatency.update(latency, TimeUnit.NANOSECONDS);
            }
        }
    }

    private static class SingleRangeResponse
    extends AbstractIterator<RowIterator>
    implements PartitionIterator {
        private final DataResolver resolver;
        private final ReadCallback handler;
        private final ReadRepair readRepair;
        private PartitionIterator result;

        private SingleRangeResponse(DataResolver resolver, ReadCallback handler, ReadRepair readRepair) {
            this.resolver = resolver;
            this.handler = handler;
            this.readRepair = readRepair;
        }

        private void waitForResponse() throws ReadTimeoutException {
            if (this.result != null) {
                return;
            }
            this.handler.awaitResults();
            this.result = this.resolver.resolve();
        }

        @Override
        protected RowIterator computeNext() {
            this.waitForResponse();
            return this.result.hasNext() ? (RowIterator)this.result.next() : (RowIterator)this.endOfData();
        }

        @Override
        public void close() {
            if (this.result != null) {
                this.result.close();
            }
        }
    }

    private static class RangeMerger
    extends AbstractIterator<ReplicaPlan.ForRangeRead> {
        private final Keyspace keyspace;
        private final ConsistencyLevel consistency;
        private final PeekingIterator<ReplicaPlan.ForRangeRead> ranges;

        private RangeMerger(Iterator<ReplicaPlan.ForRangeRead> iterator, Keyspace keyspace, ConsistencyLevel consistency) {
            this.keyspace = keyspace;
            this.consistency = consistency;
            this.ranges = Iterators.peekingIterator(iterator);
        }

        @Override
        protected ReplicaPlan.ForRangeRead computeNext() {
            ReplicaPlan.ForRangeRead next;
            ReplicaPlan.ForRangeRead merged;
            if (!this.ranges.hasNext()) {
                return (ReplicaPlan.ForRangeRead)this.endOfData();
            }
            ReplicaPlan.ForRangeRead current = (ReplicaPlan.ForRangeRead)this.ranges.next();
            while (this.ranges.hasNext() && !((PartitionPosition)current.range().right).isMinimum() && (merged = ReplicaPlans.maybeMerge(this.keyspace, this.consistency, current, next = (ReplicaPlan.ForRangeRead)this.ranges.peek())) != null) {
                current = merged;
                this.ranges.next();
            }
            return current;
        }
    }

    private static class RangeIterator
    extends AbstractIterator<ReplicaPlan.ForRangeRead> {
        private final Keyspace keyspace;
        private final ConsistencyLevel consistency;
        private final Iterator<? extends AbstractBounds<PartitionPosition>> ranges;
        private final int rangeCount;

        public RangeIterator(PartitionRangeReadCommand command, Keyspace keyspace, ConsistencyLevel consistency) {
            this.keyspace = keyspace;
            this.consistency = consistency;
            List<AbstractBounds<PartitionPosition>> l = keyspace.getReplicationStrategy() instanceof LocalStrategy ? command.dataRange().keyRange().unwrap() : StorageProxy.getRestrictedRanges(command.dataRange().keyRange());
            this.ranges = l.iterator();
            this.rangeCount = l.size();
        }

        public int rangeCount() {
            return this.rangeCount;
        }

        @Override
        protected ReplicaPlan.ForRangeRead computeNext() {
            if (!this.ranges.hasNext()) {
                return (ReplicaPlan.ForRangeRead)this.endOfData();
            }
            return ReplicaPlans.forRangeRead(this.keyspace, this.consistency, this.ranges.next());
        }
    }

    public static class LocalReadRunnable
    extends DroppableRunnable {
        private final ReadCommand command;
        private final ReadCallback handler;

        public LocalReadRunnable(ReadCommand command, ReadCallback handler) {
            super(Verb.READ_REQ);
            this.command = command;
            this.handler = handler;
        }

        @Override
        protected void runMayThrow() {
            try {
                ReadResponse response;
                this.command.setMonitoringTime(this.approxCreationTimeNanos, false, this.verb.expiresAfterNanos(), DatabaseDescriptor.getSlowQueryTimeout(TimeUnit.NANOSECONDS));
                try (ReadExecutionController executionController = this.command.executionController();
                     UnfilteredPartitionIterator iterator = this.command.executeLocally(executionController);){
                    response = this.command.createResponse(iterator);
                }
                if (this.command.complete()) {
                    this.handler.response(response);
                } else {
                    MessagingService.instance().metrics.recordSelfDroppedMessage(this.verb, MonotonicClock.approxTime.now() - this.approxCreationTimeNanos, TimeUnit.NANOSECONDS);
                    this.handler.onFailure(FBUtilities.getBroadcastAddressAndPort(), RequestFailureReason.UNKNOWN);
                }
                MessagingService.instance().latencySubscribers.add(FBUtilities.getBroadcastAddressAndPort(), MonotonicClock.approxTime.now() - this.approxCreationTimeNanos, TimeUnit.NANOSECONDS);
            }
            catch (Throwable t) {
                if (t instanceof TombstoneOverwhelmingException) {
                    this.handler.onFailure(FBUtilities.getBroadcastAddressAndPort(), RequestFailureReason.READ_TOO_MANY_TOMBSTONES);
                    logger.error(t.getMessage());
                }
                this.handler.onFailure(FBUtilities.getBroadcastAddressAndPort(), RequestFailureReason.UNKNOWN);
                throw t;
            }
        }
    }

    private static class WriteResponseHandlerWrapper {
        final BatchlogResponseHandler<IMutation> handler;
        final Mutation mutation;

        WriteResponseHandlerWrapper(BatchlogResponseHandler<IMutation> handler, Mutation mutation) {
            this.handler = handler;
            this.mutation = mutation;
        }
    }
}

