/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service.reads.repair;

import com.codahale.metrics.Meter;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.Mutation;
import org.apache.cassandra.db.ReadCommand;
import org.apache.cassandra.db.partitions.UnfilteredPartitionIterators;
import org.apache.cassandra.exceptions.ReadTimeoutException;
import org.apache.cassandra.locator.Endpoints;
import org.apache.cassandra.locator.Replica;
import org.apache.cassandra.locator.ReplicaPlan;
import org.apache.cassandra.metrics.ReadRepairMetrics;
import org.apache.cassandra.service.reads.repair.AbstractReadRepair;
import org.apache.cassandra.service.reads.repair.BlockingPartitionRepair;
import org.apache.cassandra.service.reads.repair.PartitionIteratorMergeListener;
import org.apache.cassandra.tracing.Tracing;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockingReadRepair<E extends Endpoints<E>, P extends ReplicaPlan.ForRead<E>>
extends AbstractReadRepair<E, P> {
    private static final Logger logger = LoggerFactory.getLogger(BlockingReadRepair.class);
    protected final Queue<BlockingPartitionRepair> repairs = new ConcurrentLinkedQueue<BlockingPartitionRepair>();
    private final int blockFor;

    BlockingReadRepair(ReadCommand command, ReplicaPlan.Shared<E, P> replicaPlan, long queryStartNanoTime) {
        super(command, replicaPlan, queryStartNanoTime);
        this.blockFor = ((ReplicaPlan)this.replicaPlan()).consistencyLevel().blockFor(this.cfs.keyspace);
    }

    @Override
    public UnfilteredPartitionIterators.MergeListener getMergeListener(P replicaPlan) {
        return new PartitionIteratorMergeListener(replicaPlan, this.command, this);
    }

    @Override
    Meter getRepairMeter() {
        return ReadRepairMetrics.repairedBlocking;
    }

    @Override
    public void maybeSendAdditionalWrites() {
        for (BlockingPartitionRepair repair : this.repairs) {
            repair.maybeSendAdditionalWrites(this.cfs.additionalWriteLatencyNanos, TimeUnit.NANOSECONDS);
        }
    }

    @Override
    public void awaitWrites() {
        boolean timedOut = false;
        for (BlockingPartitionRepair repair : this.repairs) {
            if (repair.awaitRepairs(DatabaseDescriptor.getWriteRpcTimeout(TimeUnit.NANOSECONDS), TimeUnit.NANOSECONDS)) continue;
            timedOut = true;
        }
        if (timedOut) {
            int blockFor = ((ReplicaPlan.ForRead)this.replicaPlan()).blockFor();
            if (Tracing.isTracing()) {
                Tracing.trace("Timed out while read-repairing after receiving all {} data and digest responses", (Object)blockFor);
            } else {
                logger.debug("Timeout while read-repairing after receiving all {} data and digest responses", (Object)blockFor);
            }
            throw new ReadTimeoutException(((ReplicaPlan)this.replicaPlan()).consistencyLevel(), blockFor - 1, blockFor, true);
        }
    }

    @Override
    public void repairPartition(DecoratedKey partitionKey, Map<Replica, Mutation> mutations, P replicaPlan) {
        BlockingPartitionRepair blockingRepair = new BlockingPartitionRepair(partitionKey, mutations, this.blockFor, replicaPlan);
        blockingRepair.sendInitialRepairs();
        this.repairs.add(blockingRepair);
    }
}

