/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.streaming.async;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import net.jpountz.lz4.LZ4Compressor;
import net.jpountz.lz4.LZ4FastDecompressor;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.net.AsyncStreamingOutputPlus;

public class StreamCompressionSerializer {
    private final ByteBufAllocator allocator;
    private static final int HEADER_LENGTH = 8;

    public StreamCompressionSerializer(ByteBufAllocator allocator) {
        this.allocator = allocator;
    }

    public static AsyncStreamingOutputPlus.Write serialize(LZ4Compressor compressor, ByteBuffer in, int version) {
        assert (version == 12);
        return bufferSupplier -> {
            int uncompressedLength = in.remaining();
            int maxLength = compressor.maxCompressedLength(uncompressedLength);
            ByteBuffer out = bufferSupplier.get(maxLength);
            out.position(8);
            compressor.compress(in, out);
            int compressedLength = out.position() - 8;
            out.putInt(0, compressedLength);
            out.putInt(4, uncompressedLength);
            out.flip();
        };
    }

    public ByteBuf deserialize(LZ4FastDecompressor decompressor, DataInputPlus in, int version) throws IOException {
        int compressedLength = in.readInt();
        int uncompressedLength = in.readInt();
        ByteBuf compressed = null;
        ByteBuf uncompressed = null;
        try {
            ByteBuffer compressedNioBuffer;
            if (in instanceof ReadableByteChannel) {
                compressed = this.allocator.directBuffer(compressedLength);
                compressedNioBuffer = compressed.nioBuffer(0, compressedLength);
                int readLength = ((ReadableByteChannel)((Object)in)).read(compressedNioBuffer);
                assert (readLength == compressedNioBuffer.position());
                compressedNioBuffer.flip();
            } else {
                byte[] compressedBytes = new byte[compressedLength];
                in.readFully(compressedBytes);
                compressedNioBuffer = ByteBuffer.wrap(compressedBytes);
            }
            uncompressed = this.allocator.directBuffer(uncompressedLength);
            ByteBuffer uncompressedNioBuffer = uncompressed.nioBuffer(0, uncompressedLength);
            decompressor.decompress(compressedNioBuffer, uncompressedNioBuffer);
            uncompressed.writerIndex(uncompressedLength);
            ByteBuf byteBuf = uncompressed;
            return byteBuf;
        }
        catch (Exception e) {
            if (uncompressed != null) {
                uncompressed.release();
            }
            if (e instanceof IOException) {
                throw e;
            }
            throw new IOException(e);
        }
        finally {
            if (compressed != null) {
                compressed.release();
            }
        }
    }
}

