/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.streaming.messages;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputStreamPlus;
import org.apache.cassandra.streaming.StreamSession;
import org.apache.cassandra.streaming.StreamSummary;
import org.apache.cassandra.streaming.messages.StreamMessage;

public class PrepareSynAckMessage
extends StreamMessage {
    public static StreamMessage.Serializer<PrepareSynAckMessage> serializer = new StreamMessage.Serializer<PrepareSynAckMessage>(){

        @Override
        public void serialize(PrepareSynAckMessage message, DataOutputStreamPlus out, int version, StreamSession session) throws IOException {
            out.writeInt(message.summaries.size());
            for (StreamSummary summary : message.summaries) {
                StreamSummary.serializer.serialize(summary, out, version);
            }
        }

        @Override
        public PrepareSynAckMessage deserialize(DataInputPlus input, int version, StreamSession session) throws IOException {
            PrepareSynAckMessage message = new PrepareSynAckMessage();
            int numSummaries = input.readInt();
            for (int i = 0; i < numSummaries; ++i) {
                message.summaries.add((StreamSummary)StreamSummary.serializer.deserialize(input, version));
            }
            return message;
        }

        @Override
        public long serializedSize(PrepareSynAckMessage message, int version) {
            long size = 4L;
            for (StreamSummary summary : message.summaries) {
                size += StreamSummary.serializer.serializedSize(summary, version);
            }
            return size;
        }
    };
    public final Collection<StreamSummary> summaries = new ArrayList<StreamSummary>();

    public PrepareSynAckMessage() {
        super(StreamMessage.Type.PREPARE_SYNACK);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Prepare SYNACK (");
        int totalFile = 0;
        for (StreamSummary summary : this.summaries) {
            totalFile += summary.files;
        }
        sb.append(" ").append(totalFile).append(" files");
        sb.append('}');
        return sb.toString();
    }
}

