/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.tools.nodetool;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import io.airlift.airline.Arguments;
import io.airlift.airline.Command;
import io.airlift.airline.Option;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.cassandra.tools.NodeProbe;
import org.apache.cassandra.tools.NodeTool;

@Command(name="import", description="Import new SSTables to the system")
public class Import
extends NodeTool.NodeToolCmd {
    @Arguments(usage="<keyspace> <table> <directory> ...", description="The keyspace, table name and directories to import sstables from")
    private List<String> args = new ArrayList<String>();
    @Option(title="keep_level", name={"-l", "--keep-level"}, description="Keep the level on the new sstables")
    private boolean keepLevel = false;
    @Option(title="keep_repaired", name={"-r", "--keep-repaired"}, description="Keep any repaired information from the sstables")
    private boolean keepRepaired = false;
    @Option(title="no_verify_sstables", name={"-v", "--no-verify"}, description="Don't verify new sstables")
    private boolean noVerify = false;
    @Option(title="no_verify_tokens", name={"-t", "--no-tokens"}, description="Don't verify that all tokens in the new sstable are owned by the current node")
    private boolean noVerifyTokens = false;
    @Option(title="no_invalidate_caches", name={"-c", "--no-invalidate-caches"}, description="Don't invalidate the row cache when importing")
    private boolean noInvalidateCaches = false;
    @Option(title="quick", name={"-q", "--quick"}, description="Do a quick import without verifying sstables, clearing row cache or checking in which data directory to put the file")
    private boolean quick = false;
    @Option(title="extended_verify", name={"-e", "--extended-verify"}, description="Run an extended verify, verifying all values in the new sstables")
    private boolean extendedVerify = false;

    @Override
    public void execute(NodeProbe probe) {
        Preconditions.checkArgument((this.args.size() >= 3 ? 1 : 0) != 0, (Object)"import requires keyspace, table name and directories");
        if (this.quick) {
            System.out.println("Doing a quick import - skipping sstable verification and row cache invalidation");
            this.noVerifyTokens = true;
            this.noInvalidateCaches = true;
            this.noVerify = true;
            this.extendedVerify = false;
        }
        ArrayList srcPaths = Lists.newArrayList(this.args.subList(2, this.args.size()));
        List<String> failedDirs = probe.importNewSSTables(this.args.get(0), this.args.get(1), new HashSet<String>(srcPaths), !this.keepLevel, !this.keepRepaired, !this.noVerify, !this.noVerifyTokens, !this.noInvalidateCaches, this.extendedVerify);
        if (!failedDirs.isEmpty()) {
            System.err.println("Some directories failed to import, check server logs for details:");
            for (String directory : failedDirs) {
                System.err.println(directory);
            }
            System.exit(1);
        }
    }
}

