/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.tools.nodetool;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import io.airlift.airline.Command;
import io.airlift.airline.Option;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.service.ActiveRepairServiceMBean;
import org.apache.cassandra.tools.NodeProbe;
import org.apache.cassandra.tools.NodeTool;
import org.apache.cassandra.utils.FBUtilities;

@Command(name="repair_admin", description="list and fail incremental repair sessions")
public class RepairAdmin
extends NodeTool.NodeToolCmd {
    @Option(title="list", name={"-l", "--list"}, description="list repair sessions (default behavior)")
    private boolean list = false;
    @Option(title="all", name={"-a", "--all"}, description="include completed and failed sessions")
    private boolean all = false;
    @Option(title="cancel", name={"-x", "--cancel"}, description="cancel an incremental repair session")
    private String cancel = null;
    @Option(title="force", name={"-f", "--force"}, description="cancel repair session from a node other than the repair coordinator. Attempting to cancel FINALIZED or FAILED sessions is an error.")
    private boolean force = false;
    private static final List<String> header = Lists.newArrayList((Object[])new String[]{"id", "state", "last activity", "coordinator", "participants", "participants_wp"});

    private List<String> sessionValues(Map<String, String> session, int now) {
        int updated = Integer.parseInt(session.get("LAST_UPDATE"));
        return Lists.newArrayList((Object[])new String[]{session.get("SESSION_ID"), session.get("STATE"), Integer.toString(now - updated) + " (s)", session.get("COORDINATOR"), session.get("PARTICIPANTS"), session.get("PARTICIPANTS_WP")});
    }

    /*
     * WARNING - void declaration
     */
    private void listSessions(ActiveRepairServiceMBean repairServiceProxy) {
        Preconditions.checkArgument((this.cancel == null ? 1 : 0) != 0);
        Preconditions.checkArgument((!this.force ? 1 : 0) != 0, (Object)"-f/--force only valid for session cancel");
        List<Map<String, String>> sessions = repairServiceProxy.getSessions(this.all);
        if (sessions.isEmpty()) {
            System.out.println("no sessions");
        } else {
            void var7_11;
            ArrayList<List<String>> rows = new ArrayList<List<String>>();
            rows.add(header);
            int now = FBUtilities.nowInSeconds();
            for (Map<String, String> map : sessions) {
                rows.add(this.sessionValues(map, now));
            }
            int[] widths = new int[header.size()];
            for (List list : rows) {
                assert (list.size() == widths.length);
                for (int i = 0; i < widths.length; ++i) {
                    widths[i] = Math.max(widths[i], ((String)list.get(i)).length());
                }
            }
            ArrayList<String> arrayList = new ArrayList<String>(widths.length);
            boolean bl = false;
            while (var7_11 < widths.length) {
                arrayList.add("%-" + Integer.toString(widths[var7_11]) + "s");
                ++var7_11;
            }
            for (List list : rows) {
                ArrayList<String> formatted = new ArrayList<String>(list.size());
                for (int i = 0; i < widths.length; ++i) {
                    formatted.add(String.format((String)arrayList.get(i), list.get(i)));
                }
                System.out.println(Joiner.on((String)" | ").join(formatted));
            }
        }
    }

    private void cancelSession(ActiveRepairServiceMBean repairServiceProxy) {
        Preconditions.checkArgument((!this.list ? 1 : 0) != 0);
        Preconditions.checkArgument((!this.all ? 1 : 0) != 0, (Object)"-a/--all only valid for session list");
        repairServiceProxy.failSession(this.cancel, this.force);
    }

    @Override
    protected void execute(NodeProbe probe) {
        if (this.list && this.cancel != null) {
            throw new RuntimeException("Can either list, or cancel sessions, not both");
        }
        if (this.cancel != null) {
            this.cancelSession(probe.getRepairServiceProxy());
        } else {
            this.listSessions(probe.getRepairServiceProxy());
        }
    }
}

