/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.tracing;

import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.UUID;
import org.apache.cassandra.concurrent.Stage;
import org.apache.cassandra.concurrent.StageManager;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.tracing.ExpiredTraceState;
import org.apache.cassandra.tracing.TraceKeyspace;
import org.apache.cassandra.tracing.TraceState;
import org.apache.cassandra.tracing.TraceStateImpl;
import org.apache.cassandra.tracing.Tracing;
import org.apache.cassandra.utils.WrappedRunnable;

class TracingImpl
extends Tracing {
    TracingImpl() {
    }

    @Override
    public void stopSessionImpl() {
        TraceStateImpl state = this.getStateImpl();
        if (state == null) {
            return;
        }
        int elapsed = state.elapsed();
        ByteBuffer sessionId = state.sessionIdBytes;
        int ttl = state.ttl;
        state.executeMutation(TraceKeyspace.makeStopSessionMutation(sessionId, elapsed, ttl));
    }

    @Override
    public TraceState begin(String request, InetAddress client, Map<String, String> parameters) {
        assert (TracingImpl.isTracing());
        TraceStateImpl state = this.getStateImpl();
        assert (state != null);
        long startedAt = System.currentTimeMillis();
        ByteBuffer sessionId = state.sessionIdBytes;
        String command = state.traceType.toString();
        int ttl = state.ttl;
        state.executeMutation(TraceKeyspace.makeStartSessionMutation(sessionId, client, parameters, request, startedAt, command, ttl));
        return state;
    }

    private TraceStateImpl getStateImpl() {
        TraceState state = this.get();
        if (state == null) {
            return null;
        }
        if (state instanceof ExpiredTraceState) {
            ExpiredTraceState expiredTraceState = (ExpiredTraceState)state;
            state = expiredTraceState.getDelegate();
        }
        if (state instanceof TraceStateImpl) {
            return (TraceStateImpl)state;
        }
        assert (false) : "TracingImpl states should be of type TraceStateImpl";
        return null;
    }

    @Override
    protected TraceState newTraceState(InetAddressAndPort coordinator, UUID sessionId, Tracing.TraceType traceType) {
        return new TraceStateImpl(coordinator, sessionId, traceType);
    }

    @Override
    public void trace(final ByteBuffer sessionId, final String message, final int ttl) {
        final String threadName = Thread.currentThread().getName();
        StageManager.getStage(Stage.TRACING).execute(new WrappedRunnable(){

            @Override
            public void runMayThrow() {
                TraceStateImpl.mutateWithCatch(TraceKeyspace.makeEventMutation(sessionId, message, -1, threadName, ttl));
            }
        });
    }
}

