/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.transport;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.utils.NoSpamLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
final class ConnectionLimitHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger logger = LoggerFactory.getLogger(ConnectionLimitHandler.class);
    private static final NoSpamLogger noSpamLogger = NoSpamLogger.getLogger(logger, 1L, TimeUnit.MINUTES);
    private final ConcurrentMap<InetAddress, AtomicLong> connectionsPerClient = new ConcurrentHashMap<InetAddress, AtomicLong>();
    private final AtomicLong counter = new AtomicLong(0L);

    ConnectionLimitHandler() {
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        long count = this.counter.incrementAndGet();
        long limit = DatabaseDescriptor.getNativeTransportMaxConcurrentConnections();
        if (limit < 0L) {
            limit = Long.MAX_VALUE;
        }
        if (count > limit) {
            noSpamLogger.warn("Exceeded maximum native connection limit of {} by using {} connections", limit, count);
            ctx.close();
        } else {
            long perIpLimit = DatabaseDescriptor.getNativeTransportMaxConcurrentConnectionsPerIp();
            if (perIpLimit > 0L) {
                AtomicLong old;
                InetAddress address = ((InetSocketAddress)ctx.channel().remoteAddress()).getAddress();
                AtomicLong perIpCount = (AtomicLong)this.connectionsPerClient.get(address);
                if (perIpCount == null && (old = this.connectionsPerClient.putIfAbsent(address, perIpCount = new AtomicLong(0L))) != null) {
                    perIpCount = old;
                }
                if (perIpCount.incrementAndGet() > perIpLimit) {
                    noSpamLogger.warn("Exceeded maximum native connection limit per ip of {} by using {} connections", perIpLimit, perIpCount);
                    ctx.close();
                    return;
                }
            }
            ctx.fireChannelActive();
        }
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.counter.decrementAndGet();
        InetAddress address = ((InetSocketAddress)ctx.channel().remoteAddress()).getAddress();
        AtomicLong count = (AtomicLong)this.connectionsPerClient.get(address);
        if (count != null && count.decrementAndGet() <= 0L) {
            this.connectionsPerClient.remove(address);
        }
        ctx.fireChannelInactive();
    }
}

