/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.transport.messages;

import com.google.common.collect.ImmutableMap;
import io.netty.buffer.ByteBuf;
import java.util.Map;
import org.apache.cassandra.audit.AuditLogEntry;
import org.apache.cassandra.audit.AuditLogManager;
import org.apache.cassandra.cql3.CQLStatement;
import org.apache.cassandra.cql3.ColumnSpecification;
import org.apache.cassandra.cql3.QueryHandler;
import org.apache.cassandra.cql3.QueryOptions;
import org.apache.cassandra.cql3.ResultSet;
import org.apache.cassandra.exceptions.PreparedQueryNotFoundException;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.service.QueryState;
import org.apache.cassandra.tracing.Tracing;
import org.apache.cassandra.transport.CBUtil;
import org.apache.cassandra.transport.Message;
import org.apache.cassandra.transport.ProtocolException;
import org.apache.cassandra.transport.ProtocolVersion;
import org.apache.cassandra.transport.messages.ErrorMessage;
import org.apache.cassandra.transport.messages.ResultMessage;
import org.apache.cassandra.utils.JVMStabilityInspector;
import org.apache.cassandra.utils.MD5Digest;

public class ExecuteMessage
extends Message.Request {
    public static final Message.Codec<ExecuteMessage> codec = new Message.Codec<ExecuteMessage>(){

        @Override
        public ExecuteMessage decode(ByteBuf body, ProtocolVersion version) {
            MD5Digest statementId = MD5Digest.wrap(CBUtil.readBytes(body));
            MD5Digest resultMetadataId = null;
            if (version.isGreaterOrEqualTo(ProtocolVersion.V5)) {
                resultMetadataId = MD5Digest.wrap(CBUtil.readBytes(body));
            }
            return new ExecuteMessage(statementId, resultMetadataId, QueryOptions.codec.decode(body, version));
        }

        @Override
        public void encode(ExecuteMessage msg, ByteBuf dest, ProtocolVersion version) {
            CBUtil.writeBytes(msg.statementId.bytes, dest);
            if (version.isGreaterOrEqualTo(ProtocolVersion.V5)) {
                CBUtil.writeBytes(msg.resultMetadataId.bytes, dest);
            }
            if (version == ProtocolVersion.V1) {
                CBUtil.writeValueList(msg.options.getValues(), dest);
                CBUtil.writeConsistencyLevel(msg.options.getConsistency(), dest);
            } else {
                QueryOptions.codec.encode(msg.options, dest, version);
            }
        }

        @Override
        public int encodedSize(ExecuteMessage msg, ProtocolVersion version) {
            int size = 0;
            size += CBUtil.sizeOfBytes(msg.statementId.bytes);
            if (version.isGreaterOrEqualTo(ProtocolVersion.V5)) {
                size += CBUtil.sizeOfBytes(msg.resultMetadataId.bytes);
            }
            if (version == ProtocolVersion.V1) {
                size += CBUtil.sizeOfValueList(msg.options.getValues());
                size += CBUtil.sizeOfConsistencyLevel(msg.options.getConsistency());
            } else {
                size += QueryOptions.codec.encodedSize(msg.options, version);
            }
            return size;
        }
    };
    public final MD5Digest statementId;
    public final MD5Digest resultMetadataId;
    public final QueryOptions options;

    public ExecuteMessage(MD5Digest statementId, MD5Digest resultMetadataId, QueryOptions options) {
        super(Message.Type.EXECUTE);
        this.statementId = statementId;
        this.options = options;
        this.resultMetadataId = resultMetadataId;
    }

    @Override
    protected boolean isTraceable() {
        return true;
    }

    @Override
    protected Message.Response execute(QueryState state, long queryStartNanoTime, boolean traceRequest) {
        AuditLogManager auditLogManager = AuditLogManager.getInstance();
        try {
            QueryHandler handler = ClientState.getCQLQueryHandler();
            QueryHandler.Prepared prepared = handler.getPrepared(this.statementId);
            if (prepared == null) {
                throw new PreparedQueryNotFoundException(this.statementId);
            }
            CQLStatement statement = prepared.statement;
            this.options.prepare(statement.getBindVariables());
            if (this.options.getPageSize() == 0) {
                throw new ProtocolException("The page size cannot be 0");
            }
            if (traceRequest) {
                this.traceQuery(state, prepared);
            }
            QueryOptions queryOptions = QueryOptions.addColumnSpecifications(this.options, prepared.statement.getBindVariables());
            long requestStartTime = auditLogManager.isLoggingEnabled() ? System.currentTimeMillis() : 0L;
            ResultMessage response = handler.processPrepared(statement, state, queryOptions, this.getCustomPayload(), queryStartNanoTime);
            if (auditLogManager.isLoggingEnabled()) {
                this.logSuccess(state, prepared, requestStartTime);
            }
            if (response instanceof ResultMessage.Rows) {
                ResultMessage.Rows rows = (ResultMessage.Rows)response;
                ResultSet.ResultMetadata resultMetadata = rows.result.metadata;
                if (this.options.getProtocolVersion().isGreaterOrEqualTo(ProtocolVersion.V5)) {
                    if (!statement.hasConditions()) {
                        if (!resultMetadata.getResultMetadataId().equals(this.resultMetadataId)) {
                            resultMetadata.setMetadataChanged();
                        } else if (this.options.skipMetadata()) {
                            resultMetadata.setSkipMetadata();
                        }
                    }
                } else if (this.options.skipMetadata() && prepared.resultMetadataId.equals(resultMetadata.getResultMetadataId())) {
                    resultMetadata.setSkipMetadata();
                }
            }
            return response;
        }
        catch (Exception e) {
            if (auditLogManager.isAuditingEnabled()) {
                this.logException(state, e);
            }
            JVMStabilityInspector.inspectThrowable(e);
            return ErrorMessage.fromException(e);
        }
    }

    private void traceQuery(QueryState state, QueryHandler.Prepared prepared) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        if (this.options.getPageSize() > 0) {
            builder.put((Object)"page_size", (Object)Integer.toString(this.options.getPageSize()));
        }
        if (this.options.getConsistency() != null) {
            builder.put((Object)"consistency_level", (Object)this.options.getConsistency().name());
        }
        if (this.options.getSerialConsistency() != null) {
            builder.put((Object)"serial_consistency_level", (Object)this.options.getSerialConsistency().name());
        }
        builder.put((Object)"query", (Object)prepared.rawCQLStatement);
        for (int i = 0; i < prepared.statement.getBindVariables().size(); ++i) {
            ColumnSpecification cs = prepared.statement.getBindVariables().get(i);
            String boundName = cs.name.toString();
            String boundValue = cs.type.asCQL3Type().toCQLLiteral(this.options.getValues().get(i), this.options.getProtocolVersion());
            if (boundValue.length() > 1000) {
                boundValue = boundValue.substring(0, 1000) + "...'";
            }
            builder.put((Object)("bound_var_" + i + '_' + boundName), (Object)boundValue);
        }
        Tracing.instance.begin("Execute CQL3 prepared query", state.getClientAddress(), (Map<String, String>)builder.build());
    }

    private void logSuccess(QueryState state, QueryHandler.Prepared prepared, long requestStartTime) {
        AuditLogEntry entry = new AuditLogEntry.Builder(state).setType(prepared.statement.getAuditLogContext().auditLogEntryType).setOperation(prepared.rawCQLStatement).setTimestamp(requestStartTime).setScope(prepared.statement).setKeyspace(state, prepared.statement).setOptions(this.options).build();
        AuditLogManager.getInstance().log(entry);
    }

    private void logException(QueryState state, Exception e) {
        if (e instanceof PreparedQueryNotFoundException) {
            AuditLogEntry entry = new AuditLogEntry.Builder(state).setOperation(this.toString()).setOptions(this.options).build();
            AuditLogManager.getInstance().log(entry, e);
            return;
        }
        QueryHandler.Prepared prepared = ClientState.getCQLQueryHandler().getPrepared(this.statementId);
        if (prepared != null) {
            AuditLogEntry entry = new AuditLogEntry.Builder(state).setOperation(this.toString()).setType(prepared.statement.getAuditLogContext().auditLogEntryType).setScope(prepared.statement).setKeyspace(state, prepared.statement).setOptions(this.options).build();
            AuditLogManager.getInstance().log(entry, e);
        }
    }

    public String toString() {
        return String.format("EXECUTE %s with %d values at consistency %s", new Object[]{this.statementId, this.options.getValues().size(), this.options.getConsistency()});
    }
}

