/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apache.cassandra.io.FSReadError;
import org.apache.cassandra.io.FSWriteError;

public final class Throwables {
    public static boolean isCausedBy(Throwable t, Predicate<Throwable> cause) {
        return cause.test(t) || t.getCause() != null && cause.test(t.getCause());
    }

    public static <T extends Throwable> T merge(T existingFail, T newFail) {
        if (existingFail == null) {
            return newFail;
        }
        existingFail.addSuppressed(newFail);
        return existingFail;
    }

    public static void maybeFail(Throwable fail) {
        if (Throwables.failIfCanCast(fail, null)) {
            throw new RuntimeException(fail);
        }
    }

    public static <T extends Throwable> void maybeFail(Throwable fail, Class<T> checked) throws T {
        if (Throwables.failIfCanCast(fail, checked)) {
            throw new RuntimeException(fail);
        }
    }

    public static <T extends Throwable> boolean failIfCanCast(Throwable fail, Class<T> checked) throws T {
        if (fail == null) {
            return false;
        }
        if (fail instanceof Error) {
            throw (Error)fail;
        }
        if (fail instanceof RuntimeException) {
            throw (RuntimeException)fail;
        }
        if (checked != null && checked.isInstance(fail)) {
            throw (Throwable)checked.cast(fail);
        }
        return true;
    }

    @SafeVarargs
    public static <E extends Exception> void maybeFail(DiscreteAction<? extends E> ... actions) {
        Throwables.maybeFail(Throwables.perform(null, Stream.of(actions)));
    }

    @SafeVarargs
    public static <E extends Exception> void perform(DiscreteAction<? extends E> ... actions) throws E {
        Throwables.perform(Stream.of(actions));
    }

    public static <E extends Exception> void perform(Stream<? extends DiscreteAction<? extends E>> stream, DiscreteAction<? extends E> ... extra) throws E {
        Throwables.perform(Stream.concat(stream, Stream.of(extra)));
    }

    public static <E extends Exception> void perform(Stream<DiscreteAction<? extends E>> actions) throws E {
        Throwable fail = Throwables.perform(null, actions);
        if (Throwables.failIfCanCast(fail, null)) {
            throw (Exception)fail;
        }
    }

    public static Throwable perform(Throwable accumulate, DiscreteAction<?> ... actions) {
        return Throwables.perform(accumulate, Arrays.stream(actions));
    }

    public static Throwable perform(Throwable accumulate, Stream<? extends DiscreteAction<?>> actions) {
        return Throwables.perform(accumulate, actions.iterator());
    }

    public static Throwable perform(Throwable accumulate, Iterator<? extends DiscreteAction<?>> actions) {
        while (actions.hasNext()) {
            DiscreteAction<?> action = actions.next();
            try {
                action.perform();
            }
            catch (Throwable t) {
                accumulate = Throwables.merge(accumulate, t);
            }
        }
        return accumulate;
    }

    @SafeVarargs
    public static void perform(File against, FileOpType opType, DiscreteAction<? extends IOException> ... actions) {
        Throwables.perform(against.getPath(), opType, actions);
    }

    @SafeVarargs
    public static void perform(String filePath, FileOpType opType, DiscreteAction<? extends IOException> ... actions) {
        Throwables.maybeFail(Throwables.perform(null, filePath, opType, actions));
    }

    @SafeVarargs
    public static Throwable perform(Throwable accumulate, String filePath, FileOpType opType, DiscreteAction<? extends IOException> ... actions) {
        return Throwables.perform(accumulate, filePath, opType, Arrays.stream(actions));
    }

    public static Throwable perform(Throwable accumulate, String filePath, FileOpType opType, Stream<DiscreteAction<? extends IOException>> actions) {
        return Throwables.perform(accumulate, actions.map(action -> () -> {
            try {
                action.perform();
            }
            catch (IOException e) {
                throw opType == FileOpType.WRITE ? new FSWriteError((Throwable)e, filePath) : new FSReadError((Throwable)e, filePath);
            }
        }));
    }

    public static Throwable close(Throwable accumulate, Iterable<? extends AutoCloseable> closeables) {
        for (AutoCloseable autoCloseable : closeables) {
            try {
                autoCloseable.close();
            }
            catch (Throwable t) {
                accumulate = Throwables.merge(accumulate, t);
            }
        }
        return accumulate;
    }

    public static Optional<IOException> extractIOExceptionCause(Throwable t) {
        if (t instanceof IOException) {
            return Optional.of((IOException)t);
        }
        Throwable cause = t;
        while ((cause = cause.getCause()) != null) {
            if (!(cause instanceof IOException)) continue;
            return Optional.of((IOException)cause);
        }
        return Optional.empty();
    }

    public static interface DiscreteAction<E extends Exception> {
        public void perform() throws E;
    }

    public static enum FileOpType {
        READ,
        WRITE;

    }
}

