/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils.memory;

import com.sun.jna.Native;
import java.lang.reflect.Field;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.cassandra.utils.Architecture;
import sun.misc.Unsafe;

public abstract class MemoryUtil {
    private static final long UNSAFE_COPY_THRESHOLD = 0x100000L;
    private static final Unsafe unsafe;
    private static final Class<?> DIRECT_BYTE_BUFFER_CLASS;
    private static final Class<?> RO_DIRECT_BYTE_BUFFER_CLASS;
    private static final long DIRECT_BYTE_BUFFER_ADDRESS_OFFSET;
    private static final long DIRECT_BYTE_BUFFER_CAPACITY_OFFSET;
    private static final long DIRECT_BYTE_BUFFER_LIMIT_OFFSET;
    private static final long DIRECT_BYTE_BUFFER_POSITION_OFFSET;
    private static final long DIRECT_BYTE_BUFFER_ATTACHMENT_OFFSET;
    private static final Class<?> BYTE_BUFFER_CLASS;
    private static final long BYTE_BUFFER_OFFSET_OFFSET;
    private static final long BYTE_BUFFER_HB_OFFSET;
    private static final long BYTE_ARRAY_BASE_OFFSET;
    private static final boolean BIG_ENDIAN;
    public static final boolean INVERTED_ORDER;

    public static int pageSize() {
        return unsafe.pageSize();
    }

    public static long getAddress(ByteBuffer buffer) {
        assert (buffer.getClass() == DIRECT_BYTE_BUFFER_CLASS);
        return unsafe.getLong(buffer, DIRECT_BYTE_BUFFER_ADDRESS_OFFSET);
    }

    public static long allocate(long size) {
        return Native.malloc((long)size);
    }

    public static void free(long peer) {
        Native.free((long)peer);
    }

    public static void setByte(long address, byte b) {
        unsafe.putByte(address, b);
    }

    public static void setByte(long address, int count, byte b) {
        unsafe.setMemory(address, count, b);
    }

    public static void setShort(long address, short s) {
        unsafe.putShort(address, s);
    }

    public static void setInt(long address, int l) {
        if (Architecture.IS_UNALIGNED) {
            unsafe.putInt(address, l);
        } else {
            MemoryUtil.putIntByByte(address, l);
        }
    }

    public static void setLong(long address, long l) {
        if (Architecture.IS_UNALIGNED) {
            unsafe.putLong(address, l);
        } else {
            MemoryUtil.putLongByByte(address, l);
        }
    }

    public static byte getByte(long address) {
        return unsafe.getByte(address);
    }

    public static int getShort(long address) {
        return (Architecture.IS_UNALIGNED ? (int)unsafe.getShort(address) : MemoryUtil.getShortByByte(address)) & 0xFFFF;
    }

    public static int getInt(long address) {
        return Architecture.IS_UNALIGNED ? unsafe.getInt(address) : MemoryUtil.getIntByByte(address);
    }

    public static long getLong(long address) {
        return Architecture.IS_UNALIGNED ? unsafe.getLong(address) : MemoryUtil.getLongByByte(address);
    }

    public static ByteBuffer getByteBuffer(long address, int length) {
        return MemoryUtil.getByteBuffer(address, length, ByteOrder.nativeOrder());
    }

    public static ByteBuffer getByteBuffer(long address, int length, ByteOrder order) {
        ByteBuffer instance = MemoryUtil.getHollowDirectByteBuffer(order);
        MemoryUtil.setDirectByteBuffer(instance, address, length);
        return instance;
    }

    public static ByteBuffer getHollowDirectByteBuffer() {
        return MemoryUtil.getHollowDirectByteBuffer(ByteOrder.nativeOrder());
    }

    public static ByteBuffer getHollowDirectByteBuffer(ByteOrder order) {
        ByteBuffer instance;
        try {
            instance = (ByteBuffer)unsafe.allocateInstance(DIRECT_BYTE_BUFFER_CLASS);
        }
        catch (InstantiationException e) {
            throw new AssertionError((Object)e);
        }
        instance.order(order);
        return instance;
    }

    public static ByteBuffer getHollowByteBuffer() {
        ByteBuffer instance;
        try {
            instance = (ByteBuffer)unsafe.allocateInstance(BYTE_BUFFER_CLASS);
        }
        catch (InstantiationException e) {
            throw new AssertionError((Object)e);
        }
        instance.order(ByteOrder.nativeOrder());
        return instance;
    }

    public static Object getAttachment(ByteBuffer instance) {
        assert (instance.getClass() == DIRECT_BYTE_BUFFER_CLASS);
        return unsafe.getObject(instance, DIRECT_BYTE_BUFFER_ATTACHMENT_OFFSET);
    }

    public static void setAttachment(ByteBuffer instance, Object next) {
        assert (instance.getClass() == DIRECT_BYTE_BUFFER_CLASS);
        unsafe.putObject(instance, DIRECT_BYTE_BUFFER_ATTACHMENT_OFFSET, next);
    }

    public static ByteBuffer duplicateDirectByteBuffer(ByteBuffer source, ByteBuffer hollowBuffer) {
        assert (source.getClass() == DIRECT_BYTE_BUFFER_CLASS || source.getClass() == RO_DIRECT_BYTE_BUFFER_CLASS);
        unsafe.putLong(hollowBuffer, DIRECT_BYTE_BUFFER_ADDRESS_OFFSET, unsafe.getLong(source, DIRECT_BYTE_BUFFER_ADDRESS_OFFSET));
        unsafe.putInt(hollowBuffer, DIRECT_BYTE_BUFFER_POSITION_OFFSET, unsafe.getInt(source, DIRECT_BYTE_BUFFER_POSITION_OFFSET));
        unsafe.putInt(hollowBuffer, DIRECT_BYTE_BUFFER_LIMIT_OFFSET, unsafe.getInt(source, DIRECT_BYTE_BUFFER_LIMIT_OFFSET));
        unsafe.putInt(hollowBuffer, DIRECT_BYTE_BUFFER_CAPACITY_OFFSET, unsafe.getInt(source, DIRECT_BYTE_BUFFER_CAPACITY_OFFSET));
        return hollowBuffer;
    }

    public static ByteBuffer sliceDirectByteBuffer(ByteBuffer source, ByteBuffer hollowBuffer, int offset, int length) {
        assert (source.getClass() == DIRECT_BYTE_BUFFER_CLASS || source.getClass() == RO_DIRECT_BYTE_BUFFER_CLASS);
        MemoryUtil.setDirectByteBuffer(hollowBuffer, (long)offset + unsafe.getLong(source, DIRECT_BYTE_BUFFER_ADDRESS_OFFSET), length);
        return hollowBuffer;
    }

    public static void setDirectByteBuffer(ByteBuffer instance, long address, int length) {
        unsafe.putLong(instance, DIRECT_BYTE_BUFFER_ADDRESS_OFFSET, address);
        unsafe.putInt(instance, DIRECT_BYTE_BUFFER_POSITION_OFFSET, 0);
        unsafe.putInt(instance, DIRECT_BYTE_BUFFER_CAPACITY_OFFSET, length);
        unsafe.putInt(instance, DIRECT_BYTE_BUFFER_LIMIT_OFFSET, length);
    }

    public static void setByteBufferCapacity(ByteBuffer instance, int capacity) {
        unsafe.putInt(instance, DIRECT_BYTE_BUFFER_CAPACITY_OFFSET, capacity);
    }

    public static long getLongByByte(long address) {
        if (BIG_ENDIAN) {
            return (long)unsafe.getByte(address) << 56 | ((long)unsafe.getByte(address + 1L) & 0xFFL) << 48 | ((long)unsafe.getByte(address + 2L) & 0xFFL) << 40 | ((long)unsafe.getByte(address + 3L) & 0xFFL) << 32 | ((long)unsafe.getByte(address + 4L) & 0xFFL) << 24 | ((long)unsafe.getByte(address + 5L) & 0xFFL) << 16 | ((long)unsafe.getByte(address + 6L) & 0xFFL) << 8 | (long)unsafe.getByte(address + 7L) & 0xFFL;
        }
        return (long)unsafe.getByte(address + 7L) << 56 | ((long)unsafe.getByte(address + 6L) & 0xFFL) << 48 | ((long)unsafe.getByte(address + 5L) & 0xFFL) << 40 | ((long)unsafe.getByte(address + 4L) & 0xFFL) << 32 | ((long)unsafe.getByte(address + 3L) & 0xFFL) << 24 | ((long)unsafe.getByte(address + 2L) & 0xFFL) << 16 | ((long)unsafe.getByte(address + 1L) & 0xFFL) << 8 | (long)unsafe.getByte(address) & 0xFFL;
    }

    public static int getIntByByte(long address) {
        if (BIG_ENDIAN) {
            return unsafe.getByte(address) << 24 | (unsafe.getByte(address + 1L) & 0xFF) << 16 | (unsafe.getByte(address + 2L) & 0xFF) << 8 | unsafe.getByte(address + 3L) & 0xFF;
        }
        return unsafe.getByte(address + 3L) << 24 | (unsafe.getByte(address + 2L) & 0xFF) << 16 | (unsafe.getByte(address + 1L) & 0xFF) << 8 | unsafe.getByte(address) & 0xFF;
    }

    public static int getShortByByte(long address) {
        if (BIG_ENDIAN) {
            return unsafe.getByte(address) << 8 | unsafe.getByte(address + 1L) & 0xFF;
        }
        return unsafe.getByte(address + 1L) << 8 | unsafe.getByte(address) & 0xFF;
    }

    public static void putLongByByte(long address, long value) {
        if (BIG_ENDIAN) {
            unsafe.putByte(address, (byte)(value >> 56));
            unsafe.putByte(address + 1L, (byte)(value >> 48));
            unsafe.putByte(address + 2L, (byte)(value >> 40));
            unsafe.putByte(address + 3L, (byte)(value >> 32));
            unsafe.putByte(address + 4L, (byte)(value >> 24));
            unsafe.putByte(address + 5L, (byte)(value >> 16));
            unsafe.putByte(address + 6L, (byte)(value >> 8));
            unsafe.putByte(address + 7L, (byte)value);
        } else {
            unsafe.putByte(address + 7L, (byte)(value >> 56));
            unsafe.putByte(address + 6L, (byte)(value >> 48));
            unsafe.putByte(address + 5L, (byte)(value >> 40));
            unsafe.putByte(address + 4L, (byte)(value >> 32));
            unsafe.putByte(address + 3L, (byte)(value >> 24));
            unsafe.putByte(address + 2L, (byte)(value >> 16));
            unsafe.putByte(address + 1L, (byte)(value >> 8));
            unsafe.putByte(address, (byte)value);
        }
    }

    public static void putIntByByte(long address, int value) {
        if (BIG_ENDIAN) {
            unsafe.putByte(address, (byte)(value >> 24));
            unsafe.putByte(address + 1L, (byte)(value >> 16));
            unsafe.putByte(address + 2L, (byte)(value >> 8));
            unsafe.putByte(address + 3L, (byte)value);
        } else {
            unsafe.putByte(address + 3L, (byte)(value >> 24));
            unsafe.putByte(address + 2L, (byte)(value >> 16));
            unsafe.putByte(address + 1L, (byte)(value >> 8));
            unsafe.putByte(address, (byte)value);
        }
    }

    public static void setBytes(long address, ByteBuffer buffer) {
        int start = buffer.position();
        int count = buffer.limit() - start;
        if (count == 0) {
            return;
        }
        if (buffer.isDirect()) {
            MemoryUtil.setBytes(MemoryUtil.getAddress(buffer) + (long)start, address, count);
        } else {
            MemoryUtil.setBytes(address, buffer.array(), buffer.arrayOffset() + start, count);
        }
    }

    public static void setBytes(long address, byte[] buffer, int bufferOffset, int count) {
        assert (buffer != null);
        assert (bufferOffset >= 0 && count >= 0 && bufferOffset + count <= buffer.length);
        MemoryUtil.setBytes(buffer, bufferOffset, address, (long)count);
    }

    public static void setBytes(long src, long trg, long count) {
        while (count > 0L) {
            long size = count > 0x100000L ? 0x100000L : count;
            unsafe.copyMemory(src, trg, size);
            count -= size;
            src += size;
            trg += size;
        }
    }

    public static void setBytes(byte[] src, int offset, long trg, long count) {
        while (count > 0L) {
            long size = count > 0x100000L ? 0x100000L : count;
            unsafe.copyMemory(src, BYTE_ARRAY_BASE_OFFSET + (long)offset, null, trg, size);
            count -= size;
            offset = (int)((long)offset + size);
            trg += size;
        }
    }

    public static void getBytes(long address, byte[] buffer, int bufferOffset, int count) {
        if (buffer == null) {
            throw new NullPointerException();
        }
        if (bufferOffset < 0 || count < 0 || count > buffer.length - bufferOffset) {
            throw new IndexOutOfBoundsException();
        }
        if (count == 0) {
            return;
        }
        unsafe.copyMemory(null, address, buffer, BYTE_ARRAY_BASE_OFFSET + (long)bufferOffset, count);
    }

    static {
        BIG_ENDIAN = ByteOrder.nativeOrder().equals(ByteOrder.BIG_ENDIAN);
        INVERTED_ORDER = Architecture.IS_UNALIGNED && !BIG_ENDIAN;
        try {
            Field field = Unsafe.class.getDeclaredField("theUnsafe");
            field.setAccessible(true);
            unsafe = (Unsafe)field.get(null);
            Class<?> clazz = ByteBuffer.allocateDirect(0).getClass();
            DIRECT_BYTE_BUFFER_ADDRESS_OFFSET = unsafe.objectFieldOffset(Buffer.class.getDeclaredField("address"));
            DIRECT_BYTE_BUFFER_CAPACITY_OFFSET = unsafe.objectFieldOffset(Buffer.class.getDeclaredField("capacity"));
            DIRECT_BYTE_BUFFER_LIMIT_OFFSET = unsafe.objectFieldOffset(Buffer.class.getDeclaredField("limit"));
            DIRECT_BYTE_BUFFER_POSITION_OFFSET = unsafe.objectFieldOffset(Buffer.class.getDeclaredField("position"));
            DIRECT_BYTE_BUFFER_ATTACHMENT_OFFSET = unsafe.objectFieldOffset(clazz.getDeclaredField("att"));
            DIRECT_BYTE_BUFFER_CLASS = clazz;
            RO_DIRECT_BYTE_BUFFER_CLASS = ByteBuffer.allocateDirect(0).asReadOnlyBuffer().getClass();
            clazz = ByteBuffer.allocate(0).getClass();
            BYTE_BUFFER_OFFSET_OFFSET = unsafe.objectFieldOffset(ByteBuffer.class.getDeclaredField("offset"));
            BYTE_BUFFER_HB_OFFSET = unsafe.objectFieldOffset(ByteBuffer.class.getDeclaredField("hb"));
            BYTE_BUFFER_CLASS = clazz;
            BYTE_ARRAY_BASE_OFFSET = unsafe.arrayBaseOffset(byte[].class);
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
    }
}

