/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3;

import java.nio.ByteBuffer;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.serializers.MarshalException;

public abstract class Validation {
    public static void validateKey(TableMetadata metadata, ByteBuffer key) {
        if (key == null || key.remaining() == 0) {
            throw new InvalidRequestException("Key may not be empty");
        }
        if (key.remaining() > 65535) {
            throw new InvalidRequestException("Key length of " + key.remaining() + " is longer than maximum of 65535");
        }
        try {
            metadata.partitionKeyType.validate(key);
        }
        catch (MarshalException e) {
            throw new InvalidRequestException(e.getMessage());
        }
    }
}

